/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.infra.metadata.mapper.type;

import java.util.Collection;
import java.util.Collections;
import java.util.stream.Collectors;
import org.apache.shardingsphere.infra.metadata.mapper.SQLStatementEventMapper;
import org.apache.shardingsphere.infra.metadata.mapper.event.dcl.impl.GrantStatementEvent;
import org.apache.shardingsphere.infra.metadata.user.ShardingSphereUser;
import org.apache.shardingsphere.sql.parser.sql.common.statement.SQLStatement;
import org.apache.shardingsphere.sql.parser.sql.dialect.statement.mysql.dcl.MySQLGrantStatement;

public final class GrantStatementEventMapper
implements SQLStatementEventMapper {
    @Override
    public GrantStatementEvent map(SQLStatement sqlStatement) {
        if (sqlStatement instanceof MySQLGrantStatement) {
            return new GrantStatementEvent(this.getUsers((MySQLGrantStatement)sqlStatement));
        }
        return new GrantStatementEvent(Collections.emptyList());
    }

    private Collection<ShardingSphereUser> getUsers(MySQLGrantStatement sqlStatement) {
        return sqlStatement.getUsers().stream().map((? super T each) -> new ShardingSphereUser(each.getUser(), each.getAuth(), each.getHost())).collect(Collectors.toList());
    }
}

