/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.infra.optimize.converter.statement;

import java.util.Comparator;
import java.util.LinkedList;
import java.util.Optional;
import org.apache.calcite.sql.SqlNode;
import org.apache.calcite.sql.SqlNodeList;
import org.apache.calcite.sql.SqlOrderBy;
import org.apache.calcite.sql.SqlSelect;
import org.apache.calcite.sql.parser.SqlParserPos;
import org.apache.shardingsphere.infra.optimize.converter.context.ConverterContext;
import org.apache.shardingsphere.infra.optimize.converter.segment.from.TableConverter;
import org.apache.shardingsphere.infra.optimize.converter.segment.groupby.GroupByConverter;
import org.apache.shardingsphere.infra.optimize.converter.segment.groupby.HavingConverter;
import org.apache.shardingsphere.infra.optimize.converter.segment.limit.PaginationValueSQLConverter;
import org.apache.shardingsphere.infra.optimize.converter.segment.orderby.OrderByConverter;
import org.apache.shardingsphere.infra.optimize.converter.segment.projection.DistinctConverter;
import org.apache.shardingsphere.infra.optimize.converter.segment.projection.ProjectionsConverter;
import org.apache.shardingsphere.infra.optimize.converter.segment.where.WhereConverter;
import org.apache.shardingsphere.infra.optimize.converter.statement.SQLStatementConverter;
import org.apache.shardingsphere.sql.parser.sql.common.segment.SQLSegment;
import org.apache.shardingsphere.sql.parser.sql.common.segment.dml.item.ProjectionsSegment;
import org.apache.shardingsphere.sql.parser.sql.common.segment.dml.order.GroupBySegment;
import org.apache.shardingsphere.sql.parser.sql.common.segment.dml.order.OrderBySegment;
import org.apache.shardingsphere.sql.parser.sql.common.segment.dml.pagination.PaginationValueSegment;
import org.apache.shardingsphere.sql.parser.sql.common.segment.dml.pagination.limit.LimitSegment;
import org.apache.shardingsphere.sql.parser.sql.common.segment.dml.predicate.HavingSegment;
import org.apache.shardingsphere.sql.parser.sql.common.segment.dml.predicate.WhereSegment;
import org.apache.shardingsphere.sql.parser.sql.common.statement.dml.SelectStatement;
import org.apache.shardingsphere.sql.parser.sql.dialect.handler.dml.SelectStatementHandler;
import org.apache.shardingsphere.sql.parser.sql.dialect.statement.mysql.dml.MySQLSelectStatement;

public final class SelectStatementConverter
implements SQLStatementConverter<SelectStatement, SqlNode> {
    private static final int LIMIT_SEGMENT_LENGTH = 6;

    @Override
    public SqlNode convertToSQLNode(SelectStatement selectStatement) {
        SqlNodeList distinct = new DistinctConverter().convertToSQLNode(selectStatement.getProjections()).orElse(null);
        SqlNodeList projection = new ProjectionsConverter().convertToSQLNode(selectStatement.getProjections()).orElseThrow(IllegalStateException::new);
        SqlNode from = new TableConverter().convertToSQLNode(selectStatement.getFrom()).orElse(null);
        SqlNode where = selectStatement.getWhere().flatMap(optional -> new WhereConverter().convertToSQLNode((WhereSegment)optional)).orElse(null);
        SqlNodeList groupBy = selectStatement.getGroupBy().flatMap(optional -> new GroupByConverter().convertToSQLNode((GroupBySegment)optional)).orElse(null);
        SqlNode having = selectStatement.getHaving().flatMap(optional -> new HavingConverter().convertToSQLNode((HavingSegment)optional)).orElse(null);
        SqlNodeList orderBy = selectStatement.getOrderBy().flatMap(optional -> new OrderByConverter().convertToSQLNode((OrderBySegment)optional)).orElse(SqlNodeList.EMPTY);
        Optional limit = SelectStatementHandler.getLimitSegment((SelectStatement)selectStatement);
        ConverterContext context = new ConverterContext();
        SqlSelect sqlSelect = new SqlSelect(SqlParserPos.ZERO, distinct, projection, from, where, groupBy, having, SqlNodeList.EMPTY, null, null, null, SqlNodeList.EMPTY);
        if (limit.isPresent()) {
            SqlNode offset = ((LimitSegment)limit.get()).getOffset().flatMap(optional -> new PaginationValueSQLConverter(context).convertToSQLNode((PaginationValueSegment)optional)).orElse(null);
            SqlNode rowCount = ((LimitSegment)limit.get()).getRowCount().flatMap(optional -> new PaginationValueSQLConverter(context).convertToSQLNode((PaginationValueSegment)optional)).orElse(null);
            return new SqlOrderBy(SqlParserPos.ZERO, (SqlNode)sqlSelect, orderBy, offset, rowCount);
        }
        return !orderBy.isEmpty() ? new SqlOrderBy(SqlParserPos.ZERO, (SqlNode)sqlSelect, orderBy, null, null) : sqlSelect;
    }

    @Override
    public SelectStatement convertToSQLStatement(SqlNode sqlNode) {
        SqlSelect sqlSelect = sqlNode instanceof SqlOrderBy ? (SqlSelect)((SqlOrderBy)sqlNode).query : (SqlSelect)sqlNode;
        ProjectionsSegment projections = new ProjectionsConverter().convertToSQLSegment(sqlSelect.getSelectList()).orElseThrow(IllegalStateException::new);
        projections.setDistinctRow(sqlSelect.isDistinct());
        MySQLSelectStatement result = new MySQLSelectStatement();
        result.setProjections(projections);
        new TableConverter().convertToSQLSegment(sqlSelect.getFrom()).ifPresent(arg_0 -> ((MySQLSelectStatement)result).setFrom(arg_0));
        new WhereConverter().convertToSQLSegment(sqlSelect.getWhere()).ifPresent(arg_0 -> ((MySQLSelectStatement)result).setWhere(arg_0));
        new GroupByConverter().convertToSQLSegment(sqlSelect.getGroup()).ifPresent(arg_0 -> ((MySQLSelectStatement)result).setGroupBy(arg_0));
        new HavingConverter().convertToSQLSegment(sqlSelect.getHaving()).ifPresent(arg_0 -> ((MySQLSelectStatement)result).setHaving(arg_0));
        ConverterContext context = new ConverterContext();
        if (sqlNode instanceof SqlOrderBy) {
            SqlOrderBy sqlOrderBy = (SqlOrderBy)sqlNode;
            new OrderByConverter().convertToSQLSegment(sqlOrderBy.orderList).ifPresent(arg_0 -> ((MySQLSelectStatement)result).setOrderBy(arg_0));
            this.createLimitSegment(sqlOrderBy, context).ifPresent(arg_0 -> ((MySQLSelectStatement)result).setLimit(arg_0));
        }
        result.setParameterCount(context.getParameterCount().get());
        return result;
    }

    private Optional<LimitSegment> createLimitSegment(SqlOrderBy sqlOrderBy, ConverterContext context) {
        if (null == sqlOrderBy.offset && null == sqlOrderBy.fetch) {
            return Optional.empty();
        }
        Optional<Integer> offset = Optional.ofNullable(sqlOrderBy.offset).flatMap(optional -> new PaginationValueSQLConverter(context).convertToSQLSegment((SqlNode)optional));
        Optional<Integer> rowCount = Optional.ofNullable(sqlOrderBy.fetch).flatMap(optional -> new PaginationValueSQLConverter(context).convertToSQLSegment((SqlNode)optional));
        LinkedList startIndexes = new LinkedList();
        LinkedList stopIndexes = new LinkedList();
        offset.map(SQLSegment::getStartIndex).ifPresent(startIndexes::add);
        rowCount.map(SQLSegment::getStartIndex).ifPresent(startIndexes::add);
        offset.map(SQLSegment::getStopIndex).ifPresent(stopIndexes::add);
        rowCount.map(SQLSegment::getStopIndex).ifPresent(stopIndexes::add);
        int startIndex = startIndexes.stream().min(Comparator.naturalOrder()).orElse(0) - 6;
        int stopIndex = stopIndexes.stream().max(Comparator.naturalOrder()).orElse(0);
        return Optional.of(new LimitSegment(startIndex, stopIndex, (PaginationValueSegment)offset.orElse(null), (PaginationValueSegment)rowCount.orElse(null)));
    }
}

