/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.infra.optimize.metadata;

import java.util.LinkedHashMap;
import java.util.Map;
import lombok.Generated;
import org.apache.shardingsphere.infra.metadata.schema.model.TableMetaData;
import org.apache.shardingsphere.infra.optimize.metadata.FederationTableMetaData;

public final class FederationSchemaMetaData {
    private final String name;
    private final Map<String, FederationTableMetaData> tables = new LinkedHashMap<String, FederationTableMetaData>();

    public FederationSchemaMetaData(String name, Map<String, TableMetaData> metaData) {
        this.name = name;
        for (Map.Entry<String, TableMetaData> entry : metaData.entrySet()) {
            this.tables.put(entry.getKey(), new FederationTableMetaData(entry.getValue().getName(), entry.getValue()));
        }
    }

    public synchronized void update(TableMetaData metaData) {
        this.tables.put(metaData.getName().toLowerCase(), new FederationTableMetaData(metaData.getName(), metaData));
    }

    public synchronized void remove(String tableName) {
        this.tables.remove(tableName.toLowerCase());
    }

    @Generated
    public String getName() {
        return this.name;
    }

    @Generated
    public Map<String, FederationTableMetaData> getTables() {
        return this.tables;
    }
}

