/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.driver.executor;

import java.sql.SQLException;
import java.util.Collection;
import java.util.List;
import lombok.Generated;
import org.apache.shardingsphere.driver.executor.JDBCLockEngine;
import org.apache.shardingsphere.driver.executor.callback.ExecuteQueryCallback;
import org.apache.shardingsphere.infra.binder.LogicSQL;
import org.apache.shardingsphere.infra.binder.statement.SQLStatementContext;
import org.apache.shardingsphere.infra.config.properties.ConfigurationProperties;
import org.apache.shardingsphere.infra.executor.kernel.model.ExecutionGroupContext;
import org.apache.shardingsphere.infra.executor.sql.execute.engine.driver.jdbc.JDBCExecutionUnit;
import org.apache.shardingsphere.infra.executor.sql.execute.engine.driver.jdbc.JDBCExecutor;
import org.apache.shardingsphere.infra.executor.sql.execute.engine.driver.jdbc.JDBCExecutorCallback;
import org.apache.shardingsphere.infra.executor.sql.execute.result.query.QueryResult;
import org.apache.shardingsphere.infra.executor.sql.process.ExecuteProcessEngine;
import org.apache.shardingsphere.infra.route.context.RouteUnit;
import org.apache.shardingsphere.infra.rule.ShardingSphereRule;
import org.apache.shardingsphere.infra.rule.identifier.type.DataNodeContainedRule;
import org.apache.shardingsphere.mode.metadata.MetaDataContexts;

public final class DriverJDBCExecutor {
    private final String schemaName;
    private final MetaDataContexts metaDataContexts;
    private final JDBCExecutor jdbcExecutor;
    private final JDBCLockEngine jdbcLockEngine;

    public DriverJDBCExecutor(String schemaName, MetaDataContexts metaDataContexts, JDBCExecutor jdbcExecutor) {
        this.schemaName = schemaName;
        this.metaDataContexts = metaDataContexts;
        this.jdbcExecutor = jdbcExecutor;
        this.jdbcLockEngine = new JDBCLockEngine(schemaName, metaDataContexts, jdbcExecutor);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<QueryResult> executeQuery(ExecutionGroupContext<JDBCExecutionUnit> executionGroupContext, LogicSQL logicSQL, ExecuteQueryCallback callback) throws SQLException {
        try {
            ExecuteProcessEngine.initialize((LogicSQL)logicSQL, executionGroupContext, (ConfigurationProperties)this.metaDataContexts.getProps());
            List result = this.jdbcExecutor.execute(executionGroupContext, (JDBCExecutorCallback)callback);
            ExecuteProcessEngine.finish((String)executionGroupContext.getExecutionID());
            List list = result;
            return list;
        }
        finally {
            ExecuteProcessEngine.clean();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int executeUpdate(ExecutionGroupContext<JDBCExecutionUnit> executionGroupContext, LogicSQL logicSQL, Collection<RouteUnit> routeUnits, JDBCExecutorCallback<Integer> callback) throws SQLException {
        try {
            ExecuteProcessEngine.initialize((LogicSQL)logicSQL, executionGroupContext, (ConfigurationProperties)this.metaDataContexts.getProps());
            SQLStatementContext sqlStatementContext = logicSQL.getSqlStatementContext();
            List<Integer> results = this.jdbcLockEngine.execute(executionGroupContext, sqlStatementContext, routeUnits, callback);
            int result = this.isNeedAccumulate(this.metaDataContexts.getMetaData(this.schemaName).getRuleMetaData().getRules(), sqlStatementContext) ? this.accumulate(results) : results.get(0).intValue();
            ExecuteProcessEngine.finish((String)executionGroupContext.getExecutionID());
            int n = result;
            return n;
        }
        finally {
            ExecuteProcessEngine.clean();
        }
    }

    private boolean isNeedAccumulate(Collection<ShardingSphereRule> rules, SQLStatementContext<?> sqlStatementContext) {
        return rules.stream().anyMatch(each -> each instanceof DataNodeContainedRule && ((DataNodeContainedRule)each).isNeedAccumulate(sqlStatementContext.getTablesContext().getTableNames()));
    }

    private int accumulate(List<Integer> updateResults) {
        return updateResults.stream().mapToInt(each -> null == each ? 0 : each).sum();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean execute(ExecutionGroupContext<JDBCExecutionUnit> executionGroupContext, LogicSQL logicSQL, Collection<RouteUnit> routeUnits, JDBCExecutorCallback<Boolean> callback) throws SQLException {
        try {
            ExecuteProcessEngine.initialize((LogicSQL)logicSQL, executionGroupContext, (ConfigurationProperties)this.metaDataContexts.getProps());
            List<Boolean> results = this.jdbcLockEngine.execute(executionGroupContext, logicSQL.getSqlStatementContext(), routeUnits, callback);
            boolean result = null != results && !results.isEmpty() && null != results.get(0) && results.get(0) != false;
            ExecuteProcessEngine.finish((String)executionGroupContext.getExecutionID());
            boolean bl = result;
            return bl;
        }
        finally {
            ExecuteProcessEngine.clean();
        }
    }

    @Generated
    public JDBCExecutor getJdbcExecutor() {
        return this.jdbcExecutor;
    }
}

