/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.driver.executor;

import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.shardingsphere.infra.binder.statement.SQLStatementContext;
import org.apache.shardingsphere.infra.context.refresher.MetaDataRefreshEngine;
import org.apache.shardingsphere.infra.executor.kernel.model.ExecutionGroupContext;
import org.apache.shardingsphere.infra.executor.sql.execute.engine.driver.jdbc.JDBCExecutionUnit;
import org.apache.shardingsphere.infra.executor.sql.execute.engine.driver.jdbc.JDBCExecutor;
import org.apache.shardingsphere.infra.executor.sql.execute.engine.driver.jdbc.JDBCExecutorCallback;
import org.apache.shardingsphere.infra.lock.LockNameUtil;
import org.apache.shardingsphere.infra.lock.ShardingSphereLock;
import org.apache.shardingsphere.infra.optimize.metadata.FederationSchemaMetaData;
import org.apache.shardingsphere.infra.route.context.RouteUnit;
import org.apache.shardingsphere.mode.metadata.MetaDataContexts;
import org.apache.shardingsphere.sql.parser.sql.common.statement.SQLStatement;
import org.apache.shardingsphere.sql.parser.sql.common.statement.ddl.DDLStatement;
import org.apache.shardingsphere.sql.parser.sql.common.statement.dml.DMLStatement;
import org.apache.shardingsphere.sql.parser.sql.common.statement.dml.SelectStatement;

public final class JDBCLockEngine {
    private final String schemaName;
    private final MetaDataContexts metaDataContexts;
    private final JDBCExecutor jdbcExecutor;
    private final MetaDataRefreshEngine metadataRefreshEngine;
    private final Collection<String> lockNames = new ArrayList<String>();

    public JDBCLockEngine(String schemaName, MetaDataContexts metaDataContexts, JDBCExecutor jdbcExecutor) {
        this.schemaName = schemaName;
        this.metaDataContexts = metaDataContexts;
        this.jdbcExecutor = jdbcExecutor;
        this.metadataRefreshEngine = new MetaDataRefreshEngine(metaDataContexts.getMetaData(schemaName), (FederationSchemaMetaData)metaDataContexts.getOptimizerContext().getMetaData().getSchemas().get(schemaName), metaDataContexts.getProps());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> List<T> execute(ExecutionGroupContext<JDBCExecutionUnit> executionGroupContext, SQLStatementContext<?> sqlStatementContext, Collection<RouteUnit> routeUnits, JDBCExecutorCallback<T> callback) throws SQLException {
        SQLStatement sqlStatement = sqlStatementContext.getSqlStatement();
        if (this.metaDataContexts.getLock().isPresent()) {
            ShardingSphereLock lock = (ShardingSphereLock)this.metaDataContexts.getLock().get();
            try {
                if (sqlStatement instanceof DDLStatement) {
                    this.tryTableLock(lock, sqlStatementContext.getTablesContext().getTableNames());
                } else if (sqlStatement instanceof DMLStatement && !(sqlStatement instanceof SelectStatement)) {
                    this.checkTableLock(lock, sqlStatementContext.getTablesContext().getTableNames());
                }
                List<T> list = this.doExecute(executionGroupContext, routeUnits, callback, sqlStatement);
                return list;
            }
            finally {
                if (!this.lockNames.isEmpty()) {
                    this.lockNames.forEach(arg_0 -> ((ShardingSphereLock)lock).releaseLock(arg_0));
                }
            }
        }
        return this.doExecute(executionGroupContext, routeUnits, callback, sqlStatement);
    }

    private void tryTableLock(ShardingSphereLock lock, Collection<String> tableNames) throws SQLException {
        for (String each : tableNames) {
            String lockName = LockNameUtil.getTableLockName((String)this.schemaName, (String)each);
            if (!lock.tryLock(lockName)) {
                throw new SQLException(String.format("Table %s lock wait timeout of %s ms exceeded", each, lock.getDefaultTimeOut()));
            }
            this.lockNames.add(lockName);
        }
    }

    private void checkTableLock(ShardingSphereLock lock, Collection<String> tableNames) throws SQLException {
        for (String each : tableNames) {
            if (!lock.isLocked(LockNameUtil.getTableLockName((String)this.schemaName, (String)each))) continue;
            throw new SQLException(String.format("Table %s is locked", each));
        }
    }

    private <T> List<T> doExecute(ExecutionGroupContext<JDBCExecutionUnit> executionGroupContext, Collection<RouteUnit> routeUnits, JDBCExecutorCallback<T> callback, SQLStatement sqlStatement) throws SQLException {
        List results = this.jdbcExecutor.execute(executionGroupContext, callback);
        this.refreshMetaData(sqlStatement, routeUnits);
        return results;
    }

    private void refreshMetaData(SQLStatement sqlStatement, Collection<RouteUnit> routeUnits) throws SQLException {
        this.metadataRefreshEngine.refresh(sqlStatement, (Collection)routeUnits.stream().map(each -> each.getDataSourceMapper().getLogicName()).collect(Collectors.toList()));
    }
}

