/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.driver.jdbc.core.statement;

import com.google.common.base.Strings;
import java.sql.Connection;
import java.sql.ParameterMetaData;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.shardingsphere.driver.executor.DriverExecutor;
import org.apache.shardingsphere.driver.executor.batch.BatchExecutionUnit;
import org.apache.shardingsphere.driver.executor.batch.BatchPreparedStatementExecutor;
import org.apache.shardingsphere.driver.executor.callback.impl.PreparedStatementExecuteQueryCallback;
import org.apache.shardingsphere.driver.jdbc.adapter.AbstractPreparedStatementAdapter;
import org.apache.shardingsphere.driver.jdbc.core.connection.ShardingSphereConnection;
import org.apache.shardingsphere.driver.jdbc.core.resultset.GeneratedKeysResultSet;
import org.apache.shardingsphere.driver.jdbc.core.resultset.ShardingSphereResultSet;
import org.apache.shardingsphere.driver.jdbc.core.statement.metadata.ShardingSphereParameterMetaData;
import org.apache.shardingsphere.driver.jdbc.exception.SQLExceptionErrorCode;
import org.apache.shardingsphere.infra.binder.LogicSQL;
import org.apache.shardingsphere.infra.binder.SQLStatementContextFactory;
import org.apache.shardingsphere.infra.binder.segment.insert.keygen.GeneratedKeyContext;
import org.apache.shardingsphere.infra.binder.statement.SQLStatementContext;
import org.apache.shardingsphere.infra.binder.statement.dml.InsertStatementContext;
import org.apache.shardingsphere.infra.binder.statement.dml.SelectStatementContext;
import org.apache.shardingsphere.infra.config.RuleConfiguration;
import org.apache.shardingsphere.infra.config.properties.ConfigurationPropertyKey;
import org.apache.shardingsphere.infra.context.kernel.KernelProcessor;
import org.apache.shardingsphere.infra.database.type.DatabaseType;
import org.apache.shardingsphere.infra.database.type.DatabaseTypeRegistry;
import org.apache.shardingsphere.infra.exception.ShardingSphereException;
import org.apache.shardingsphere.infra.executor.check.SQLCheckEngine;
import org.apache.shardingsphere.infra.executor.kernel.model.ExecutionGroup;
import org.apache.shardingsphere.infra.executor.kernel.model.ExecutionGroupContext;
import org.apache.shardingsphere.infra.executor.sql.context.ExecutionContext;
import org.apache.shardingsphere.infra.executor.sql.execute.engine.ConnectionMode;
import org.apache.shardingsphere.infra.executor.sql.execute.engine.SQLExecutorExceptionHandler;
import org.apache.shardingsphere.infra.executor.sql.execute.engine.driver.jdbc.JDBCExecutionUnit;
import org.apache.shardingsphere.infra.executor.sql.execute.engine.driver.jdbc.JDBCExecutor;
import org.apache.shardingsphere.infra.executor.sql.execute.engine.driver.jdbc.JDBCExecutorCallback;
import org.apache.shardingsphere.infra.executor.sql.execute.engine.raw.RawSQLExecutionUnit;
import org.apache.shardingsphere.infra.executor.sql.execute.engine.raw.callback.RawSQLExecutorCallback;
import org.apache.shardingsphere.infra.executor.sql.execute.result.ExecuteResult;
import org.apache.shardingsphere.infra.executor.sql.execute.result.query.QueryResult;
import org.apache.shardingsphere.infra.executor.sql.execute.result.query.impl.driver.jdbc.type.stream.JDBCStreamQueryResult;
import org.apache.shardingsphere.infra.executor.sql.execute.result.update.UpdateResult;
import org.apache.shardingsphere.infra.executor.sql.prepare.driver.DriverExecutionPrepareEngine;
import org.apache.shardingsphere.infra.executor.sql.prepare.driver.ExecutorDriverManager;
import org.apache.shardingsphere.infra.executor.sql.prepare.driver.StorageResourceOption;
import org.apache.shardingsphere.infra.executor.sql.prepare.driver.jdbc.StatementOption;
import org.apache.shardingsphere.infra.executor.sql.prepare.raw.RawExecutionPrepareEngine;
import org.apache.shardingsphere.infra.hint.HintManager;
import org.apache.shardingsphere.infra.merge.MergeEngine;
import org.apache.shardingsphere.infra.merge.result.MergedResult;
import org.apache.shardingsphere.infra.metadata.ShardingSphereMetaData;
import org.apache.shardingsphere.infra.parser.ShardingSphereSQLParserEngine;
import org.apache.shardingsphere.infra.rule.identifier.type.DataNodeContainedRule;
import org.apache.shardingsphere.infra.rule.identifier.type.RawExecutionRule;
import org.apache.shardingsphere.mode.metadata.MetaDataContexts;
import org.apache.shardingsphere.readwritesplitting.api.ReadwriteSplittingRuleConfiguration;
import org.apache.shardingsphere.sql.parser.sql.common.statement.SQLStatement;
import org.apache.shardingsphere.sql.parser.sql.common.statement.dal.DALStatement;

public final class ShardingSpherePreparedStatement
extends AbstractPreparedStatementAdapter {
    private final ShardingSphereConnection connection;
    private final MetaDataContexts metaDataContexts;
    private final String sql;
    private final List<PreparedStatement> statements;
    private final List<List<Object>> parameterSets;
    private final SQLStatement sqlStatement;
    private final StatementOption statementOption;
    private final ParameterMetaData parameterMetaData;
    private final DriverExecutor executor;
    private final BatchPreparedStatementExecutor batchPreparedStatementExecutor;
    private final Collection<Comparable<?>> generatedValues = new LinkedList();
    private final KernelProcessor kernelProcessor;
    private final boolean statementsCacheable;
    private ExecutionContext executionContext;
    private ResultSet currentResultSet;

    public ShardingSpherePreparedStatement(ShardingSphereConnection connection, String sql) throws SQLException {
        this(connection, sql, 1003, 1007, 1, false);
    }

    public ShardingSpherePreparedStatement(ShardingSphereConnection connection, String sql, int resultSetType, int resultSetConcurrency) throws SQLException {
        this(connection, sql, resultSetType, resultSetConcurrency, 1, false);
    }

    public ShardingSpherePreparedStatement(ShardingSphereConnection connection, String sql, int autoGeneratedKeys) throws SQLException {
        this(connection, sql, 1003, 1007, 1, 1 == autoGeneratedKeys);
    }

    public ShardingSpherePreparedStatement(ShardingSphereConnection connection, String sql, int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        this(connection, sql, resultSetType, resultSetConcurrency, resultSetHoldability, false);
    }

    private ShardingSpherePreparedStatement(ShardingSphereConnection connection, String sql, int resultSetType, int resultSetConcurrency, int resultSetHoldability, boolean returnGeneratedKeys) throws SQLException {
        if (Strings.isNullOrEmpty((String)sql)) {
            SQLExceptionErrorCode errorCode = SQLExceptionErrorCode.SQL_STRING_NULL_OR_EMPTY;
            throw new SQLException(errorCode.getErrorMessage(), errorCode.getSqlState(), errorCode.getErrorCode());
        }
        this.connection = connection;
        this.metaDataContexts = connection.getContextManager().getMetaDataContexts();
        this.sql = sql;
        this.statements = new ArrayList<PreparedStatement>();
        this.parameterSets = new ArrayList<List<Object>>();
        ShardingSphereSQLParserEngine sqlParserEngine = new ShardingSphereSQLParserEngine(DatabaseTypeRegistry.getTrunkDatabaseTypeName((DatabaseType)this.metaDataContexts.getMetaData(connection.getSchema()).getResource().getDatabaseType()), this.metaDataContexts.getProps());
        this.sqlStatement = sqlParserEngine.parse(sql, true);
        this.parameterMetaData = new ShardingSphereParameterMetaData(this.sqlStatement);
        this.statementOption = returnGeneratedKeys ? new StatementOption(true) : new StatementOption(resultSetType, resultSetConcurrency, resultSetHoldability);
        this.executor = new DriverExecutor(connection);
        JDBCExecutor jdbcExecutor = new JDBCExecutor(this.metaDataContexts.getExecutorEngine(), connection.isHoldTransaction());
        this.batchPreparedStatementExecutor = new BatchPreparedStatementExecutor(this.metaDataContexts, jdbcExecutor, connection.getSchema());
        this.kernelProcessor = new KernelProcessor();
        this.statementsCacheable = this.isStatementsCacheable(this.metaDataContexts.getMetaData(connection.getSchema()).getRuleMetaData().getConfigurations());
    }

    private boolean isStatementsCacheable(Collection<RuleConfiguration> configurations) {
        return 1 == configurations.size() && configurations.iterator().next() instanceof ReadwriteSplittingRuleConfiguration && !HintManager.isInstantiated();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ResultSet executeQuery() throws SQLException {
        try {
            if (this.statementsCacheable && !this.statements.isEmpty()) {
                this.resetParameters();
                ResultSet resultSet = this.statements.iterator().next().executeQuery();
                return resultSet;
            }
            this.clearPrevious();
            this.executionContext = this.createExecutionContext();
            List<QueryResult> queryResults = this.executeQuery0();
            MergedResult mergedResult = this.mergeQuery(queryResults);
            ShardingSphereResultSet shardingSphereResultSet = new ShardingSphereResultSet(this.getShardingSphereResultSet(), mergedResult, this, this.executionContext);
            return shardingSphereResultSet;
        }
        finally {
            this.clearBatch();
        }
    }

    private void resetParameters() throws SQLException {
        this.parameterSets.clear();
        this.parameterSets.add(this.getParameters());
        this.replaySetParameter();
    }

    private List<ResultSet> getShardingSphereResultSet() throws SQLException {
        if (this.executionContext.getRouteContext().isFederated()) {
            return Collections.singletonList(this.executor.getFederationExecutor().getResultSet());
        }
        return this.statements.stream().map(this::getResultSet).collect(Collectors.toList());
    }

    private List<QueryResult> executeQuery0() throws SQLException {
        if (this.metaDataContexts.getMetaData(this.connection.getSchema()).getRuleMetaData().getRules().stream().anyMatch(each -> each instanceof RawExecutionRule)) {
            return this.executor.getRawExecutor().execute(this.createRawExecutionGroupContext(), this.executionContext.getLogicSQL(), new RawSQLExecutorCallback()).stream().map(each -> (QueryResult)each).collect(Collectors.toList());
        }
        if (this.executionContext.getRouteContext().isFederated()) {
            return this.executeFederatedQuery();
        }
        ExecutionGroupContext<JDBCExecutionUnit> executionGroupContext = this.createExecutionGroupContext();
        this.cacheStatements(executionGroupContext.getInputGroups());
        return this.executor.getRegularExecutor().executeQuery(executionGroupContext, this.executionContext.getLogicSQL(), new PreparedStatementExecuteQueryCallback(this.metaDataContexts.getMetaData(this.connection.getSchema()).getResource().getDatabaseType(), this.sqlStatement, SQLExecutorExceptionHandler.isExceptionThrown()));
    }

    private List<QueryResult> executeFederatedQuery() throws SQLException {
        if (this.executionContext.getExecutionUnits().isEmpty()) {
            return Collections.emptyList();
        }
        PreparedStatementExecuteQueryCallback callback = new PreparedStatementExecuteQueryCallback(this.metaDataContexts.getMetaData(this.connection.getSchema()).getResource().getDatabaseType(), this.sqlStatement, SQLExecutorExceptionHandler.isExceptionThrown());
        return this.executor.getFederationExecutor().executeQuery(this.createDriverExecutionPrepareEngine(), (JDBCExecutorCallback)callback, this.executionContext);
    }

    private DriverExecutionPrepareEngine<JDBCExecutionUnit, Connection> createDriverExecutionPrepareEngine() {
        int maxConnectionsSizePerQuery = (Integer)this.metaDataContexts.getProps().getValue((Enum)ConfigurationPropertyKey.MAX_CONNECTIONS_SIZE_PER_QUERY);
        return new DriverExecutionPrepareEngine("JDBC.PREPARED_STATEMENT", maxConnectionsSizePerQuery, (ExecutorDriverManager)this.connection.getConnectionManager(), (StorageResourceOption)this.statementOption, this.metaDataContexts.getMetaData(this.connection.getSchema()).getRuleMetaData().getRules());
    }

    @Override
    public int executeUpdate() throws SQLException {
        try {
            if (this.statementsCacheable && !this.statements.isEmpty()) {
                this.resetParameters();
                int n = this.statements.iterator().next().executeUpdate();
                return n;
            }
            this.clearPrevious();
            this.executionContext = this.createExecutionContext();
            if (this.metaDataContexts.getMetaData(this.connection.getSchema()).getRuleMetaData().getRules().stream().anyMatch(each -> each instanceof RawExecutionRule)) {
                Collection executeResults = this.executor.getRawExecutor().execute(this.createRawExecutionGroupContext(), this.executionContext.getLogicSQL(), new RawSQLExecutorCallback());
                int n = this.accumulate(executeResults);
                return n;
            }
            ExecutionGroupContext<JDBCExecutionUnit> executionGroupContext = this.createExecutionGroupContext();
            this.cacheStatements(executionGroupContext.getInputGroups());
            int n = this.executor.getRegularExecutor().executeUpdate(executionGroupContext, this.executionContext.getLogicSQL(), this.executionContext.getRouteContext().getRouteUnits(), this.createExecuteUpdateCallback());
            return n;
        }
        finally {
            this.clearBatch();
        }
    }

    private int accumulate(Collection<ExecuteResult> results) {
        int result = 0;
        for (ExecuteResult each : results) {
            result += ((UpdateResult)each).getUpdateCount();
        }
        return result;
    }

    private JDBCExecutorCallback<Integer> createExecuteUpdateCallback() {
        boolean isExceptionThrown = SQLExecutorExceptionHandler.isExceptionThrown();
        return new JDBCExecutorCallback<Integer>(this.metaDataContexts.getMetaData(this.connection.getSchema()).getResource().getDatabaseType(), this.sqlStatement, isExceptionThrown){

            protected Integer executeSQL(String sql, Statement statement, ConnectionMode connectionMode) throws SQLException {
                return ((PreparedStatement)statement).executeUpdate();
            }

            protected Optional<Integer> getSaneResult(SQLStatement sqlStatement) {
                return Optional.empty();
            }
        };
    }

    @Override
    public boolean execute() throws SQLException {
        try {
            if (this.statementsCacheable && !this.statements.isEmpty()) {
                this.resetParameters();
                boolean bl = this.statements.iterator().next().execute();
                return bl;
            }
            this.clearPrevious();
            this.executionContext = this.createExecutionContext();
            if (this.metaDataContexts.getMetaData(this.connection.getSchema()).getRuleMetaData().getRules().stream().anyMatch(each -> each instanceof RawExecutionRule)) {
                Collection executeResults = this.executor.getRawExecutor().execute(this.createRawExecutionGroupContext(), this.executionContext.getLogicSQL(), new RawSQLExecutorCallback());
                boolean bl = executeResults.iterator().next() instanceof QueryResult;
                return bl;
            }
            if (this.executionContext.getRouteContext().isFederated()) {
                List<QueryResult> queryResults = this.executeFederatedQuery();
                boolean bl = !queryResults.isEmpty();
                return bl;
            }
            ExecutionGroupContext<JDBCExecutionUnit> executionGroupContext = this.createExecutionGroupContext();
            this.cacheStatements(executionGroupContext.getInputGroups());
            boolean bl = this.executor.getRegularExecutor().execute(executionGroupContext, this.executionContext.getLogicSQL(), this.executionContext.getRouteContext().getRouteUnits(), this.createExecuteCallback());
            return bl;
        }
        finally {
            this.clearBatch();
        }
    }

    private ExecutionGroupContext<RawSQLExecutionUnit> createRawExecutionGroupContext() throws SQLException {
        int maxConnectionsSizePerQuery = (Integer)this.metaDataContexts.getProps().getValue((Enum)ConfigurationPropertyKey.MAX_CONNECTIONS_SIZE_PER_QUERY);
        return new RawExecutionPrepareEngine(maxConnectionsSizePerQuery, this.metaDataContexts.getMetaData(this.connection.getSchema()).getRuleMetaData().getRules()).prepare(this.executionContext.getRouteContext(), this.executionContext.getExecutionUnits());
    }

    private ExecutionGroupContext<JDBCExecutionUnit> createExecutionGroupContext() throws SQLException {
        DriverExecutionPrepareEngine<JDBCExecutionUnit, Connection> prepareEngine = this.createDriverExecutionPrepareEngine();
        return prepareEngine.prepare(this.executionContext.getRouteContext(), this.executionContext.getExecutionUnits());
    }

    private JDBCExecutorCallback<Boolean> createExecuteCallback() {
        boolean isExceptionThrown = SQLExecutorExceptionHandler.isExceptionThrown();
        return new JDBCExecutorCallback<Boolean>(this.metaDataContexts.getMetaData(this.connection.getSchema()).getResource().getDatabaseType(), this.sqlStatement, isExceptionThrown){

            protected Boolean executeSQL(String sql, Statement statement, ConnectionMode connectionMode) throws SQLException {
                return ((PreparedStatement)statement).execute();
            }

            protected Optional<Boolean> getSaneResult(SQLStatement sqlStatement) {
                return Optional.empty();
            }
        };
    }

    @Override
    public ResultSet getResultSet() throws SQLException {
        if (null != this.currentResultSet) {
            return this.currentResultSet;
        }
        if (this.executionContext.getSqlStatementContext() instanceof SelectStatementContext || this.executionContext.getSqlStatementContext().getSqlStatement() instanceof DALStatement) {
            List<ResultSet> resultSets = this.getResultSets();
            MergedResult mergedResult = this.mergeQuery(this.getQueryResults(resultSets));
            this.currentResultSet = new ShardingSphereResultSet(resultSets, mergedResult, this, this.executionContext);
        }
        return this.currentResultSet;
    }

    private ResultSet getResultSet(Statement statement) {
        try {
            return statement.getResultSet();
        }
        catch (SQLException ex) {
            throw new ShardingSphereException((Exception)ex);
        }
    }

    private List<ResultSet> getResultSets() throws SQLException {
        ArrayList<ResultSet> result = new ArrayList<ResultSet>(this.statements.size());
        for (Statement statement : this.statements) {
            result.add(statement.getResultSet());
        }
        if (this.executionContext.getRouteContext().isFederated()) {
            result.add(this.executor.getFederationExecutor().getResultSet());
        }
        return result;
    }

    private List<QueryResult> getQueryResults(List<ResultSet> resultSets) throws SQLException {
        ArrayList<QueryResult> result = new ArrayList<QueryResult>(resultSets.size());
        for (ResultSet each : resultSets) {
            if (null == each) continue;
            result.add((QueryResult)new JDBCStreamQueryResult(each));
        }
        return result;
    }

    private ExecutionContext createExecutionContext() {
        LogicSQL logicSQL = this.createLogicSQL();
        SQLCheckEngine.check((SQLStatement)logicSQL.getSqlStatementContext().getSqlStatement(), (List)logicSQL.getParameters(), (Collection)this.metaDataContexts.getMetaData(this.connection.getSchema()).getRuleMetaData().getRules(), (String)this.connection.getSchema(), (Map)this.metaDataContexts.getMetaDataMap(), null);
        ExecutionContext result = this.kernelProcessor.generateExecutionContext(logicSQL, this.metaDataContexts.getMetaData(this.connection.getSchema()), this.metaDataContexts.getProps());
        this.findGeneratedKey(result).ifPresent(generatedKey -> this.generatedValues.addAll(generatedKey.getGeneratedValues()));
        return result;
    }

    private LogicSQL createLogicSQL() {
        ArrayList<Object> parameters = new ArrayList<Object>(this.getParameters());
        SQLStatementContext sqlStatementContext = SQLStatementContextFactory.newInstance((Map)this.metaDataContexts.getMetaDataMap(), parameters, (SQLStatement)this.sqlStatement, (String)this.connection.getSchema());
        return new LogicSQL(sqlStatementContext, this.sql, parameters);
    }

    private MergedResult mergeQuery(List<QueryResult> queryResults) throws SQLException {
        ShardingSphereMetaData metaData = this.metaDataContexts.getMetaData(this.connection.getSchema());
        MergeEngine mergeEngine = new MergeEngine(this.connection.getSchema(), metaData.getResource().getDatabaseType(), metaData.getSchema(), this.metaDataContexts.getProps(), metaData.getRuleMetaData().getRules());
        return mergeEngine.merge(queryResults, this.executionContext.getSqlStatementContext());
    }

    private void cacheStatements(Collection<ExecutionGroup<JDBCExecutionUnit>> executionGroups) throws SQLException {
        for (ExecutionGroup<JDBCExecutionUnit> each : executionGroups) {
            each.getInputs().forEach(eachInput -> {
                this.statements.add((PreparedStatement)eachInput.getStorageResource());
                this.parameterSets.add(eachInput.getExecutionUnit().getSqlUnit().getParameters());
            });
        }
        this.replay();
    }

    private void replay() throws SQLException {
        this.replaySetParameter();
        for (Statement statement : this.statements) {
            this.getMethodInvocationRecorder().replay(statement);
        }
    }

    private void replaySetParameter() throws SQLException {
        for (int i = 0; i < this.statements.size(); ++i) {
            this.replaySetParameter(this.statements.get(i), this.parameterSets.get(i));
        }
    }

    private void clearPrevious() throws SQLException {
        this.clearStatements();
        this.parameterSets.clear();
    }

    private Optional<GeneratedKeyContext> findGeneratedKey(ExecutionContext executionContext) {
        return executionContext.getSqlStatementContext() instanceof InsertStatementContext ? ((InsertStatementContext)executionContext.getSqlStatementContext()).getGeneratedKeyContext() : Optional.empty();
    }

    @Override
    public ResultSet getGeneratedKeys() throws SQLException {
        Optional<GeneratedKeyContext> generatedKey = this.findGeneratedKey(this.executionContext);
        if (generatedKey.isPresent() && this.statementOption.isReturnGeneratedKeys() && !this.generatedValues.isEmpty()) {
            return new GeneratedKeysResultSet(generatedKey.get().getColumnName(), this.generatedValues.iterator(), this);
        }
        for (PreparedStatement statement : this.statements) {
            ResultSet resultSet = statement.getGeneratedKeys();
            while (resultSet.next()) {
                this.generatedValues.add((Comparable)resultSet.getObject(1));
            }
        }
        return new GeneratedKeysResultSet(null, this.generatedValues.iterator(), this);
    }

    @Override
    public void addBatch() {
        try {
            this.executionContext = this.createExecutionContext();
            this.batchPreparedStatementExecutor.addBatchForExecutionUnits(this.executionContext.getExecutionUnits());
        }
        finally {
            this.currentResultSet = null;
            this.clearParameters();
        }
    }

    @Override
    public int[] executeBatch() throws SQLException {
        try {
            this.initBatchPreparedStatementExecutor();
            int[] nArray = this.batchPreparedStatementExecutor.executeBatch(this.executionContext.getSqlStatementContext());
            return nArray;
        }
        finally {
            this.clearBatch();
        }
    }

    private void initBatchPreparedStatementExecutor() throws SQLException {
        DriverExecutionPrepareEngine prepareEngine = new DriverExecutionPrepareEngine("JDBC.PREPARED_STATEMENT", ((Integer)this.metaDataContexts.getProps().getValue((Enum)ConfigurationPropertyKey.MAX_CONNECTIONS_SIZE_PER_QUERY)).intValue(), (ExecutorDriverManager)this.connection.getConnectionManager(), (StorageResourceOption)this.statementOption, this.metaDataContexts.getMetaData(this.connection.getSchema()).getRuleMetaData().getRules());
        this.batchPreparedStatementExecutor.init((ExecutionGroupContext<JDBCExecutionUnit>)prepareEngine.prepare(this.executionContext.getRouteContext(), (Collection)new ArrayList<BatchExecutionUnit>(this.batchPreparedStatementExecutor.getBatchExecutionUnits()).stream().map(BatchExecutionUnit::getExecutionUnit).collect(Collectors.toList())));
        this.setBatchParametersForStatements();
    }

    private void setBatchParametersForStatements() throws SQLException {
        for (Statement each : this.batchPreparedStatementExecutor.getStatements()) {
            List<List<Object>> parameterSet = this.batchPreparedStatementExecutor.getParameterSet(each);
            for (List<Object> parameters : parameterSet) {
                this.replaySetParameter((PreparedStatement)each, parameters);
                ((PreparedStatement)each).addBatch();
            }
        }
    }

    @Override
    public void clearBatch() throws SQLException {
        this.currentResultSet = null;
        this.batchPreparedStatementExecutor.clear();
        this.clearParameters();
    }

    @Override
    public int getResultSetType() {
        return this.statementOption.getResultSetType();
    }

    @Override
    public int getResultSetConcurrency() {
        return this.statementOption.getResultSetConcurrency();
    }

    @Override
    public int getResultSetHoldability() {
        return this.statementOption.getResultSetHoldability();
    }

    @Override
    public boolean isAccumulate() {
        return this.metaDataContexts.getMetaData(this.connection.getSchema()).getRuleMetaData().getRules().stream().anyMatch(each -> each instanceof DataNodeContainedRule && ((DataNodeContainedRule)each).isNeedAccumulate(this.executionContext.getSqlStatementContext().getTablesContext().getTableNames()));
    }

    public Collection<PreparedStatement> getRoutedStatements() {
        return this.statements;
    }

    private void clearStatements() throws SQLException {
        for (Statement statement : this.statements) {
            statement.close();
        }
        this.statements.clear();
    }

    @Override
    @Generated
    public ShardingSphereConnection getConnection() {
        return this.connection;
    }

    @Override
    @Generated
    public ParameterMetaData getParameterMetaData() {
        return this.parameterMetaData;
    }

    @Override
    @Generated
    protected DriverExecutor getExecutor() {
        return this.executor;
    }
}

