/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.driver.state;

import java.sql.Connection;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import lombok.Generated;
import org.apache.shardingsphere.driver.state.DriverState;
import org.apache.shardingsphere.mode.manager.ContextManager;
import org.apache.shardingsphere.spi.ShardingSphereServiceLoader;

public final class DriverStateContext {
    private static final Map<String, DriverState> STATES;

    public static Connection getConnection(String schemaName, ContextManager contextManager) {
        return STATES.get(contextManager.getStateContext().getCurrentState().name()).getConnection(schemaName, contextManager);
    }

    @Generated
    private DriverStateContext() {
    }

    static {
        ShardingSphereServiceLoader.register(DriverState.class);
        Collection driverStates = ShardingSphereServiceLoader.getSingletonServiceInstances(DriverState.class);
        STATES = new HashMap<String, DriverState>();
        for (DriverState each : driverStates) {
            STATES.put(each.getType(), each);
        }
    }
}

