/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.mode.metadata;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Optional;
import java.util.Properties;
import lombok.Generated;
import org.apache.shardingsphere.infra.config.properties.ConfigurationProperties;
import org.apache.shardingsphere.infra.executor.kernel.ExecutorEngine;
import org.apache.shardingsphere.infra.lock.ShardingSphereLock;
import org.apache.shardingsphere.infra.metadata.ShardingSphereMetaData;
import org.apache.shardingsphere.infra.metadata.rule.ShardingSphereRuleMetaData;
import org.apache.shardingsphere.infra.optimize.context.OptimizerContext;
import org.apache.shardingsphere.infra.optimize.context.OptimizerContextFactory;
import org.apache.shardingsphere.mode.metadata.persist.MetaDataPersistService;

public final class MetaDataContexts
implements AutoCloseable {
    private final MetaDataPersistService metaDataPersistService;
    private final Map<String, ShardingSphereMetaData> metaDataMap;
    private final ShardingSphereRuleMetaData globalRuleMetaData;
    private final ExecutorEngine executorEngine;
    private final OptimizerContext optimizerContext;
    private final ConfigurationProperties props;

    public MetaDataContexts(MetaDataPersistService metaDataPersistService) {
        this(metaDataPersistService, new LinkedHashMap<String, ShardingSphereMetaData>(), new ShardingSphereRuleMetaData(Collections.emptyList(), Collections.emptyList()), null, new ConfigurationProperties(new Properties()), OptimizerContextFactory.create(new HashMap()));
    }

    public MetaDataContexts(MetaDataPersistService metaDataPersistService, Map<String, ShardingSphereMetaData> metaDataMap, ShardingSphereRuleMetaData globalRuleMetaData, ExecutorEngine executorEngine, ConfigurationProperties props, OptimizerContext optimizerContext) {
        this.metaDataPersistService = metaDataPersistService;
        this.metaDataMap = new LinkedHashMap<String, ShardingSphereMetaData>(metaDataMap);
        this.globalRuleMetaData = globalRuleMetaData;
        this.executorEngine = executorEngine;
        this.optimizerContext = optimizerContext;
        this.props = props;
    }

    public Optional<MetaDataPersistService> getMetaDataPersistService() {
        return Optional.ofNullable(this.metaDataPersistService);
    }

    public Collection<String> getAllSchemaNames() {
        return this.metaDataMap.keySet();
    }

    public ShardingSphereMetaData getMetaData(String schemaName) {
        return this.metaDataMap.get(schemaName);
    }

    public Optional<ShardingSphereLock> getLock() {
        return Optional.empty();
    }

    @Override
    public void close() throws Exception {
        this.executorEngine.close();
        if (null != this.metaDataPersistService) {
            this.metaDataPersistService.getRepository().close();
        }
    }

    @Generated
    public Map<String, ShardingSphereMetaData> getMetaDataMap() {
        return this.metaDataMap;
    }

    @Generated
    public ShardingSphereRuleMetaData getGlobalRuleMetaData() {
        return this.globalRuleMetaData;
    }

    @Generated
    public ExecutorEngine getExecutorEngine() {
        return this.executorEngine;
    }

    @Generated
    public OptimizerContext getOptimizerContext() {
        return this.optimizerContext;
    }

    @Generated
    public ConfigurationProperties getProps() {
        return this.props;
    }
}

