/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.mode.metadata;

import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.SQLException;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Optional;
import java.util.Properties;
import javax.sql.DataSource;
import org.apache.shardingsphere.infra.config.DatabaseAccessConfiguration;
import org.apache.shardingsphere.infra.config.RuleConfiguration;
import org.apache.shardingsphere.infra.config.properties.ConfigurationProperties;
import org.apache.shardingsphere.infra.config.properties.ConfigurationPropertyKey;
import org.apache.shardingsphere.infra.database.type.DatabaseType;
import org.apache.shardingsphere.infra.database.type.DatabaseTypeRecognizer;
import org.apache.shardingsphere.infra.executor.kernel.ExecutorEngine;
import org.apache.shardingsphere.infra.metadata.ShardingSphereMetaData;
import org.apache.shardingsphere.infra.metadata.resource.CachedDatabaseMetaData;
import org.apache.shardingsphere.infra.metadata.resource.DataSourcesMetaData;
import org.apache.shardingsphere.infra.metadata.resource.ShardingSphereResource;
import org.apache.shardingsphere.infra.metadata.rule.ShardingSphereRuleMetaData;
import org.apache.shardingsphere.infra.metadata.schema.ShardingSphereSchema;
import org.apache.shardingsphere.infra.metadata.schema.builder.SchemaBuilder;
import org.apache.shardingsphere.infra.optimize.context.OptimizerContextFactory;
import org.apache.shardingsphere.infra.rule.ShardingSphereRule;
import org.apache.shardingsphere.infra.rule.builder.global.GlobalRulesBuilder;
import org.apache.shardingsphere.mode.metadata.MetaDataContexts;
import org.apache.shardingsphere.mode.metadata.persist.MetaDataPersistService;

public final class MetaDataContextsBuilder {
    private final Map<String, Map<String, DataSource>> dataSources;
    private final Map<String, Collection<RuleConfiguration>> schemaRuleConfigs;
    private final Collection<RuleConfiguration> globalRuleConfigs;
    private final Map<String, ShardingSphereSchema> schemas;
    private final Map<String, Collection<ShardingSphereRule>> rules;
    private final ConfigurationProperties props;
    private final ExecutorEngine executorEngine;

    public MetaDataContextsBuilder(Map<String, Map<String, DataSource>> dataSources, Map<String, Collection<RuleConfiguration>> schemaRuleConfigs, Collection<RuleConfiguration> globalRuleConfigs, Map<String, ShardingSphereSchema> schemas, Map<String, Collection<ShardingSphereRule>> rules, Properties props) {
        this.dataSources = dataSources;
        this.schemaRuleConfigs = schemaRuleConfigs;
        this.globalRuleConfigs = globalRuleConfigs;
        this.schemas = schemas;
        this.rules = rules;
        this.props = new ConfigurationProperties(null == props ? new Properties() : props);
        this.executorEngine = new ExecutorEngine(((Integer)this.props.getValue((Enum)ConfigurationPropertyKey.KERNEL_EXECUTOR_SIZE)).intValue());
    }

    public MetaDataContexts build(MetaDataPersistService metaDataPersistService) throws SQLException {
        HashMap<String, ShardingSphereMetaData> kernelMetaData = new HashMap<String, ShardingSphereMetaData>(this.schemaRuleConfigs.size(), 1.0f);
        HashMap<String, ShardingSphereMetaData> federationMetaData = new HashMap<String, ShardingSphereMetaData>(this.schemaRuleConfigs.size(), 1.0f);
        for (String each : this.schemaRuleConfigs.keySet()) {
            Map<String, DataSource> dataSourceMap = this.dataSources.get(each);
            Collection<RuleConfiguration> ruleConfigs = this.schemaRuleConfigs.get(each);
            DatabaseType databaseType = DatabaseTypeRecognizer.getDatabaseType(dataSourceMap.values());
            ShardingSphereRuleMetaData ruleMetaData = new ShardingSphereRuleMetaData(ruleConfigs, this.rules.get(each));
            ShardingSphereResource resource = this.buildResource(databaseType, dataSourceMap);
            Collection tableMetaDataList = this.schemas.get(each).getTables().values();
            federationMetaData.put(each, new ShardingSphereMetaData(each, resource, ruleMetaData, SchemaBuilder.buildFederationSchema(tableMetaDataList, this.rules.get(each))));
            kernelMetaData.put(each, new ShardingSphereMetaData(each, resource, ruleMetaData, SchemaBuilder.buildKernelSchema(tableMetaDataList, this.rules.get(each))));
        }
        return new MetaDataContexts(metaDataPersistService, kernelMetaData, this.buildGlobalSchemaMetaData(kernelMetaData), this.executorEngine, this.props, OptimizerContextFactory.create(federationMetaData));
    }

    private ShardingSphereRuleMetaData buildGlobalSchemaMetaData(Map<String, ShardingSphereMetaData> mataDataMap) {
        return new ShardingSphereRuleMetaData(this.globalRuleConfigs, GlobalRulesBuilder.buildRules(this.globalRuleConfigs, mataDataMap));
    }

    private ShardingSphereResource buildResource(DatabaseType databaseType, Map<String, DataSource> dataSourceMap) throws SQLException {
        DataSourcesMetaData dataSourceMetas = new DataSourcesMetaData(databaseType, this.getDatabaseAccessConfigurationMap(dataSourceMap));
        CachedDatabaseMetaData cachedDatabaseMetaData = this.createCachedDatabaseMetaData(dataSourceMap).orElse(null);
        return new ShardingSphereResource(dataSourceMap, dataSourceMetas, cachedDatabaseMetaData, databaseType);
    }

    private Map<String, DatabaseAccessConfiguration> getDatabaseAccessConfigurationMap(Map<String, DataSource> dataSourceMap) throws SQLException {
        LinkedHashMap<String, DatabaseAccessConfiguration> result = new LinkedHashMap<String, DatabaseAccessConfiguration>(dataSourceMap.size(), 1.0f);
        for (Map.Entry<String, DataSource> entry : dataSourceMap.entrySet()) {
            DataSource dataSource = entry.getValue();
            Connection connection = dataSource.getConnection();
            Throwable throwable = null;
            try {
                DatabaseMetaData metaData = connection.getMetaData();
                result.put(entry.getKey(), new DatabaseAccessConfiguration(metaData.getURL(), metaData.getUserName()));
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                if (connection == null) continue;
                if (throwable != null) {
                    try {
                        connection.close();
                    }
                    catch (Throwable throwable3) {
                        throwable.addSuppressed(throwable3);
                    }
                    continue;
                }
                connection.close();
            }
        }
        return result;
    }

    private Optional<CachedDatabaseMetaData> createCachedDatabaseMetaData(Map<String, DataSource> dataSources) throws SQLException {
        if (dataSources.isEmpty()) {
            return Optional.empty();
        }
        try (Connection connection = dataSources.values().iterator().next().getConnection();){
            Optional<CachedDatabaseMetaData> optional = Optional.of(new CachedDatabaseMetaData(connection.getMetaData()));
            return optional;
        }
    }
}

