/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.mode.metadata.persist.service.impl;

import com.google.common.base.Strings;
import java.util.Properties;
import lombok.Generated;
import org.apache.shardingsphere.infra.yaml.engine.YamlEngine;
import org.apache.shardingsphere.mode.metadata.persist.node.GlobalNode;
import org.apache.shardingsphere.mode.metadata.persist.service.GlobalPersistService;
import org.apache.shardingsphere.mode.persist.PersistRepository;

public final class PropertiesPersistService
implements GlobalPersistService<Properties> {
    private final PersistRepository repository;

    @Override
    public void persist(Properties props, boolean isOverwrite) {
        if (!(props.isEmpty() || !isOverwrite && this.isExisted())) {
            this.repository.persist(GlobalNode.getPropsPath(), YamlEngine.marshal((Object)props));
        }
    }

    private boolean isExisted() {
        return !Strings.isNullOrEmpty((String)this.repository.get(GlobalNode.getPropsPath()));
    }

    @Override
    public Properties load() {
        return Strings.isNullOrEmpty((String)this.repository.get(GlobalNode.getPropsPath())) ? new Properties() : (Properties)YamlEngine.unmarshal((String)this.repository.get(GlobalNode.getPropsPath()), Properties.class);
    }

    @Generated
    public PropertiesPersistService(PersistRepository repository) {
        this.repository = repository;
    }
}

