/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.readwritesplitting.checker;

import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import java.util.Collection;
import org.apache.shardingsphere.infra.config.RuleConfiguration;
import org.apache.shardingsphere.infra.config.checker.RuleConfigurationChecker;
import org.apache.shardingsphere.readwritesplitting.api.rule.ReadwriteSplittingDataSourceRuleConfiguration;

public abstract class AbstractReadwriteSplittingRuleConfigurationChecker<T extends RuleConfiguration>
implements RuleConfigurationChecker<T> {
    public final void check(String schemaName, T config) {
        this.checkDataSources(schemaName, this.getDataSources(config));
    }

    private void checkDataSources(String schemaName, Collection<ReadwriteSplittingDataSourceRuleConfiguration> dataSources) {
        dataSources.forEach(each -> {
            if (Strings.isNullOrEmpty((String)each.getAutoAwareDataSourceName())) {
                Preconditions.checkState((!each.getWriteDataSourceName().isEmpty() ? 1 : 0) != 0, (String)"No available readwrite-splitting rule configuration in schema `%s`", (Object)schemaName);
            }
        });
    }

    protected abstract Collection<ReadwriteSplittingDataSourceRuleConfiguration> getDataSources(T var1);
}

