/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.shadow.algorithm.shadow.column;

import com.google.common.base.Preconditions;
import java.util.Collection;
import java.util.Objects;
import java.util.Optional;
import java.util.Properties;
import lombok.Generated;
import org.apache.shardingsphere.shadow.api.shadow.ShadowOperationType;
import org.apache.shardingsphere.shadow.api.shadow.column.ColumnShadowAlgorithm;
import org.apache.shardingsphere.shadow.api.shadow.column.PreciseColumnShadowValue;

public final class ColumnValueMatchShadowAlgorithm
implements ColumnShadowAlgorithm<Comparable<?>> {
    private static final String COLUMN = "column";
    private static final String OPERATION = "operation";
    private static final String VALUE = "value";
    private Properties props = new Properties();
    private ShadowOperationType shadowOperationType;

    public void init() {
        this.checkProps();
    }

    private void checkProps() {
        this.checkOperation();
        this.checkColumn();
        this.checkValue();
    }

    private void checkValue() {
        Object value = this.props.get(VALUE);
        Preconditions.checkNotNull((Object)value, (Object)"Column value match shadow algorithm value cannot be null.");
    }

    private void checkColumn() {
        String column = this.props.getProperty(COLUMN);
        Preconditions.checkNotNull((Object)column, (Object)"Column value match shadow algorithm column cannot be null.");
    }

    private void checkOperation() {
        String operationType = this.props.getProperty(OPERATION);
        Preconditions.checkNotNull((Object)operationType, (Object)"Column value match shadow algorithm operation cannot be null.");
        Optional shadowOperationType = ShadowOperationType.contains((String)operationType);
        Preconditions.checkState((boolean)shadowOperationType.isPresent(), (Object)"Column value match shadow algorithm operation must be one of select insert update delete.");
        shadowOperationType.ifPresent(type -> {
            this.shadowOperationType = type;
        });
    }

    public boolean isShadow(Collection<String> shadowTableNames, PreciseColumnShadowValue<Comparable<?>> shadowValue) {
        boolean containTable = shadowTableNames.contains(shadowValue.getLogicTableName());
        boolean isSameOperation = this.shadowOperationType == shadowValue.getShadowOperationType();
        boolean isSameColumnName = Objects.equals(this.props.get(COLUMN), shadowValue.getColumnName());
        boolean isSameColumnValue = this.props.get(VALUE).toString().equals(shadowValue.getValue());
        return containTable && isSameOperation && isSameColumnName && isSameColumnValue;
    }

    public String getType() {
        return "COLUMN_VALUE_MATCH";
    }

    @Generated
    public Properties getProps() {
        return this.props;
    }

    @Generated
    public ShadowOperationType getShadowOperationType() {
        return this.shadowOperationType;
    }

    @Generated
    public void setProps(Properties props) {
        this.props = props;
    }

    @Generated
    public void setShadowOperationType(ShadowOperationType shadowOperationType) {
        this.shadowOperationType = shadowOperationType;
    }
}

