/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.shadow.algorithm.shadow.note;

import java.util.HashMap;
import java.util.Map;
import java.util.Optional;

public final class NoteShadowAlgorithmUtil {
    private static final String SIMPLE_SQL_NOTE_SPACE = ",";
    private static final String SIMPLE_SQL_NOTE_ELEMENT_SPACE = ":";
    private static final String SIMPLE_SQL_NOTE_PREFIX = "/*";
    private static final String SIMPLE_SQL_NOTE_SUFFIX = "*/";

    public static Optional<Map<String, String>> parseSimpleSQLNote(String sqlNoteValue) {
        String noteValue = sqlNoteValue.trim();
        if (noteValue.startsWith(SIMPLE_SQL_NOTE_PREFIX)) {
            noteValue = NoteShadowAlgorithmUtil.removePrefix(noteValue);
        }
        if (noteValue.endsWith(SIMPLE_SQL_NOTE_SUFFIX)) {
            noteValue = NoteShadowAlgorithmUtil.removeSuffix(noteValue);
        }
        if (NoteShadowAlgorithmUtil.isBlank(noteValue)) {
            return Optional.empty();
        }
        noteValue = noteValue.trim();
        String[] noteElements = noteValue.split(SIMPLE_SQL_NOTE_SPACE);
        HashMap<String, String> result = new HashMap<String, String>(noteElements.length);
        String[] stringArray = noteElements;
        int n = stringArray.length;
        for (int i = 0; i < n; ++i) {
            String each;
            String temp = each = stringArray[i];
            String[] split = (temp = temp.trim()).split(SIMPLE_SQL_NOTE_ELEMENT_SPACE);
            if (2 != split.length) continue;
            result.put(split[0].trim(), split[1].trim());
        }
        return Optional.of(result);
    }

    private static String removePrefix(String input) {
        return input.substring(SIMPLE_SQL_NOTE_PREFIX.length());
    }

    private static String removeSuffix(String input) {
        return input.substring(0, input.length() - SIMPLE_SQL_NOTE_SUFFIX.length());
    }

    private static boolean isBlank(String noteValue) {
        int strLen;
        int n = strLen = noteValue == null ? 0 : noteValue.length();
        if (strLen == 0) {
            return true;
        }
        for (int i = 0; i < strLen; ++i) {
            if (Character.isWhitespace(noteValue.charAt(i))) continue;
            return false;
        }
        return true;
    }
}

