/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.shadow.algorithm.shadow.note;

import com.google.common.base.Preconditions;
import java.util.Collection;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Properties;
import lombok.Generated;
import org.apache.shardingsphere.shadow.algorithm.shadow.note.NoteShadowAlgorithmUtil;
import org.apache.shardingsphere.shadow.api.shadow.ShadowOperationType;
import org.apache.shardingsphere.shadow.api.shadow.note.NoteShadowAlgorithm;
import org.apache.shardingsphere.shadow.api.shadow.note.PreciseNoteShadowValue;

public final class SimpleSQLNoteShadowAlgorithm
implements NoteShadowAlgorithm<String> {
    private Properties props = new Properties();

    public void init() {
        this.checkPropsSize();
    }

    private void checkPropsSize() {
        Preconditions.checkState((!this.props.isEmpty() ? 1 : 0) != 0, (Object)"Simple note shadow algorithm props cannot be empty.");
    }

    public boolean isShadow(Collection<String> shadowTableNames, PreciseNoteShadowValue<String> noteShadowValue) {
        if (ShadowOperationType.NOTE_MATCH != noteShadowValue.getShadowOperationType() && !shadowTableNames.contains(noteShadowValue.getLogicTableName())) {
            return false;
        }
        Optional<Map<String, String>> noteOptional = NoteShadowAlgorithmUtil.parseSimpleSQLNote((String)((Object)noteShadowValue.getSqlNoteValue()));
        return noteOptional.filter(stringStringMap -> this.props.entrySet().stream().allMatch(entry -> Objects.equals(entry.getValue(), stringStringMap.get(String.valueOf(entry.getKey()))))).isPresent();
    }

    public String getType() {
        return "SIMPLE_NOTE";
    }

    @Generated
    public Properties getProps() {
        return this.props;
    }

    @Generated
    public void setProps(Properties props) {
        this.props = props;
    }
}

