/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.shadow.checker;

import java.util.Map;
import org.apache.shardingsphere.shadow.algorithm.config.AlgorithmProvidedShadowRuleConfiguration;
import org.apache.shardingsphere.shadow.api.config.datasource.ShadowDataSourceConfiguration;
import org.apache.shardingsphere.shadow.api.config.table.ShadowTableConfiguration;
import org.apache.shardingsphere.shadow.checker.AbstractShadowRuleConfigurationChecker;
import org.apache.shardingsphere.shadow.spi.ShadowAlgorithm;

public final class AlgorithmProvidedShadowRuleConfigurationChecker
extends AbstractShadowRuleConfigurationChecker<AlgorithmProvidedShadowRuleConfiguration> {
    @Override
    protected void checkShadowRuleConfiguration(AlgorithmProvidedShadowRuleConfiguration config) {
        if (config.isEnable()) {
            Map<String, ShadowDataSourceConfiguration> dataSources = config.getDataSources();
            Map<String, ShadowTableConfiguration> shadowTables = config.getTables();
            Map<String, ShadowAlgorithm> shadowAlgorithms = config.getShadowAlgorithms();
            String defaultShadowAlgorithmName = config.getDefaultShadowAlgorithmName();
            this.sizeCheck(dataSources, shadowTables, defaultShadowAlgorithmName);
            this.shadowAlgorithmsSizeCheck(shadowAlgorithms);
            this.shadowTableDataSourcesAutoReferences(shadowTables, dataSources);
            this.shadowTableDataSourcesReferencesCheck(shadowTables, dataSources);
            this.defaultShadowAlgorithmCheck(defaultShadowAlgorithmName, shadowAlgorithms);
            this.shadowTableAlgorithmsAutoReferences(shadowTables, shadowAlgorithms.keySet(), defaultShadowAlgorithmName);
            this.shadowTableAlgorithmsReferencesCheck(shadowTables);
        }
    }

    public int getOrder() {
        return 41;
    }

    public Class<AlgorithmProvidedShadowRuleConfiguration> getTypeClass() {
        return AlgorithmProvidedShadowRuleConfiguration.class;
    }
}

