/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.shadow.route.engine;

import lombok.Generated;
import org.apache.shardingsphere.infra.binder.LogicSQL;
import org.apache.shardingsphere.infra.binder.statement.dml.DeleteStatementContext;
import org.apache.shardingsphere.infra.binder.statement.dml.InsertStatementContext;
import org.apache.shardingsphere.infra.binder.statement.dml.SelectStatementContext;
import org.apache.shardingsphere.infra.binder.statement.dml.UpdateStatementContext;
import org.apache.shardingsphere.shadow.route.engine.ShadowRouteEngine;
import org.apache.shardingsphere.shadow.route.engine.dml.ShadowDeleteStatementRoutingEngine;
import org.apache.shardingsphere.shadow.route.engine.dml.ShadowInsertStatementRoutingEngine;
import org.apache.shardingsphere.shadow.route.engine.dml.ShadowSelectStatementRoutingEngine;
import org.apache.shardingsphere.shadow.route.engine.dml.ShadowUpdateStatementRoutingEngine;
import org.apache.shardingsphere.shadow.route.engine.impl.ShadowNonDMLStatementRoutingEngine;
import org.apache.shardingsphere.sql.parser.sql.common.statement.SQLStatement;
import org.apache.shardingsphere.sql.parser.sql.common.statement.dml.DeleteStatement;
import org.apache.shardingsphere.sql.parser.sql.common.statement.dml.InsertStatement;
import org.apache.shardingsphere.sql.parser.sql.common.statement.dml.SelectStatement;
import org.apache.shardingsphere.sql.parser.sql.common.statement.dml.UpdateStatement;

public final class ShadowRouteEngineFactory {
    public static ShadowRouteEngine newInstance(LogicSQL logicSQL) {
        SQLStatement sqlStatement = logicSQL.getSqlStatementContext().getSqlStatement();
        if (sqlStatement instanceof InsertStatement) {
            return ShadowRouteEngineFactory.createShadowInsertStatementRoutingEngine(logicSQL);
        }
        if (sqlStatement instanceof DeleteStatement) {
            return ShadowRouteEngineFactory.createShadowDeleteStatementRoutingEngine(logicSQL);
        }
        if (sqlStatement instanceof UpdateStatement) {
            return ShadowRouteEngineFactory.createShadowUpdateStatementRoutingEngine(logicSQL);
        }
        if (sqlStatement instanceof SelectStatement) {
            return ShadowRouteEngineFactory.createShadowSelectStatementRoutingEngine(logicSQL);
        }
        return ShadowRouteEngineFactory.createShadowNonMDLStatementRoutingEngine(logicSQL);
    }

    private static ShadowRouteEngine createShadowNonMDLStatementRoutingEngine(LogicSQL logicSQL) {
        return new ShadowNonDMLStatementRoutingEngine(logicSQL.getSqlStatementContext());
    }

    private static ShadowRouteEngine createShadowSelectStatementRoutingEngine(LogicSQL logicSQL) {
        return new ShadowSelectStatementRoutingEngine((SelectStatementContext)logicSQL.getSqlStatementContext(), logicSQL.getParameters());
    }

    private static ShadowRouteEngine createShadowUpdateStatementRoutingEngine(LogicSQL logicSQL) {
        return new ShadowUpdateStatementRoutingEngine((UpdateStatementContext)logicSQL.getSqlStatementContext(), logicSQL.getParameters());
    }

    private static ShadowRouteEngine createShadowDeleteStatementRoutingEngine(LogicSQL logicSQL) {
        return new ShadowDeleteStatementRoutingEngine((DeleteStatementContext)logicSQL.getSqlStatementContext(), logicSQL.getParameters());
    }

    private static ShadowRouteEngine createShadowInsertStatementRoutingEngine(LogicSQL logicSQL) {
        return new ShadowInsertStatementRoutingEngine((InsertStatementContext)logicSQL.getSqlStatementContext());
    }

    @Generated
    private ShadowRouteEngineFactory() {
    }
}

