/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.shadow.route.engine.determiner.algorithm;

import java.util.Collection;
import java.util.LinkedList;
import lombok.Generated;
import org.apache.shardingsphere.shadow.api.shadow.ShadowOperationType;
import org.apache.shardingsphere.shadow.api.shadow.column.ColumnShadowAlgorithm;
import org.apache.shardingsphere.shadow.api.shadow.column.PreciseColumnShadowValue;
import org.apache.shardingsphere.shadow.condition.ShadowColumnCondition;
import org.apache.shardingsphere.shadow.condition.ShadowDetermineCondition;
import org.apache.shardingsphere.shadow.route.engine.determiner.ShadowAlgorithmDeterminer;
import org.apache.shardingsphere.shadow.rule.ShadowRule;

public final class ColumnShadowAlgorithmDeterminer
implements ShadowAlgorithmDeterminer {
    private final ColumnShadowAlgorithm<Comparable<?>> columnShadowAlgorithm;

    @Override
    public boolean isShadow(ShadowDetermineCondition shadowDetermineCondition, ShadowRule shadowRule) {
        Collection<ShadowColumnCondition> shadowColumnConditions = shadowDetermineCondition.getShadowColumnConditions();
        for (ShadowColumnCondition each : shadowColumnConditions) {
            if (!this.isShadowColumn(each, shadowRule, shadowDetermineCondition.getTableName(), shadowDetermineCondition.getShadowOperationType())) continue;
            return true;
        }
        return false;
    }

    private boolean isShadowColumn(ShadowColumnCondition shadowColumnCondition, ShadowRule shadowRule, String tableName, ShadowOperationType operationType) {
        for (PreciseColumnShadowValue<Comparable<?>> each : this.createColumnShadowValues(shadowColumnCondition.getColumn(), shadowColumnCondition.getValues(), tableName, operationType)) {
            if (tableName.equals(shadowColumnCondition.getOwner()) && this.columnShadowAlgorithm.isShadow(shadowRule.getAllShadowTableNames(), each)) continue;
            return false;
        }
        return true;
    }

    private Collection<PreciseColumnShadowValue<Comparable<?>>> createColumnShadowValues(String columnName, Collection<Comparable<?>> columnValues, String tableName, ShadowOperationType operationType) {
        LinkedList result = new LinkedList();
        for (Comparable<?> each : columnValues) {
            result.add(new PreciseColumnShadowValue(tableName, operationType, columnName, each));
        }
        return result;
    }

    @Generated
    public ColumnShadowAlgorithmDeterminer(ColumnShadowAlgorithm<Comparable<?>> columnShadowAlgorithm) {
        this.columnShadowAlgorithm = columnShadowAlgorithm;
    }
}

