/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.shadow.route.engine.dml;

import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.Optional;
import lombok.Generated;
import org.apache.shardingsphere.infra.binder.statement.dml.UpdateStatementContext;
import org.apache.shardingsphere.shadow.api.shadow.ShadowOperationType;
import org.apache.shardingsphere.shadow.condition.ShadowColumnCondition;
import org.apache.shardingsphere.shadow.route.engine.dml.AbstractShadowDMLStatementRouteEngine;
import org.apache.shardingsphere.shadow.route.engine.util.ShadowExtractor;
import org.apache.shardingsphere.sql.parser.sql.common.segment.dml.expr.ExpressionSegment;
import org.apache.shardingsphere.sql.parser.sql.common.segment.dml.predicate.WhereSegment;
import org.apache.shardingsphere.sql.parser.sql.common.segment.generic.table.SimpleTableSegment;
import org.apache.shardingsphere.sql.parser.sql.common.statement.dml.UpdateStatement;
import org.apache.shardingsphere.sql.parser.sql.common.util.ExpressionExtractUtil;

public final class ShadowUpdateStatementRoutingEngine
extends AbstractShadowDMLStatementRouteEngine {
    private final UpdateStatementContext updateStatementContext;
    private final List<Object> parameters;

    @Override
    protected Optional<Collection<ShadowColumnCondition>> parseShadowColumnConditions() {
        LinkedList result = new LinkedList();
        this.updateStatementContext.getWhere().ifPresent(whereSegment -> this.parseWhereSegment((WhereSegment)whereSegment, result));
        return result.isEmpty() ? Optional.empty() : Optional.of(result);
    }

    private void parseWhereSegment(WhereSegment whereSegment, Collection<ShadowColumnCondition> shadowColumnConditions) {
        ExpressionExtractUtil.getAndPredicates((ExpressionSegment)whereSegment.getExpr()).forEach(each -> this.parseAndPredicate(each.getPredicates(), shadowColumnConditions));
    }

    private void parseAndPredicate(Collection<ExpressionSegment> predicates, Collection<ShadowColumnCondition> shadowColumnConditions) {
        predicates.forEach(each -> this.parseExpressionSegment((ExpressionSegment)each, shadowColumnConditions));
    }

    private void parseExpressionSegment(ExpressionSegment expressionSegment, Collection<ShadowColumnCondition> shadowColumnConditions) {
        ShadowExtractor.extractColumn(expressionSegment).ifPresent(columnSegment -> ShadowExtractor.extractValues(expressionSegment, this.parameters).ifPresent(values -> shadowColumnConditions.add(new ShadowColumnCondition(this.getSingleTableName(), columnSegment.getIdentifier().getValue(), (Collection<Comparable<?>>)values))));
    }

    @Override
    protected Collection<SimpleTableSegment> getAllTables() {
        return this.updateStatementContext.getAllTables();
    }

    @Override
    protected ShadowOperationType getShadowOperationType() {
        return ShadowOperationType.UPDATE;
    }

    @Override
    protected Optional<Collection<String>> parseSqlNotes() {
        LinkedList result = new LinkedList();
        ((UpdateStatement)this.updateStatementContext.getSqlStatement()).getCommentSegments().forEach(each -> result.add(each.getText()));
        return result.isEmpty() ? Optional.empty() : Optional.of(result);
    }

    @Generated
    public ShadowUpdateStatementRoutingEngine(UpdateStatementContext updateStatementContext, List<Object> parameters) {
        this.updateStatementContext = updateStatementContext;
        this.parameters = parameters;
    }
}

