/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.shadow.rule;

import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.shardingsphere.infra.config.TypedSPIConfiguration;
import org.apache.shardingsphere.infra.config.algorithm.ShardingSphereAlgorithmConfiguration;
import org.apache.shardingsphere.infra.config.algorithm.ShardingSphereAlgorithmFactory;
import org.apache.shardingsphere.infra.rule.identifier.scope.SchemaRule;
import org.apache.shardingsphere.infra.rule.identifier.type.DataSourceContainedRule;
import org.apache.shardingsphere.shadow.algorithm.config.AlgorithmProvidedShadowRuleConfiguration;
import org.apache.shardingsphere.shadow.api.config.ShadowRuleConfiguration;
import org.apache.shardingsphere.shadow.api.config.datasource.ShadowDataSourceConfiguration;
import org.apache.shardingsphere.shadow.api.config.table.ShadowTableConfiguration;
import org.apache.shardingsphere.shadow.api.shadow.ShadowOperationType;
import org.apache.shardingsphere.shadow.api.shadow.column.ColumnShadowAlgorithm;
import org.apache.shardingsphere.shadow.api.shadow.note.NoteShadowAlgorithm;
import org.apache.shardingsphere.shadow.rule.ShadowDataSourceRule;
import org.apache.shardingsphere.shadow.rule.ShadowTableRule;
import org.apache.shardingsphere.shadow.spi.ShadowAlgorithm;
import org.apache.shardingsphere.spi.ShardingSphereServiceLoader;

public final class ShadowRule
implements SchemaRule,
DataSourceContainedRule {
    private final boolean enable;
    private ShadowAlgorithm defaultShadowAlgorithm;
    private final Map<String, ShadowDataSourceRule> shadowDataSourceMappings = new LinkedHashMap<String, ShadowDataSourceRule>();
    private final Map<String, ShadowAlgorithm> shadowAlgorithms = new LinkedHashMap<String, ShadowAlgorithm>();
    private final Map<String, ShadowTableRule> shadowTableRules = new LinkedHashMap<String, ShadowTableRule>();

    public ShadowRule(ShadowRuleConfiguration shadowRuleConfig) {
        this.enable = shadowRuleConfig.isEnable();
        if (this.enable) {
            this.initShadowDataSourceMappings(shadowRuleConfig.getDataSources());
            this.initShadowAlgorithmConfigurations(shadowRuleConfig.getShadowAlgorithms());
            this.initDefaultShadowAlgorithm(shadowRuleConfig.getDefaultShadowAlgorithmName());
            this.initShadowTableRules(shadowRuleConfig.getTables());
        }
    }

    public ShadowRule(AlgorithmProvidedShadowRuleConfiguration shadowRuleConfig) {
        this.enable = shadowRuleConfig.isEnable();
        if (this.enable) {
            this.initShadowDataSourceMappings(shadowRuleConfig.getDataSources());
            this.initShadowAlgorithms(shadowRuleConfig.getShadowAlgorithms());
            this.initDefaultShadowAlgorithm(shadowRuleConfig.getDefaultShadowAlgorithmName());
            this.initShadowTableRules(shadowRuleConfig.getTables());
        }
    }

    private void initShadowDataSourceMappings(Map<String, ShadowDataSourceConfiguration> dataSources) {
        dataSources.forEach((key, value) -> this.shadowDataSourceMappings.put((String)key, new ShadowDataSourceRule(value.getSourceDataSourceName(), value.getShadowDataSourceName())));
    }

    private void initShadowAlgorithmConfigurations(Map<String, ShardingSphereAlgorithmConfiguration> shadowAlgorithmConfigurations) {
        shadowAlgorithmConfigurations.forEach((key, value) -> this.shadowAlgorithms.put((String)key, (ShadowAlgorithm)ShardingSphereAlgorithmFactory.createAlgorithm((TypedSPIConfiguration)value, ShadowAlgorithm.class)));
    }

    private void initShadowAlgorithms(Map<String, ShadowAlgorithm> shadowAlgorithms) {
        this.shadowAlgorithms.putAll(shadowAlgorithms);
    }

    private void initDefaultShadowAlgorithm(String defaultShadowAlgorithmName) {
        this.defaultShadowAlgorithm = this.shadowAlgorithms.get(defaultShadowAlgorithmName);
    }

    private void initShadowTableRules(Map<String, ShadowTableConfiguration> tables) {
        tables.forEach((key, value) -> this.shadowTableRules.put((String)key, new ShadowTableRule((String)key, value.getDataSourceNames(), value.getShadowAlgorithmNames(), this.shadowAlgorithms)));
    }

    public Optional<ShadowAlgorithm> getDefaultShadowAlgorithm() {
        return null == this.defaultShadowAlgorithm ? Optional.empty() : Optional.of(this.defaultShadowAlgorithm);
    }

    public Collection<String> getRelatedShadowTables(Collection<String> tableNames) {
        return tableNames.stream().filter(this.shadowTableRules.keySet()::contains).collect(Collectors.toCollection(LinkedList::new));
    }

    public Collection<String> getAllShadowTableNames() {
        return this.shadowTableRules.keySet();
    }

    public Optional<Collection<NoteShadowAlgorithm<Comparable<?>>>> getAllNoteShadowAlgorithms() {
        Collection result = this.shadowAlgorithms.values().stream().filter(each -> each instanceof NoteShadowAlgorithm).map(each -> (NoteShadowAlgorithm)each).collect(Collectors.toCollection(LinkedList::new));
        if (this.defaultShadowAlgorithm instanceof NoteShadowAlgorithm) {
            result.add((NoteShadowAlgorithm)this.defaultShadowAlgorithm);
        }
        return result.isEmpty() ? Optional.empty() : Optional.of(result);
    }

    public Optional<Collection<NoteShadowAlgorithm<Comparable<?>>>> getRelatedNoteShadowAlgorithms(String tableName) {
        Collection result = this.shadowTableRules.get(tableName).getNoteShadowAlgorithmNames().stream().map(this.shadowAlgorithms::get).filter(shadowAlgorithm -> !Objects.isNull(shadowAlgorithm)).map(shadowAlgorithm -> (NoteShadowAlgorithm)shadowAlgorithm).collect(Collectors.toCollection(LinkedList::new));
        return result.isEmpty() ? Optional.of(result) : Optional.of(result);
    }

    public Optional<Collection<ColumnShadowAlgorithm<Comparable<?>>>> getRelatedColumnShadowAlgorithms(String tableName, ShadowOperationType shadowOperationType) {
        Collection result = this.shadowTableRules.get(tableName).getColumnShadowAlgorithmNames().get(shadowOperationType).stream().map(this.shadowAlgorithms::get).filter(shadowAlgorithm -> !Objects.isNull(shadowAlgorithm)).map(shadowAlgorithm -> (ColumnShadowAlgorithm)shadowAlgorithm).collect(Collectors.toCollection(LinkedList::new));
        return result.isEmpty() ? Optional.of(result) : Optional.of(result);
    }

    public Optional<Map<String, String>> getRelatedShadowDataSourceMappings(String tableName) {
        Map result = this.shadowTableRules.get(tableName).getShadowDataSources().stream().map(this.shadowDataSourceMappings::get).filter(Objects::nonNull).collect(Collectors.toMap(ShadowDataSourceRule::getSourceDataSource, ShadowDataSourceRule::getShadowDataSource, (a, b) -> b, LinkedHashMap::new));
        return result.isEmpty() ? Optional.empty() : Optional.of(result);
    }

    public Map<String, String> getAllShadowDataSourceMappings() {
        return this.shadowDataSourceMappings.values().stream().collect(Collectors.toMap(ShadowDataSourceRule::getSourceDataSource, ShadowDataSourceRule::getShadowDataSource, (key, value) -> value, LinkedHashMap::new));
    }

    public Map<String, Collection<String>> getDataSourceMapper() {
        return this.shadowDataSourceMappings.values().stream().collect(Collectors.toMap(ShadowDataSourceRule::getSourceDataSource, each -> Arrays.asList(each.getSourceDataSource(), each.getShadowDataSource()), (key, value) -> value, () -> new HashMap(this.shadowDataSourceMappings.size(), 1.0f)));
    }

    public String getType() {
        return ShadowRule.class.getSimpleName();
    }

    @Generated
    public boolean isEnable() {
        return this.enable;
    }

    @Generated
    public Map<String, ShadowDataSourceRule> getShadowDataSourceMappings() {
        return this.shadowDataSourceMappings;
    }

    @Generated
    public Map<String, ShadowAlgorithm> getShadowAlgorithms() {
        return this.shadowAlgorithms;
    }

    @Generated
    public Map<String, ShadowTableRule> getShadowTableRules() {
        return this.shadowTableRules;
    }

    static {
        ShardingSphereServiceLoader.register(ShadowAlgorithm.class);
    }
}

