/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.sharding.algorithm.sharding.complex;

import com.google.common.base.Preconditions;
import groovy.lang.Closure;
import groovy.util.Expando;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.Properties;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.shardingsphere.sharding.api.sharding.complex.ComplexKeysShardingAlgorithm;
import org.apache.shardingsphere.sharding.api.sharding.complex.ComplexKeysShardingValue;
import org.apache.shardingsphere.sharding.support.InlineExpressionParser;

public final class ComplexInlineShardingAlgorithm
implements ComplexKeysShardingAlgorithm<Comparable<?>> {
    private static final String ALGORITHM_EXPRESSION_KEY = "algorithm-expression";
    private static final String SHARING_COLUMNS_KEY = "sharding-columns";
    private static final String ALLOW_RANGE_QUERY_KEY = "allow-range-query-with-inline-sharding";
    private boolean allowRangeQuery;
    private String[] shardingColumns;
    private String algorithmExpression;
    private Properties props = new Properties();

    public void init() {
        String expression = this.props.getProperty(ALGORITHM_EXPRESSION_KEY);
        Preconditions.checkNotNull((Object)expression, (Object)"Inline sharding algorithm expression cannot be null.");
        this.algorithmExpression = InlineExpressionParser.handlePlaceHolder((String)expression.trim());
        this.initShardingColumns(this.props.getProperty(SHARING_COLUMNS_KEY, ""));
        this.allowRangeQuery = Boolean.parseBoolean(this.props.getOrDefault((Object)ALLOW_RANGE_QUERY_KEY, Boolean.FALSE.toString()).toString());
    }

    private void initShardingColumns(String shardingColumns) {
        this.shardingColumns = shardingColumns.isEmpty() ? new String[]{} : shardingColumns.split(",");
    }

    public Collection<String> doSharding(Collection<String> availableTargetNames, ComplexKeysShardingValue<Comparable<?>> shardingValue) {
        if (!shardingValue.getColumnNameAndRangeValuesMap().isEmpty()) {
            if (this.allowRangeQuery) {
                return availableTargetNames;
            }
            throw new UnsupportedOperationException("Since the property of `allow-range-query-with-inline-sharding` is false, inline sharding algorithm can not tackle with range query.");
        }
        Map columnNameAndShardingValuesMap = shardingValue.getColumnNameAndShardingValuesMap();
        if (this.shardingColumns.length > 0 && this.shardingColumns.length != columnNameAndShardingValuesMap.size()) {
            throw new IllegalArgumentException("complex inline need " + this.shardingColumns.length + " sharing columns, but only found " + columnNameAndShardingValuesMap.size());
        }
        Collection combine = ComplexInlineShardingAlgorithm.combine(columnNameAndShardingValuesMap);
        return combine.stream().map(this::doSharding).collect(Collectors.toList());
    }

    private String doSharding(Map<String, Comparable<?>> shardingValues) {
        Closure<?> closure = this.createClosure();
        for (Map.Entry<String, Comparable<?>> entry : shardingValues.entrySet()) {
            closure.setProperty(entry.getKey(), entry.getValue());
        }
        return closure.call().toString();
    }

    private static <K, V> Collection<Map<K, V>> combine(Map<K, Collection<V>> map) {
        LinkedList<Map<K, V>> result = new LinkedList<Map<K, V>>();
        for (Map.Entry<K, Collection<V>> entry : map.entrySet()) {
            if (result.isEmpty()) {
                for (V value : entry.getValue()) {
                    HashMap<K, V> hashMap = new HashMap<K, V>();
                    hashMap.put(entry.getKey(), value);
                    result.add(hashMap);
                }
                continue;
            }
            LinkedList list = new LinkedList();
            for (Map map2 : result) {
                for (V value : entry.getValue()) {
                    HashMap<K, V> item = new HashMap<K, V>();
                    item.put(entry.getKey(), value);
                    item.putAll(map2);
                    list.add(item);
                }
            }
            result = list;
        }
        return result;
    }

    private Closure<?> createClosure() {
        Closure result = new InlineExpressionParser(this.algorithmExpression).evaluateClosure().rehydrate((Object)new Expando(), null, null);
        result.setResolveStrategy(3);
        return result;
    }

    public String getType() {
        return "COMPLEX_INLINE";
    }

    @Generated
    public Properties getProps() {
        return this.props;
    }

    @Generated
    public void setProps(Properties props) {
        this.props = props;
    }
}

