/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.sharding.algorithm.sharding.hint;

import com.google.common.base.Preconditions;
import groovy.lang.Closure;
import groovy.util.Expando;
import java.util.Collection;
import java.util.Properties;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.shardingsphere.sharding.api.sharding.hint.HintShardingAlgorithm;
import org.apache.shardingsphere.sharding.api.sharding.hint.HintShardingValue;
import org.apache.shardingsphere.sharding.support.InlineExpressionParser;

public final class HintInlineShardingAlgorithm
implements HintShardingAlgorithm<Comparable<?>> {
    private static final String ALGORITHM_EXPRESSION_KEY = "algorithm-expression";
    private static final String DEFAULT_ALGORITHM_EXPRESSION = "${value}";
    private static final String HINT_INLINE_VALUE_PROPERTY_NAME = "value";
    private String algorithmExpression;
    private Properties props = new Properties();

    public void init() {
        String expression = this.props.getProperty(ALGORITHM_EXPRESSION_KEY, DEFAULT_ALGORITHM_EXPRESSION);
        Preconditions.checkNotNull((Object)expression, (Object)"Inline sharding algorithm expression cannot be null.");
        this.algorithmExpression = InlineExpressionParser.handlePlaceHolder((String)expression.trim());
    }

    public Collection<String> doSharding(Collection<String> availableTargetNames, HintShardingValue<Comparable<?>> shardingValue) {
        return shardingValue.getValues().isEmpty() ? availableTargetNames : (Collection)shardingValue.getValues().stream().map(this::doSharding).collect(Collectors.toList());
    }

    private String doSharding(Comparable<?> shardingValue) {
        Closure<?> closure = this.createClosure();
        closure.setProperty(HINT_INLINE_VALUE_PROPERTY_NAME, shardingValue);
        return closure.call().toString();
    }

    private Closure<?> createClosure() {
        Closure result = new InlineExpressionParser(this.algorithmExpression).evaluateClosure().rehydrate((Object)new Expando(), null, null);
        result.setResolveStrategy(3);
        return result;
    }

    public String getType() {
        return "HINT_INLINE";
    }

    @Generated
    public Properties getProps() {
        return this.props;
    }

    @Generated
    public void setProps(Properties props) {
        this.props = props;
    }
}

