/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.sharding.algorithm.sharding.range;

import com.google.common.collect.Range;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Properties;
import lombok.Generated;
import org.apache.shardingsphere.sharding.api.sharding.ShardingAutoTableAlgorithm;
import org.apache.shardingsphere.sharding.api.sharding.standard.PreciseShardingValue;
import org.apache.shardingsphere.sharding.api.sharding.standard.RangeShardingValue;
import org.apache.shardingsphere.sharding.api.sharding.standard.StandardShardingAlgorithm;

public abstract class AbstractRangeShardingAlgorithm
implements StandardShardingAlgorithm<Comparable<?>>,
ShardingAutoTableAlgorithm {
    private volatile Map<Integer, Range<Comparable<?>>> partitionRange;
    private Properties props = new Properties();

    public final void init() {
        this.partitionRange = this.calculatePartitionRange(this.props);
    }

    protected abstract Map<Integer, Range<Comparable<?>>> calculatePartitionRange(Properties var1);

    public final String doSharding(Collection<String> availableTargetNames, PreciseShardingValue<Comparable<?>> shardingValue) {
        return availableTargetNames.stream().filter(each -> each.endsWith(String.valueOf(this.getPartition(shardingValue.getValue())))).findFirst().orElse(null);
    }

    public final Collection<String> doSharding(Collection<String> availableTargetNames, RangeShardingValue<Comparable<?>> shardingValue) {
        LinkedHashSet<String> result = new LinkedHashSet<String>(availableTargetNames.size());
        int firstPartition = this.getFirstPartition(shardingValue.getValueRange());
        int lastPartition = this.getLastPartition(shardingValue.getValueRange());
        for (int partition = firstPartition; partition <= lastPartition; ++partition) {
            for (String each : availableTargetNames) {
                if (!each.endsWith(String.valueOf(partition))) continue;
                result.add(each);
            }
        }
        return result;
    }

    private int getFirstPartition(Range<Comparable<?>> valueRange) {
        return valueRange.hasLowerBound() ? this.getPartition(valueRange.lowerEndpoint()) : 0;
    }

    private int getLastPartition(Range<Comparable<?>> valueRange) {
        return valueRange.hasUpperBound() ? this.getPartition(valueRange.upperEndpoint()) : this.partitionRange.size() - 1;
    }

    private Integer getPartition(Comparable<?> value) {
        for (Map.Entry<Integer, Range<Comparable<?>>> entry : this.partitionRange.entrySet()) {
            if (!entry.getValue().contains((Comparable)this.getLongValue(value))) continue;
            return entry.getKey();
        }
        throw new UnsupportedOperationException("");
    }

    private Long getLongValue(Comparable<?> value) {
        return Long.parseLong(value.toString());
    }

    public final int getAutoTablesAmount() {
        return this.partitionRange.size();
    }

    @Generated
    public Properties getProps() {
        return this.props;
    }

    @Generated
    public void setProps(Properties props) {
        this.props = props;
    }
}

