/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.sharding.rewrite.token.generator.impl.keygen;

import com.google.common.base.Preconditions;
import java.util.List;
import java.util.Optional;
import lombok.Generated;
import org.apache.shardingsphere.infra.binder.segment.insert.keygen.GeneratedKeyContext;
import org.apache.shardingsphere.infra.binder.statement.dml.InsertStatementContext;
import org.apache.shardingsphere.infra.rewrite.sql.token.generator.aware.ParametersAware;
import org.apache.shardingsphere.sharding.rewrite.token.generator.impl.keygen.BaseGeneratedKeyTokenGenerator;
import org.apache.shardingsphere.sharding.rewrite.token.pojo.GeneratedKeyAssignmentToken;
import org.apache.shardingsphere.sharding.rewrite.token.pojo.LiteralGeneratedKeyAssignmentToken;
import org.apache.shardingsphere.sharding.rewrite.token.pojo.ParameterMarkerGeneratedKeyAssignmentToken;
import org.apache.shardingsphere.sql.parser.sql.common.segment.dml.assignment.SetAssignmentSegment;
import org.apache.shardingsphere.sql.parser.sql.common.statement.dml.InsertStatement;
import org.apache.shardingsphere.sql.parser.sql.dialect.handler.dml.InsertStatementHandler;

public final class GeneratedKeyAssignmentTokenGenerator
extends BaseGeneratedKeyTokenGenerator
implements ParametersAware {
    private List<Object> parameters;

    @Override
    protected boolean isGenerateSQLToken(InsertStatementContext insertStatementContext) {
        return InsertStatementHandler.getSetAssignmentSegment((InsertStatement)((InsertStatement)insertStatementContext.getSqlStatement())).isPresent();
    }

    public GeneratedKeyAssignmentToken generateSQLToken(InsertStatementContext insertStatementContext) {
        Optional generatedKey = insertStatementContext.getGeneratedKeyContext();
        Preconditions.checkState((boolean)generatedKey.isPresent());
        InsertStatement insertStatement = (InsertStatement)insertStatementContext.getSqlStatement();
        Preconditions.checkState((boolean)InsertStatementHandler.getSetAssignmentSegment((InsertStatement)insertStatement).isPresent());
        int startIndex = ((SetAssignmentSegment)InsertStatementHandler.getSetAssignmentSegment((InsertStatement)insertStatement).get()).getStopIndex() + 1;
        return this.parameters.isEmpty() ? new LiteralGeneratedKeyAssignmentToken(startIndex, ((GeneratedKeyContext)generatedKey.get()).getColumnName(), ((GeneratedKeyContext)generatedKey.get()).getGeneratedValues().iterator().next()) : new ParameterMarkerGeneratedKeyAssignmentToken(startIndex, ((GeneratedKeyContext)generatedKey.get()).getColumnName());
    }

    @Generated
    public void setParameters(List<Object> parameters) {
        this.parameters = parameters;
    }
}

