/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.sharding.route.engine.condition;

import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.shardingsphere.infra.binder.statement.SQLStatementContext;
import org.apache.shardingsphere.infra.binder.statement.dml.InsertStatementContext;
import org.apache.shardingsphere.infra.binder.statement.dml.SelectStatementContext;
import org.apache.shardingsphere.infra.hint.HintManager;
import org.apache.shardingsphere.sharding.api.config.strategy.sharding.HintShardingStrategyConfiguration;
import org.apache.shardingsphere.sharding.route.engine.condition.AlwaysFalseShardingCondition;
import org.apache.shardingsphere.sharding.route.engine.condition.ShardingCondition;
import org.apache.shardingsphere.sharding.route.engine.condition.value.ListShardingConditionValue;
import org.apache.shardingsphere.sharding.route.engine.condition.value.RangeShardingConditionValue;
import org.apache.shardingsphere.sharding.route.engine.condition.value.ShardingConditionValue;
import org.apache.shardingsphere.sharding.rule.BindingTableRule;
import org.apache.shardingsphere.sharding.rule.ShardingRule;
import org.apache.shardingsphere.sharding.rule.TableRule;
import org.apache.shardingsphere.sql.parser.sql.common.segment.dml.expr.subquery.SubquerySegment;
import org.apache.shardingsphere.sql.parser.sql.common.segment.dml.predicate.WhereSegment;
import org.apache.shardingsphere.sql.parser.sql.common.segment.generic.table.SubqueryTableSegment;
import org.apache.shardingsphere.sql.parser.sql.common.statement.dml.SelectStatement;
import org.apache.shardingsphere.sql.parser.sql.common.util.SafeNumberOperationUtil;

public final class ShardingConditions {
    private final List<ShardingCondition> conditions;
    private final SQLStatementContext<?> sqlStatementContext;
    private final ShardingRule rule;
    private final boolean subqueryContainsShardingCondition;

    public ShardingConditions(List<ShardingCondition> conditions, SQLStatementContext<?> sqlStatementContext, ShardingRule rule) {
        this.conditions = conditions;
        this.sqlStatementContext = sqlStatementContext;
        this.rule = rule;
        this.subqueryContainsShardingCondition = this.isSubqueryContainsShardingCondition(conditions, sqlStatementContext);
    }

    public boolean isAlwaysFalse() {
        if (this.conditions.isEmpty()) {
            return false;
        }
        for (ShardingCondition each : this.conditions) {
            if (each instanceof AlwaysFalseShardingCondition) continue;
            return false;
        }
        return true;
    }

    public void merge() {
        if (this.conditions.size() > 1) {
            ArrayList<ShardingCondition> result = new ArrayList<ShardingCondition>();
            result.add(this.conditions.remove(this.conditions.size() - 1));
            while (this.conditions.size() > 0) {
                this.findUniqueShardingCondition(result, this.conditions.remove(this.conditions.size() - 1)).ifPresent(result::add);
            }
            this.conditions.addAll(result);
        }
    }

    private Optional<ShardingCondition> findUniqueShardingCondition(List<ShardingCondition> conditions, ShardingCondition condition) {
        for (ShardingCondition each : conditions) {
            if (!this.isSameShardingCondition(this.rule, condition, each)) continue;
            return Optional.empty();
        }
        return Optional.of(condition);
    }

    public boolean isNeedMerge() {
        boolean selectContainsSubquery = this.sqlStatementContext instanceof SelectStatementContext && ((SelectStatementContext)this.sqlStatementContext).isContainsSubquery();
        boolean insertSelectContainsSubquery = this.sqlStatementContext instanceof InsertStatementContext && null != ((InsertStatementContext)this.sqlStatementContext).getInsertSelectContext() && ((InsertStatementContext)this.sqlStatementContext).getInsertSelectContext().getSelectStatementContext().isContainsSubquery();
        return (selectContainsSubquery || insertSelectContainsSubquery) && !this.rule.getShardingLogicTableNames(this.sqlStatementContext.getTablesContext().getTableNames()).isEmpty();
    }

    private boolean isSubqueryContainsShardingCondition(List<ShardingCondition> conditions, SQLStatementContext<?> sqlStatementContext) {
        Collection<SelectStatement> selectStatements = this.getSelectStatements(sqlStatementContext);
        if (selectStatements.size() > 1) {
            Map<Integer, List<ShardingCondition>> startIndexShardingConditions = conditions.stream().collect(Collectors.groupingBy(ShardingCondition::getStartIndex));
            for (SelectStatement each : selectStatements) {
                if (each.getFrom() instanceof SubqueryTableSegment || each.getWhere().isPresent() && startIndexShardingConditions.containsKey(((WhereSegment)each.getWhere().get()).getExpr().getStartIndex())) continue;
                return false;
            }
        }
        return true;
    }

    private Collection<SelectStatement> getSelectStatements(SQLStatementContext<?> sqlStatementContext) {
        LinkedList<SelectStatement> result = new LinkedList<SelectStatement>();
        if (sqlStatementContext instanceof SelectStatementContext) {
            result.add((SelectStatement)((SelectStatementContext)sqlStatementContext).getSqlStatement());
            result.addAll(((SelectStatementContext)sqlStatementContext).getSubquerySegments().stream().map(SubquerySegment::getSelect).collect(Collectors.toList()));
        }
        if (sqlStatementContext instanceof InsertStatementContext && null != ((InsertStatementContext)sqlStatementContext).getInsertSelectContext()) {
            SelectStatementContext selectStatementContext = ((InsertStatementContext)sqlStatementContext).getInsertSelectContext().getSelectStatementContext();
            result.add((SelectStatement)selectStatementContext.getSqlStatement());
            result.addAll(selectStatementContext.getSubquerySegments().stream().map(SubquerySegment::getSelect).collect(Collectors.toList()));
        }
        return result;
    }

    public boolean isSameShardingCondition() {
        for (String each : this.sqlStatementContext.getTablesContext().getTableNames()) {
            Optional<TableRule> tableRule = this.rule.findTableRule(each);
            if (!tableRule.isPresent() || !this.isRoutingByHint(this.rule, tableRule.get()) || HintManager.getDatabaseShardingValues((String)each).isEmpty() || HintManager.getTableShardingValues((String)each).isEmpty()) continue;
            return false;
        }
        return this.subqueryContainsShardingCondition && this.conditions.size() == 1;
    }

    private boolean isSameShardingCondition(ShardingRule shardingRule, ShardingCondition shardingCondition1, ShardingCondition shardingCondition2) {
        if (shardingCondition1.getValues().size() != shardingCondition2.getValues().size()) {
            return false;
        }
        for (int i = 0; i < shardingCondition1.getValues().size(); ++i) {
            ShardingConditionValue shardingValue2;
            ShardingConditionValue shardingValue1 = shardingCondition1.getValues().get(i);
            if (this.isSameShardingConditionValue(shardingRule, shardingValue1, shardingValue2 = shardingCondition2.getValues().get(i))) continue;
            return false;
        }
        return true;
    }

    private boolean isSameShardingCondition(ShardingRule shardingRule, ShardingConditionValue shardingValue1, ShardingConditionValue shardingValue2) {
        return shardingValue1.getTableName().equals(shardingValue2.getTableName()) && shardingValue1.getColumnName().equals(shardingValue2.getColumnName()) || this.isBindingTable(shardingRule, shardingValue1, shardingValue2);
    }

    private boolean isBindingTable(ShardingRule shardingRule, ShardingConditionValue shardingValue1, ShardingConditionValue shardingValue2) {
        Optional<BindingTableRule> bindingRule = shardingRule.findBindingTableRule(shardingValue1.getTableName());
        return bindingRule.isPresent() && bindingRule.get().hasLogicTable(shardingValue2.getTableName());
    }

    private boolean isRoutingByHint(ShardingRule shardingRule, TableRule tableRule) {
        return shardingRule.getDatabaseShardingStrategyConfiguration(tableRule) instanceof HintShardingStrategyConfiguration && shardingRule.getTableShardingStrategyConfiguration(tableRule) instanceof HintShardingStrategyConfiguration;
    }

    private boolean isSameShardingConditionValue(ShardingRule shardingRule, ShardingConditionValue shardingValue1, ShardingConditionValue shardingValue2) {
        return this.isSameShardingCondition(shardingRule, shardingValue1, shardingValue2) && this.isSameShardingValue(shardingValue1, shardingValue2);
    }

    private boolean isSameShardingValue(ShardingConditionValue shardingConditionValue1, ShardingConditionValue shardingConditionValue2) {
        if (shardingConditionValue1 instanceof ListShardingConditionValue && shardingConditionValue2 instanceof ListShardingConditionValue) {
            return SafeNumberOperationUtil.safeCollectionEquals(((ListShardingConditionValue)shardingConditionValue1).getValues(), ((ListShardingConditionValue)shardingConditionValue2).getValues());
        }
        if (shardingConditionValue1 instanceof RangeShardingConditionValue && shardingConditionValue2 instanceof RangeShardingConditionValue) {
            return SafeNumberOperationUtil.safeRangeEquals(((RangeShardingConditionValue)shardingConditionValue1).getValueRange(), ((RangeShardingConditionValue)shardingConditionValue2).getValueRange());
        }
        return false;
    }

    @Generated
    public List<ShardingCondition> getConditions() {
        return this.conditions;
    }

    @Generated
    public SQLStatementContext<?> getSqlStatementContext() {
        return this.sqlStatementContext;
    }

    @Generated
    public ShardingRule getRule() {
        return this.rule;
    }

    @Generated
    public boolean isSubqueryContainsShardingCondition() {
        return this.subqueryContainsShardingCondition;
    }

    @Generated
    public String toString() {
        return "ShardingConditions(conditions=" + this.getConditions() + ", sqlStatementContext=" + this.getSqlStatementContext() + ", rule=" + this.getRule() + ", subqueryContainsShardingCondition=" + this.isSubqueryContainsShardingCondition() + ")";
    }
}

