/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.sharding.route.engine.validator.ddl.impl;

import java.util.List;
import java.util.Optional;
import org.apache.shardingsphere.infra.binder.statement.SQLStatementContext;
import org.apache.shardingsphere.infra.exception.ShardingSphereException;
import org.apache.shardingsphere.infra.metadata.schema.ShardingSphereSchema;
import org.apache.shardingsphere.infra.route.context.RouteContext;
import org.apache.shardingsphere.sharding.route.engine.validator.ddl.ShardingDDLStatementValidator;
import org.apache.shardingsphere.sharding.rule.ShardingRule;
import org.apache.shardingsphere.sql.parser.sql.common.segment.ddl.index.IndexSegment;
import org.apache.shardingsphere.sql.parser.sql.common.statement.ddl.AlterIndexStatement;
import org.apache.shardingsphere.sql.parser.sql.dialect.handler.ddl.AlterIndexStatementHandler;

public final class ShardingAlterIndexStatementValidator
extends ShardingDDLStatementValidator<AlterIndexStatement> {
    @Override
    public void preValidate(ShardingRule shardingRule, SQLStatementContext<AlterIndexStatement> sqlStatementContext, List<Object> parameters, ShardingSphereSchema schema) {
        Optional index = ((AlterIndexStatement)sqlStatementContext.getSqlStatement()).getIndex();
        if (index.isPresent() && !this.isSchemaContainsIndex(schema, (IndexSegment)index.get())) {
            throw new ShardingSphereException("Index '%s' does not exist.", new Object[]{((IndexSegment)index.get()).getIdentifier().getValue()});
        }
        Optional renameIndex = AlterIndexStatementHandler.getRenameIndexSegment((AlterIndexStatement)((AlterIndexStatement)sqlStatementContext.getSqlStatement()));
        if (renameIndex.isPresent() && this.isSchemaContainsIndex(schema, (IndexSegment)renameIndex.get())) {
            throw new ShardingSphereException("Index '%s' already exists.", new Object[]{((IndexSegment)renameIndex.get()).getIdentifier().getValue()});
        }
    }

    @Override
    public void postValidate(ShardingRule shardingRule, SQLStatementContext<AlterIndexStatement> sqlStatementContext, RouteContext routeContext, ShardingSphereSchema schema) {
    }
}

