/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.sharding.rule;

import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Optional;
import lombok.Generated;
import org.apache.shardingsphere.infra.config.exception.ShardingSphereConfigurationException;
import org.apache.shardingsphere.sharding.rule.TableRule;

public final class BindingTableRule {
    private final Map<String, TableRule> tableRules = new LinkedHashMap<String, TableRule>();

    public boolean hasLogicTable(String logicTable) {
        return this.tableRules.containsKey(logicTable.toLowerCase());
    }

    public String getBindingActualTable(String dataSource, String logicTable, String otherActualTable) {
        TableRule each;
        int index = -1;
        Iterator<TableRule> iterator = this.tableRules.values().iterator();
        while (iterator.hasNext() && -1 == (index = (each = iterator.next()).findActualTableIndex(dataSource, otherActualTable))) {
        }
        if (-1 == index) {
            throw new ShardingSphereConfigurationException("Actual table [%s].[%s] is not in table config", new Object[]{dataSource, otherActualTable});
        }
        Optional<TableRule> tableRule = Optional.ofNullable(this.tableRules.get(logicTable.toLowerCase()));
        if (tableRule.isPresent()) {
            return tableRule.get().getActualDataNodes().get(index).getTableName();
        }
        throw new ShardingSphereConfigurationException("Cannot find binding actual table, data source: %s, logic table: %s, other actual table: %s", new Object[]{dataSource, logicTable, otherActualTable});
    }

    public Collection<String> getAllLogicTables() {
        return this.tableRules.keySet();
    }

    Map<String, String> getLogicAndActualTables(String dataSource, String logicTable, String actualTable, Collection<String> availableLogicBindingTables) {
        LinkedHashMap<String, String> result = new LinkedHashMap<String, String>();
        for (String each : availableLogicBindingTables) {
            String availableLogicTable = each.toLowerCase();
            if (availableLogicTable.equalsIgnoreCase(logicTable) || !this.hasLogicTable(availableLogicTable)) continue;
            result.put(availableLogicTable, this.getBindingActualTable(dataSource, availableLogicTable, actualTable));
        }
        return result;
    }

    @Generated
    public BindingTableRule() {
    }

    @Generated
    public Map<String, TableRule> getTableRules() {
        return this.tableRules;
    }
}

