/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.sharding.rule;

import com.google.common.base.Preconditions;
import com.google.common.base.Splitter;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.TreeSet;
import java.util.function.Function;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.shardingsphere.infra.config.TypedSPIConfiguration;
import org.apache.shardingsphere.infra.config.algorithm.ShardingSphereAlgorithmFactory;
import org.apache.shardingsphere.infra.config.exception.ShardingSphereConfigurationException;
import org.apache.shardingsphere.infra.datanode.DataNode;
import org.apache.shardingsphere.infra.rule.identifier.scope.SchemaRule;
import org.apache.shardingsphere.infra.rule.identifier.type.DataNodeContainedRule;
import org.apache.shardingsphere.infra.rule.identifier.type.TableContainedRule;
import org.apache.shardingsphere.sharding.algorithm.config.AlgorithmProvidedShardingRuleConfiguration;
import org.apache.shardingsphere.sharding.api.config.ShardingRuleConfiguration;
import org.apache.shardingsphere.sharding.api.config.rule.ShardingAutoTableRuleConfiguration;
import org.apache.shardingsphere.sharding.api.config.rule.ShardingTableRuleConfiguration;
import org.apache.shardingsphere.sharding.api.config.strategy.keygen.KeyGenerateStrategyConfiguration;
import org.apache.shardingsphere.sharding.api.config.strategy.sharding.ComplexShardingStrategyConfiguration;
import org.apache.shardingsphere.sharding.api.config.strategy.sharding.NoneShardingStrategyConfiguration;
import org.apache.shardingsphere.sharding.api.config.strategy.sharding.ShardingStrategyConfiguration;
import org.apache.shardingsphere.sharding.api.config.strategy.sharding.StandardShardingStrategyConfiguration;
import org.apache.shardingsphere.sharding.api.sharding.ShardingAutoTableAlgorithm;
import org.apache.shardingsphere.sharding.rule.BindingTableRule;
import org.apache.shardingsphere.sharding.rule.TableRule;
import org.apache.shardingsphere.sharding.spi.KeyGenerateAlgorithm;
import org.apache.shardingsphere.sharding.spi.ShardingAlgorithm;
import org.apache.shardingsphere.sharding.support.InlineExpressionParser;
import org.apache.shardingsphere.spi.ShardingSphereServiceLoader;
import org.apache.shardingsphere.spi.required.RequiredSPIRegistry;

public final class ShardingRule
implements SchemaRule,
DataNodeContainedRule,
TableContainedRule {
    private final Collection<String> dataSourceNames;
    private final Map<String, ShardingAlgorithm> shardingAlgorithms = new LinkedHashMap<String, ShardingAlgorithm>();
    private final Map<String, KeyGenerateAlgorithm> keyGenerators = new LinkedHashMap<String, KeyGenerateAlgorithm>();
    private final Map<String, TableRule> tableRules = new LinkedHashMap<String, TableRule>();
    private final Collection<BindingTableRule> bindingTableRules;
    private final Collection<String> broadcastTables;
    private final ShardingStrategyConfiguration defaultDatabaseShardingStrategyConfig;
    private final ShardingStrategyConfiguration defaultTableShardingStrategyConfig;
    private final KeyGenerateAlgorithm defaultKeyGenerateAlgorithm;
    private final String defaultShardingColumn;

    public ShardingRule(ShardingRuleConfiguration config, Collection<String> dataSourceNames) {
        this.dataSourceNames = this.getDataSourceNames(config.getTables(), config.getAutoTables(), dataSourceNames);
        config.getShardingAlgorithms().forEach((key, value) -> this.shardingAlgorithms.put((String)key, (ShardingAlgorithm)ShardingSphereAlgorithmFactory.createAlgorithm((TypedSPIConfiguration)value, ShardingAlgorithm.class)));
        config.getKeyGenerators().forEach((key, value) -> this.keyGenerators.put((String)key, (KeyGenerateAlgorithm)ShardingSphereAlgorithmFactory.createAlgorithm((TypedSPIConfiguration)value, KeyGenerateAlgorithm.class)));
        this.tableRules.putAll(this.createTableRules(config.getTables(), config.getDefaultKeyGenerateStrategy()));
        this.tableRules.putAll(this.createAutoTableRules(config.getAutoTables(), config.getDefaultKeyGenerateStrategy()));
        this.broadcastTables = this.createBroadcastTables(config.getBroadcastTables());
        this.bindingTableRules = this.createBindingTableRules(config.getBindingTableGroups());
        this.defaultDatabaseShardingStrategyConfig = null == config.getDefaultDatabaseShardingStrategy() ? new NoneShardingStrategyConfiguration() : config.getDefaultDatabaseShardingStrategy();
        this.defaultTableShardingStrategyConfig = null == config.getDefaultTableShardingStrategy() ? new NoneShardingStrategyConfiguration() : config.getDefaultTableShardingStrategy();
        this.defaultKeyGenerateAlgorithm = null == config.getDefaultKeyGenerateStrategy() ? (KeyGenerateAlgorithm)RequiredSPIRegistry.getRegisteredService(KeyGenerateAlgorithm.class) : this.keyGenerators.get(config.getDefaultKeyGenerateStrategy().getKeyGeneratorName());
        this.defaultShardingColumn = config.getDefaultShardingColumn();
    }

    public ShardingRule(AlgorithmProvidedShardingRuleConfiguration config, Collection<String> dataSourceNames) {
        this.dataSourceNames = this.getDataSourceNames(config.getTables(), config.getAutoTables(), dataSourceNames);
        this.shardingAlgorithms.putAll(config.getShardingAlgorithms());
        this.keyGenerators.putAll(config.getKeyGenerators());
        this.tableRules.putAll(this.createTableRules(config.getTables(), config.getDefaultKeyGenerateStrategy()));
        this.tableRules.putAll(this.createAutoTableRules(config.getAutoTables(), config.getDefaultKeyGenerateStrategy()));
        this.broadcastTables = this.createBroadcastTables(config.getBroadcastTables());
        this.bindingTableRules = this.createBindingTableRules(config.getBindingTableGroups());
        this.defaultDatabaseShardingStrategyConfig = null == config.getDefaultDatabaseShardingStrategy() ? new NoneShardingStrategyConfiguration() : config.getDefaultDatabaseShardingStrategy();
        this.defaultTableShardingStrategyConfig = null == config.getDefaultTableShardingStrategy() ? new NoneShardingStrategyConfiguration() : config.getDefaultTableShardingStrategy();
        this.defaultKeyGenerateAlgorithm = null == config.getDefaultKeyGenerateStrategy() ? (KeyGenerateAlgorithm)RequiredSPIRegistry.getRegisteredService(KeyGenerateAlgorithm.class) : this.keyGenerators.get(config.getDefaultKeyGenerateStrategy().getKeyGeneratorName());
        this.defaultShardingColumn = config.getDefaultShardingColumn();
    }

    private Collection<String> getDataSourceNames(Collection<ShardingTableRuleConfiguration> tableRuleConfigs, Collection<ShardingAutoTableRuleConfiguration> autoTableRuleConfigs, Collection<String> dataSourceNames) {
        if (tableRuleConfigs.isEmpty() && autoTableRuleConfigs.isEmpty()) {
            return dataSourceNames;
        }
        if (tableRuleConfigs.stream().map(ShardingTableRuleConfiguration::getActualDataNodes).anyMatch(each -> null == each || each.isEmpty())) {
            return dataSourceNames;
        }
        LinkedHashSet<String> result = new LinkedHashSet<String>();
        tableRuleConfigs.forEach(each -> result.addAll(this.getDataSourceNames((ShardingTableRuleConfiguration)each)));
        autoTableRuleConfigs.forEach(each -> result.addAll(this.getDataSourceNames((ShardingAutoTableRuleConfiguration)each)));
        return result;
    }

    private Collection<String> getDataSourceNames(ShardingAutoTableRuleConfiguration shardingAutoTableRuleConfig) {
        List actualDataSources = new InlineExpressionParser(shardingAutoTableRuleConfig.getActualDataSources()).splitAndEvaluate();
        return new HashSet<String>(actualDataSources);
    }

    private Collection<String> getDataSourceNames(ShardingTableRuleConfiguration shardingTableRuleConfig) {
        List actualDataNodes = new InlineExpressionParser(shardingTableRuleConfig.getActualDataNodes()).splitAndEvaluate();
        return actualDataNodes.stream().map(each -> new DataNode(each).getDataSourceName()).collect(Collectors.toList());
    }

    private Map<String, TableRule> createTableRules(Collection<ShardingTableRuleConfiguration> tableRuleConfigs, KeyGenerateStrategyConfiguration defaultKeyGenerateStrategyConfig) {
        return tableRuleConfigs.stream().map(each -> new TableRule((ShardingTableRuleConfiguration)each, this.dataSourceNames, this.getDefaultGenerateKeyColumn(defaultKeyGenerateStrategyConfig))).collect(Collectors.toMap(each -> each.getLogicTable().toLowerCase(), Function.identity(), (oldValue, currentValue) -> oldValue, LinkedHashMap::new));
    }

    private Map<String, TableRule> createAutoTableRules(Collection<ShardingAutoTableRuleConfiguration> autoTableRuleConfigs, KeyGenerateStrategyConfiguration defaultKeyGenerateStrategyConfig) {
        return autoTableRuleConfigs.stream().map(each -> this.createAutoTableRule(defaultKeyGenerateStrategyConfig, (ShardingAutoTableRuleConfiguration)each)).collect(Collectors.toMap(each -> each.getLogicTable().toLowerCase(), Function.identity(), (oldValue, currentValue) -> oldValue, LinkedHashMap::new));
    }

    private TableRule createAutoTableRule(KeyGenerateStrategyConfiguration defaultKeyGenerateStrategyConfig, ShardingAutoTableRuleConfiguration autoTableRuleConfig) {
        ShardingAlgorithm shardingAlgorithm = null == autoTableRuleConfig.getShardingStrategy() ? null : this.shardingAlgorithms.get(autoTableRuleConfig.getShardingStrategy().getShardingAlgorithmName());
        Preconditions.checkState((boolean)(shardingAlgorithm instanceof ShardingAutoTableAlgorithm), (Object)"Sharding auto table rule configuration must match sharding auto table algorithm.");
        return new TableRule(autoTableRuleConfig, this.dataSourceNames, (ShardingAutoTableAlgorithm)shardingAlgorithm, this.getDefaultGenerateKeyColumn(defaultKeyGenerateStrategyConfig));
    }

    private String getDefaultGenerateKeyColumn(KeyGenerateStrategyConfiguration defaultKeyGenerateStrategyConfig) {
        return Optional.ofNullable(defaultKeyGenerateStrategyConfig).map(KeyGenerateStrategyConfiguration::getColumn).orElse(null);
    }

    private Collection<String> createBroadcastTables(Collection<String> broadcastTables) {
        TreeSet<String> result = new TreeSet<String>(String.CASE_INSENSITIVE_ORDER);
        result.addAll(broadcastTables);
        return result;
    }

    private Collection<BindingTableRule> createBindingTableRules(Collection<String> bindingTableGroups) {
        return bindingTableGroups.stream().map(this::createBindingTableRule).collect(Collectors.toList());
    }

    private BindingTableRule createBindingTableRule(String bindingTableGroup) {
        Map tableRules = Splitter.on((String)",").trimResults().splitToList((CharSequence)bindingTableGroup).stream().map(this::getTableRule).collect(Collectors.toMap(each -> each.getLogicTable().toLowerCase(), Function.identity(), (oldValue, currentValue) -> oldValue, LinkedHashMap::new));
        BindingTableRule result = new BindingTableRule();
        result.getTableRules().putAll(tableRules);
        return result;
    }

    public Collection<String> getAllTables() {
        HashSet<String> result = new HashSet<String>(this.getTables());
        result.addAll(this.getAllActualTables());
        return result;
    }

    public ShardingStrategyConfiguration getDatabaseShardingStrategyConfiguration(TableRule tableRule) {
        return null == tableRule.getDatabaseShardingStrategyConfig() ? this.defaultDatabaseShardingStrategyConfig : tableRule.getDatabaseShardingStrategyConfig();
    }

    public ShardingStrategyConfiguration getTableShardingStrategyConfiguration(TableRule tableRule) {
        return null == tableRule.getTableShardingStrategyConfig() ? this.defaultTableShardingStrategyConfig : tableRule.getTableShardingStrategyConfig();
    }

    public Optional<TableRule> findTableRule(String logicTableName) {
        return Optional.ofNullable(this.tableRules.get(logicTableName.toLowerCase()));
    }

    public Optional<TableRule> findTableRuleByActualTable(String actualTableName) {
        return this.tableRules.values().stream().filter(each -> each.isExisted(actualTableName)).findFirst();
    }

    public TableRule getTableRule(String logicTableName) {
        Optional<TableRule> tableRule = this.findTableRule(logicTableName);
        if (tableRule.isPresent()) {
            return tableRule.get();
        }
        if (this.isBroadcastTable(logicTableName)) {
            return new TableRule(this.dataSourceNames, logicTableName);
        }
        throw new ShardingSphereConfigurationException("Cannot find table rule with logic table: '%s'", new Object[]{logicTableName});
    }

    public boolean isAllBindingTables(Collection<String> logicTableNames) {
        if (logicTableNames.isEmpty()) {
            return false;
        }
        Optional<BindingTableRule> bindingTableRule = this.findBindingTableRule(logicTableNames);
        if (!bindingTableRule.isPresent()) {
            return false;
        }
        TreeSet<String> result = new TreeSet<String>(String.CASE_INSENSITIVE_ORDER);
        result.addAll(bindingTableRule.get().getAllLogicTables());
        return !result.isEmpty() && result.containsAll(logicTableNames);
    }

    private Optional<BindingTableRule> findBindingTableRule(Collection<String> logicTableNames) {
        return logicTableNames.stream().map(this::findBindingTableRule).filter(Optional::isPresent).findFirst().orElse(Optional.empty());
    }

    public Optional<BindingTableRule> findBindingTableRule(String logicTableName) {
        return this.bindingTableRules.stream().filter(each -> each.hasLogicTable(logicTableName)).findFirst();
    }

    public boolean isAllBroadcastTables(Collection<String> logicTableNames) {
        return !logicTableNames.isEmpty() && this.broadcastTables.containsAll(logicTableNames);
    }

    public boolean isAllShardingTables(Collection<String> logicTableNames) {
        return !logicTableNames.isEmpty() && logicTableNames.stream().allMatch(this::isShardingTable);
    }

    public boolean isShardingTable(String logicTableName) {
        return this.tableRules.containsKey(logicTableName.toLowerCase());
    }

    public boolean isBroadcastTable(String logicTableName) {
        return this.broadcastTables.contains(logicTableName);
    }

    public boolean isAllTablesInSameDataSource(Collection<String> logicTableNames) {
        Collection dataSourceNames = logicTableNames.stream().map(each -> this.tableRules.get(each.toLowerCase())).filter(Objects::nonNull).flatMap(each -> each.getActualDatasourceNames().stream()).collect(Collectors.toSet());
        return 1 == dataSourceNames.size();
    }

    public boolean tableRuleExists(Collection<String> logicTableNames) {
        return logicTableNames.stream().anyMatch(each -> this.isShardingTable((String)each) || this.isBroadcastTable((String)each));
    }

    public boolean isShardingColumn(String columnName, String tableName) {
        return Optional.ofNullable(this.tableRules.get(tableName.toLowerCase())).filter(each -> this.isShardingColumn((TableRule)each, columnName)).isPresent();
    }

    private boolean isShardingColumn(TableRule tableRule, String columnName) {
        return this.isShardingColumn(this.getDatabaseShardingStrategyConfiguration(tableRule), columnName) || this.isShardingColumn(this.getTableShardingStrategyConfiguration(tableRule), columnName);
    }

    private boolean isShardingColumn(ShardingStrategyConfiguration shardingStrategyConfig, String columnName) {
        if (shardingStrategyConfig instanceof StandardShardingStrategyConfiguration) {
            String shardingColumn = null == ((StandardShardingStrategyConfiguration)shardingStrategyConfig).getShardingColumn() ? this.defaultShardingColumn : ((StandardShardingStrategyConfiguration)shardingStrategyConfig).getShardingColumn();
            return shardingColumn.equalsIgnoreCase(columnName);
        }
        if (shardingStrategyConfig instanceof ComplexShardingStrategyConfiguration) {
            List shardingColumns = Splitter.on((String)",").trimResults().splitToList((CharSequence)((ComplexShardingStrategyConfiguration)shardingStrategyConfig).getShardingColumns());
            for (String each : shardingColumns) {
                if (!each.equalsIgnoreCase(columnName)) continue;
                return true;
            }
        }
        return false;
    }

    public boolean isGenerateKeyColumn(String columnName, String tableName) {
        return Optional.ofNullable(this.tableRules.get(tableName.toLowerCase())).filter(each -> this.isGenerateKeyColumn((TableRule)each, columnName)).isPresent();
    }

    private boolean isGenerateKeyColumn(TableRule tableRule, String columnName) {
        Optional<String> generateKeyColumn = tableRule.getGenerateKeyColumn();
        return generateKeyColumn.isPresent() && generateKeyColumn.get().equalsIgnoreCase(columnName);
    }

    public Optional<String> findGenerateKeyColumnName(String logicTableName) {
        return Optional.ofNullable(this.tableRules.get(logicTableName.toLowerCase())).filter(each -> each.getGenerateKeyColumn().isPresent()).flatMap(TableRule::getGenerateKeyColumn);
    }

    public Comparable<?> generateKey(String logicTableName) {
        Optional<TableRule> tableRule = this.findTableRule(logicTableName);
        if (!tableRule.isPresent()) {
            throw new ShardingSphereConfigurationException("Cannot find strategy for generate keys.", new Object[0]);
        }
        KeyGenerateAlgorithm keyGenerator = null != tableRule.get().getKeyGeneratorName() ? this.keyGenerators.get(tableRule.get().getKeyGeneratorName()) : this.defaultKeyGenerateAlgorithm;
        return keyGenerator.generateKey();
    }

    public DataNode getDataNode(String logicTableName) {
        TableRule tableRule = this.getTableRule(logicTableName);
        return tableRule.getActualDataNodes().get(0);
    }

    public Collection<String> getShardingLogicTableNames(Collection<String> logicTableNames) {
        return logicTableNames.stream().filter(this::isShardingTable).collect(Collectors.toCollection(LinkedList::new));
    }

    public Collection<String> getShardingRuleTableNames(Collection<String> logicTableNames) {
        return logicTableNames.stream().filter(each -> this.isShardingTable((String)each) || this.isBroadcastTable((String)each)).collect(Collectors.toCollection(LinkedList::new));
    }

    public Map<String, String> getLogicAndActualTablesFromBindingTable(String dataSourceName, String logicTable, String actualTable, Collection<String> availableLogicBindingTables) {
        LinkedHashMap<String, String> result = new LinkedHashMap<String, String>();
        this.findBindingTableRule(logicTable).ifPresent(bindingTableRule -> result.putAll(bindingTableRule.getLogicAndActualTables(dataSourceName, logicTable, actualTable, availableLogicBindingTables)));
        return result;
    }

    public Map<String, Collection<DataNode>> getAllDataNodes() {
        LinkedHashMap<String, Collection<DataNode>> result = new LinkedHashMap<String, Collection<DataNode>>();
        result.putAll(this.tableRules.values().stream().collect(Collectors.toMap(TableRule::getLogicTable, TableRule::getActualDataNodes, (oldValue, currentValue) -> oldValue, LinkedHashMap::new)));
        return result;
    }

    public Collection<String> getAllActualTables() {
        return this.tableRules.values().stream().flatMap(each -> each.getActualDataNodes().stream().map(DataNode::getTableName)).collect(Collectors.toSet());
    }

    public Optional<String> findFirstActualTable(String logicTable) {
        return this.findTableRule(logicTable).map(tableRule -> tableRule.getActualDataNodes().get(0).getTableName());
    }

    public boolean isNeedAccumulate(Collection<String> tables) {
        return !this.isAllBroadcastTables(tables);
    }

    public Optional<String> findLogicTableByActualTable(String actualTable) {
        return this.findTableRuleByActualTable(actualTable).map(TableRule::getLogicTable);
    }

    public Collection<String> getTables() {
        Collection result = this.tableRules.values().stream().map(TableRule::getLogicTable).collect(Collectors.toSet());
        result.addAll(this.broadcastTables);
        return result;
    }

    public Optional<String> findActualTableByCatalog(String catalog, String logicTable) {
        return this.findTableRule(logicTable).flatMap(tableRule -> this.findActualTableFromActualDataNode(catalog, tableRule.getActualDataNodes()));
    }

    private Optional<String> findActualTableFromActualDataNode(String catalog, List<DataNode> actualDataNodes) {
        return actualDataNodes.stream().filter(each -> each.getDataSourceName().equalsIgnoreCase(catalog)).findFirst().map(DataNode::getTableName);
    }

    public String getType() {
        return ShardingRule.class.getSimpleName();
    }

    @Generated
    public Collection<String> getDataSourceNames() {
        return this.dataSourceNames;
    }

    @Generated
    public Map<String, ShardingAlgorithm> getShardingAlgorithms() {
        return this.shardingAlgorithms;
    }

    @Generated
    public Map<String, KeyGenerateAlgorithm> getKeyGenerators() {
        return this.keyGenerators;
    }

    @Generated
    public Map<String, TableRule> getTableRules() {
        return this.tableRules;
    }

    @Generated
    public Collection<BindingTableRule> getBindingTableRules() {
        return this.bindingTableRules;
    }

    @Generated
    public Collection<String> getBroadcastTables() {
        return this.broadcastTables;
    }

    @Generated
    public ShardingStrategyConfiguration getDefaultDatabaseShardingStrategyConfig() {
        return this.defaultDatabaseShardingStrategyConfig;
    }

    @Generated
    public ShardingStrategyConfiguration getDefaultTableShardingStrategyConfig() {
        return this.defaultTableShardingStrategyConfig;
    }

    @Generated
    public KeyGenerateAlgorithm getDefaultKeyGenerateAlgorithm() {
        return this.defaultKeyGenerateAlgorithm;
    }

    @Generated
    public String getDefaultShardingColumn() {
        return this.defaultShardingColumn;
    }

    static {
        ShardingSphereServiceLoader.register(ShardingAlgorithm.class);
        ShardingSphereServiceLoader.register(KeyGenerateAlgorithm.class);
    }
}

