/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.singletable.rule;

import com.google.common.base.Preconditions;
import java.sql.SQLException;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.TreeMap;
import javax.sql.DataSource;
import lombok.Generated;
import org.apache.shardingsphere.infra.config.exception.ShardingSphereConfigurationException;
import org.apache.shardingsphere.infra.config.properties.ConfigurationProperties;
import org.apache.shardingsphere.infra.config.properties.ConfigurationPropertyKey;
import org.apache.shardingsphere.infra.database.type.DatabaseType;
import org.apache.shardingsphere.infra.metadata.schema.builder.loader.SchemaMetaDataLoader;
import org.apache.shardingsphere.singletable.rule.SingleTableDataNode;

public final class SingleTableDataNodeLoader {
    public static Map<String, SingleTableDataNode> load(DatabaseType databaseType, Map<String, DataSource> dataSourceMap, Collection<String> excludedTables, ConfigurationProperties props) {
        TreeMap<String, SingleTableDataNode> result = new TreeMap<String, SingleTableDataNode>(String.CASE_INSENSITIVE_ORDER);
        boolean checkDuplicateTable = (Boolean)props.getValue((Enum)ConfigurationPropertyKey.CHECK_DUPLICATE_TABLE_ENABLED);
        for (Map.Entry<String, DataSource> entry : dataSourceMap.entrySet()) {
            Map<String, SingleTableDataNode> dataNodeMap = SingleTableDataNodeLoader.load(databaseType, entry.getKey(), entry.getValue(), excludedTables);
            for (String each : dataNodeMap.keySet()) {
                SingleTableDataNode existDataNode = result.putIfAbsent(each, dataNodeMap.get(each));
                if (!checkDuplicateTable) continue;
                Preconditions.checkState((null == existDataNode ? 1 : 0) != 0, (String)"Single table conflict, there are multiple tables `%s` existed.", (Object)each);
            }
        }
        return result;
    }

    private static Map<String, SingleTableDataNode> load(DatabaseType databaseType, String dataSourceName, DataSource dataSource, Collection<String> excludedTables) {
        Collection<String> tables = SingleTableDataNodeLoader.loadAllTableNames(databaseType, dataSource);
        HashMap<String, SingleTableDataNode> result = new HashMap<String, SingleTableDataNode>(tables.size(), 1.0f);
        for (String each : tables) {
            if (excludedTables.contains(each)) continue;
            result.put(each, new SingleTableDataNode(each, dataSourceName));
        }
        return result;
    }

    private static Collection<String> loadAllTableNames(DatabaseType databaseType, DataSource dataSource) {
        try {
            return SchemaMetaDataLoader.loadAllTableNames((DatabaseType)databaseType, (DataSource)dataSource);
        }
        catch (SQLException ex) {
            throw new ShardingSphereConfigurationException("Can not load table: %s", new Object[]{ex.getMessage()});
        }
    }

    @Generated
    private SingleTableDataNodeLoader() {
    }
}

