/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tomcat.util.net.jsse;

import java.security.KeyManagementException;
import java.security.NoSuchAlgorithmException;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import org.apache.juli.logging.Log;
import org.apache.juli.logging.LogFactory;
import org.apache.tomcat.util.compat.JreVendor;
import org.apache.tomcat.util.compat.TLS;
import org.apache.tomcat.util.net.SSLContext;
import org.apache.tomcat.util.net.SSLHostConfigCertificate;
import org.apache.tomcat.util.net.SSLUtilBase;
import org.apache.tomcat.util.net.jsse.JSSESSLContext;
import org.apache.tomcat.util.res.StringManager;

public class JSSEUtil
extends SSLUtilBase {
    private static final Log log;
    private static final StringManager sm;
    private static final Set<String> implementedProtocols;
    private static final Set<String> implementedCiphers;

    public JSSEUtil(SSLHostConfigCertificate certificate) {
        this(certificate, true);
    }

    public JSSEUtil(SSLHostConfigCertificate certificate, boolean warnOnSkip) {
        super(certificate, warnOnSkip);
    }

    @Override
    protected Log getLog() {
        return log;
    }

    @Override
    protected Set<String> getImplementedProtocols() {
        return implementedProtocols;
    }

    @Override
    protected Set<String> getImplementedCiphers() {
        return implementedCiphers;
    }

    @Override
    protected boolean isTls13Available() {
        return TLS.isTlsv13Available();
    }

    @Override
    protected boolean isTls13RenegAuthAvailable() {
        return false;
    }

    @Override
    public SSLContext createSSLContextInternal(List<String> negotiableProtocols) throws NoSuchAlgorithmException {
        return new JSSESSLContext(this.sslHostConfig.getSslProtocol());
    }

    static {
        JSSESSLContext context;
        log = LogFactory.getLog(JSSEUtil.class);
        sm = StringManager.getManager(JSSEUtil.class);
        try {
            context = new JSSESSLContext("TLS");
            context.init(null, null, null);
        }
        catch (KeyManagementException | NoSuchAlgorithmException e) {
            throw new IllegalArgumentException(e);
        }
        String[] implementedProtocolsArray = context.getSupportedSSLParameters().getProtocols();
        implementedProtocols = new HashSet<String>(implementedProtocolsArray.length);
        for (String protocol : implementedProtocolsArray) {
            String protocolUpper = protocol.toUpperCase(Locale.ENGLISH);
            if (!"SSLV2HELLO".equals(protocolUpper) && !"SSLV3".equals(protocolUpper) && protocolUpper.contains("SSL")) {
                log.debug(sm.getString("jsse.excludeProtocol", protocol));
                continue;
            }
            implementedProtocols.add(protocol);
        }
        if (implementedProtocols.size() == 0) {
            log.warn(sm.getString("jsse.noDefaultProtocols"));
        }
        String[] implementedCipherSuiteArray = context.getSupportedSSLParameters().getCipherSuites();
        if (JreVendor.IS_IBM_JVM) {
            implementedCiphers = new HashSet<String>(implementedCipherSuiteArray.length * 2);
            for (String name : implementedCipherSuiteArray) {
                implementedCiphers.add(name);
                if (!name.startsWith("SSL")) continue;
                implementedCiphers.add("TLS" + name.substring(3));
            }
        } else {
            implementedCiphers = new HashSet<String>(implementedCipherSuiteArray.length);
            implementedCiphers.addAll(Arrays.asList(implementedCipherSuiteArray));
        }
    }
}

