/*
 * Decompiled with CFR 0.152.
 */
package org.assertj.core.api;

import java.util.Comparator;
import org.assertj.core.api.AbstractComparableAssert;
import org.assertj.core.api.NumberAssert;
import org.assertj.core.data.Offset;
import org.assertj.core.data.Percentage;
import org.assertj.core.internal.Bytes;
import org.assertj.core.internal.ComparatorBasedComparisonStrategy;
import org.assertj.core.util.VisibleForTesting;

public abstract class AbstractByteAssert<S extends AbstractByteAssert<S>>
extends AbstractComparableAssert<S, Byte>
implements NumberAssert<S, Byte> {
    @VisibleForTesting
    Bytes bytes = Bytes.instance();

    public AbstractByteAssert(Byte actual, Class<?> selfType) {
        super(actual, selfType);
    }

    public S isEqualTo(byte expected) {
        this.bytes.assertEqual(this.info, this.actual, expected);
        return (S)((AbstractByteAssert)this.myself);
    }

    public S isNotEqualTo(byte other) {
        this.bytes.assertNotEqual(this.info, this.actual, other);
        return (S)((AbstractByteAssert)this.myself);
    }

    @Override
    public S isZero() {
        this.bytes.assertIsZero(this.info, (Number)this.actual);
        return (S)((AbstractByteAssert)this.myself);
    }

    @Override
    public S isNotZero() {
        this.bytes.assertIsNotZero(this.info, (Number)this.actual);
        return (S)((AbstractByteAssert)this.myself);
    }

    @Override
    public S isPositive() {
        this.bytes.assertIsPositive(this.info, (Number)this.actual);
        return (S)((AbstractByteAssert)this.myself);
    }

    @Override
    public S isNegative() {
        this.bytes.assertIsNegative(this.info, (Number)this.actual);
        return (S)((AbstractByteAssert)this.myself);
    }

    @Override
    public S isNotNegative() {
        this.bytes.assertIsNotNegative(this.info, (Number)this.actual);
        return (S)((AbstractByteAssert)this.myself);
    }

    @Override
    public S isNotPositive() {
        this.bytes.assertIsNotPositive(this.info, (Number)this.actual);
        return (S)((AbstractByteAssert)this.myself);
    }

    @Override
    public S isLessThan(byte other) {
        this.bytes.assertLessThan(this.info, (Comparable)this.actual, other);
        return (S)((AbstractByteAssert)this.myself);
    }

    @Override
    public S isLessThanOrEqualTo(byte other) {
        this.bytes.assertLessThanOrEqualTo(this.info, (Comparable)this.actual, other);
        return (S)((AbstractByteAssert)this.myself);
    }

    @Override
    public S isGreaterThan(byte other) {
        this.bytes.assertGreaterThan(this.info, (Comparable)this.actual, other);
        return (S)((AbstractByteAssert)this.myself);
    }

    @Override
    public S isGreaterThanOrEqualTo(byte other) {
        this.bytes.assertGreaterThanOrEqualTo(this.info, (Comparable)this.actual, other);
        return (S)((AbstractByteAssert)this.myself);
    }

    @Override
    public S isBetween(Byte start, Byte end) {
        this.bytes.assertIsBetween(this.info, (Number)this.actual, start, end);
        return (S)((AbstractByteAssert)this.myself);
    }

    @Override
    public S isStrictlyBetween(Byte start, Byte end) {
        this.bytes.assertIsStrictlyBetween(this.info, (Number)this.actual, start, end);
        return (S)((AbstractByteAssert)this.myself);
    }

    @Override
    public S isCloseTo(byte expected, Offset<Byte> offset) {
        this.bytes.assertIsCloseTo(this.info, (Number)this.actual, expected, offset);
        return (S)((AbstractByteAssert)this.myself);
    }

    @Override
    public S isNotCloseTo(byte expected, Offset<Byte> offset) {
        this.bytes.assertIsNotCloseTo(this.info, (Number)this.actual, expected, offset);
        return (S)((AbstractByteAssert)this.myself);
    }

    @Override
    public S isCloseTo(Byte expected, Offset<Byte> offset) {
        this.bytes.assertIsCloseTo(this.info, (Number)this.actual, expected, offset);
        return (S)((AbstractByteAssert)this.myself);
    }

    @Override
    public S isNotCloseTo(Byte expected, Offset<Byte> offset) {
        this.bytes.assertIsNotCloseTo(this.info, (Number)this.actual, expected, offset);
        return (S)((AbstractByteAssert)this.myself);
    }

    @Override
    public S isCloseTo(Byte expected, Percentage percentage) {
        this.bytes.assertIsCloseToPercentage(this.info, (Number)this.actual, expected, percentage);
        return (S)((AbstractByteAssert)this.myself);
    }

    @Override
    public S isNotCloseTo(Byte expected, Percentage percentage) {
        this.bytes.assertIsNotCloseToPercentage(this.info, (Number)this.actual, expected, percentage);
        return (S)((AbstractByteAssert)this.myself);
    }

    @Override
    public S isCloseTo(byte expected, Percentage percentage) {
        this.bytes.assertIsCloseToPercentage(this.info, (Number)this.actual, expected, percentage);
        return (S)((AbstractByteAssert)this.myself);
    }

    @Override
    public S isNotCloseTo(byte expected, Percentage percentage) {
        this.bytes.assertIsNotCloseToPercentage(this.info, (Number)this.actual, expected, percentage);
        return (S)((AbstractByteAssert)this.myself);
    }

    @Override
    public S usingComparator(Comparator<? super Byte> customComparator) {
        super.usingComparator(customComparator);
        this.bytes = new Bytes(new ComparatorBasedComparisonStrategy(customComparator));
        return (S)((AbstractByteAssert)this.myself);
    }

    @Override
    public S usingDefaultComparator() {
        super.usingDefaultComparator();
        this.bytes = Bytes.instance();
        return (S)((AbstractByteAssert)this.myself);
    }
}

