/*
 * Decompiled with CFR 0.152.
 */
package org.assertj.core.api;

import java.time.LocalTime;
import java.time.temporal.Temporal;
import java.util.Arrays;
import org.assertj.core.api.AbstractTemporalAssert;
import org.assertj.core.api.AssertionInfo;
import org.assertj.core.error.ShouldBeAfter;
import org.assertj.core.error.ShouldBeAfterOrEqualsTo;
import org.assertj.core.error.ShouldBeBefore;
import org.assertj.core.error.ShouldBeBeforeOrEqualsTo;
import org.assertj.core.error.ShouldBeEqualIgnoringNanos;
import org.assertj.core.error.ShouldBeEqualIgnoringSeconds;
import org.assertj.core.error.ShouldHaveSameHourAs;
import org.assertj.core.internal.Failures;
import org.assertj.core.internal.Objects;
import org.assertj.core.util.Preconditions;

public abstract class AbstractLocalTimeAssert<SELF extends AbstractLocalTimeAssert<SELF>>
extends AbstractTemporalAssert<SELF, LocalTime> {
    public static final String NULL_LOCAL_TIME_PARAMETER_MESSAGE = "The LocalTime to compare actual with should not be null";

    protected AbstractLocalTimeAssert(LocalTime actual, Class<?> selfType) {
        super(actual, selfType);
    }

    public SELF isBefore(LocalTime other) {
        Objects.instance().assertNotNull(this.info, this.actual);
        AbstractLocalTimeAssert.assertLocalTimeParameterIsNotNull(other);
        if (!((LocalTime)this.actual).isBefore(other)) {
            throw Failures.instance().failure((AssertionInfo)this.info, ShouldBeBefore.shouldBeBefore(this.actual, other));
        }
        return (SELF)((AbstractLocalTimeAssert)this.myself);
    }

    public SELF isBefore(String localTimeAsString) {
        AbstractLocalTimeAssert.assertLocalTimeAsStringParameterIsNotNull(localTimeAsString);
        return this.isBefore(this.parse(localTimeAsString));
    }

    public SELF isBeforeOrEqualTo(LocalTime other) {
        Objects.instance().assertNotNull(this.info, this.actual);
        AbstractLocalTimeAssert.assertLocalTimeParameterIsNotNull(other);
        if (((LocalTime)this.actual).isAfter(other)) {
            throw Failures.instance().failure((AssertionInfo)this.info, ShouldBeBeforeOrEqualsTo.shouldBeBeforeOrEqualsTo(this.actual, other));
        }
        return (SELF)((AbstractLocalTimeAssert)this.myself);
    }

    public SELF isBeforeOrEqualTo(String localTimeAsString) {
        AbstractLocalTimeAssert.assertLocalTimeAsStringParameterIsNotNull(localTimeAsString);
        return this.isBeforeOrEqualTo(this.parse(localTimeAsString));
    }

    public SELF isAfterOrEqualTo(LocalTime other) {
        Objects.instance().assertNotNull(this.info, this.actual);
        AbstractLocalTimeAssert.assertLocalTimeParameterIsNotNull(other);
        if (((LocalTime)this.actual).isBefore(other)) {
            throw Failures.instance().failure((AssertionInfo)this.info, ShouldBeAfterOrEqualsTo.shouldBeAfterOrEqualsTo(this.actual, other));
        }
        return (SELF)((AbstractLocalTimeAssert)this.myself);
    }

    public SELF isAfterOrEqualTo(String localTimeAsString) {
        AbstractLocalTimeAssert.assertLocalTimeAsStringParameterIsNotNull(localTimeAsString);
        return this.isAfterOrEqualTo(this.parse(localTimeAsString));
    }

    public SELF isAfter(LocalTime other) {
        Objects.instance().assertNotNull(this.info, this.actual);
        AbstractLocalTimeAssert.assertLocalTimeParameterIsNotNull(other);
        if (!((LocalTime)this.actual).isAfter(other)) {
            throw Failures.instance().failure((AssertionInfo)this.info, ShouldBeAfter.shouldBeAfter(this.actual, other));
        }
        return (SELF)((AbstractLocalTimeAssert)this.myself);
    }

    public SELF isAfter(String localTimeAsString) {
        AbstractLocalTimeAssert.assertLocalTimeAsStringParameterIsNotNull(localTimeAsString);
        return this.isAfter(this.parse(localTimeAsString));
    }

    public SELF isEqualTo(String localTimeAsString) {
        AbstractLocalTimeAssert.assertLocalTimeAsStringParameterIsNotNull(localTimeAsString);
        return (SELF)((AbstractLocalTimeAssert)this.isEqualTo(this.parse(localTimeAsString)));
    }

    public SELF isNotEqualTo(String localTimeAsString) {
        AbstractLocalTimeAssert.assertLocalTimeAsStringParameterIsNotNull(localTimeAsString);
        return (SELF)((AbstractLocalTimeAssert)this.isNotEqualTo(this.parse(localTimeAsString)));
    }

    public SELF isIn(String ... localTimesAsString) {
        this.checkIsNotNullAndNotEmpty(localTimesAsString);
        return (SELF)((AbstractLocalTimeAssert)this.isIn(AbstractLocalTimeAssert.convertToLocalTimeArray(localTimesAsString)));
    }

    public SELF isNotIn(String ... localTimesAsString) {
        this.checkIsNotNullAndNotEmpty(localTimesAsString);
        return (SELF)((AbstractLocalTimeAssert)this.isNotIn(AbstractLocalTimeAssert.convertToLocalTimeArray(localTimesAsString)));
    }

    private static Object[] convertToLocalTimeArray(String ... localTimesAsString) {
        return Arrays.stream(localTimesAsString).map(LocalTime::parse).toArray();
    }

    private void checkIsNotNullAndNotEmpty(Object[] values) {
        Preconditions.checkArgument(values != null, "The given LocalTime array should not be null", new Object[0]);
        Preconditions.checkArgument(values.length > 0, "The given LocalTime array should not be empty", new Object[0]);
    }

    private static void assertLocalTimeAsStringParameterIsNotNull(String localTimeAsString) {
        Preconditions.checkArgument(localTimeAsString != null, "The String representing the LocalTime to compare actual with should not be null", new Object[0]);
    }

    private static void assertLocalTimeParameterIsNotNull(LocalTime other) {
        Preconditions.checkArgument(other != null, NULL_LOCAL_TIME_PARAMETER_MESSAGE, new Object[0]);
    }

    public SELF isEqualToIgnoringNanos(LocalTime other) {
        Objects.instance().assertNotNull(this.info, this.actual);
        AbstractLocalTimeAssert.assertLocalTimeParameterIsNotNull(other);
        if (!AbstractLocalTimeAssert.areEqualIgnoringNanos((LocalTime)this.actual, other)) {
            throw Failures.instance().failure((AssertionInfo)this.info, ShouldBeEqualIgnoringNanos.shouldBeEqualIgnoringNanos((LocalTime)this.actual, other));
        }
        return (SELF)((AbstractLocalTimeAssert)this.myself);
    }

    public SELF isEqualToIgnoringSeconds(LocalTime other) {
        Objects.instance().assertNotNull(this.info, this.actual);
        AbstractLocalTimeAssert.assertLocalTimeParameterIsNotNull(other);
        if (!AbstractLocalTimeAssert.areEqualIgnoringSeconds((LocalTime)this.actual, other)) {
            throw Failures.instance().failure((AssertionInfo)this.info, ShouldBeEqualIgnoringSeconds.shouldBeEqualIgnoringSeconds((LocalTime)this.actual, other));
        }
        return (SELF)((AbstractLocalTimeAssert)this.myself);
    }

    public SELF hasSameHourAs(LocalTime other) {
        Objects.instance().assertNotNull(this.info, this.actual);
        AbstractLocalTimeAssert.assertLocalTimeParameterIsNotNull(other);
        if (!AbstractLocalTimeAssert.haveSameHourField((LocalTime)this.actual, other)) {
            throw Failures.instance().failure((AssertionInfo)this.info, ShouldHaveSameHourAs.shouldHaveSameHourAs((Temporal)this.actual, other));
        }
        return (SELF)((AbstractLocalTimeAssert)this.myself);
    }

    public SELF isBetween(LocalTime startInclusive, LocalTime endInclusive) {
        this.comparables.assertIsBetween(this.info, (Comparable)this.actual, startInclusive, endInclusive, true, true);
        return (SELF)((AbstractLocalTimeAssert)this.myself);
    }

    public SELF isBetween(String startInclusive, String endInclusive) {
        return this.isBetween(this.parse(startInclusive), this.parse(endInclusive));
    }

    public SELF isStrictlyBetween(LocalTime startExclusive, LocalTime endExclusive) {
        this.comparables.assertIsBetween(this.info, (Comparable)this.actual, startExclusive, endExclusive, false, false);
        return (SELF)((AbstractLocalTimeAssert)this.myself);
    }

    public SELF isStrictlyBetween(String startExclusive, String endExclusive) {
        return this.isStrictlyBetween(this.parse(startExclusive), this.parse(endExclusive));
    }

    @Override
    protected LocalTime parse(String localTimeAsString) {
        return LocalTime.parse(localTimeAsString);
    }

    private static boolean areEqualIgnoringNanos(LocalTime actual, LocalTime other) {
        return AbstractLocalTimeAssert.areEqualIgnoringSeconds(actual, other) && actual.getSecond() == other.getSecond();
    }

    private static boolean areEqualIgnoringSeconds(LocalTime actual, LocalTime other) {
        return AbstractLocalTimeAssert.haveSameHourField(actual, other) && actual.getMinute() == other.getMinute();
    }

    private static boolean haveSameHourField(LocalTime actual, LocalTime other) {
        return actual.getHour() == other.getHour();
    }
}

