/*
 * Decompiled with CFR 0.152.
 */
package org.assertj.core.error;

import java.lang.reflect.Modifier;
import java.util.StringJoiner;
import org.assertj.core.error.BasicErrorMessageFactory;
import org.assertj.core.error.ErrorMessageFactory;

public class ClassModifierShouldBe
extends BasicErrorMessageFactory {
    private static final String PACKAGE_PRIVATE = "package-private";

    private ClassModifierShouldBe(Class<?> actual, boolean positive, String modifier) {
        super("%nExpecting:%n  %s%n" + (positive ? "to" : "not to") + " be a %s class but was %s.", actual, modifier, ClassModifierShouldBe.modifiers(actual));
    }

    public static ErrorMessageFactory shouldBeFinal(Class<?> actual) {
        return new ClassModifierShouldBe(actual, true, Modifier.toString(16));
    }

    public static ErrorMessageFactory shouldNotBeFinal(Class<?> actual) {
        return new ClassModifierShouldBe(actual, false, Modifier.toString(16));
    }

    public static ErrorMessageFactory shouldBePublic(Class<?> actual) {
        return new ClassModifierShouldBe(actual, true, Modifier.toString(1));
    }

    public static ErrorMessageFactory shouldBeProtected(Class<?> actual) {
        return new ClassModifierShouldBe(actual, true, Modifier.toString(4));
    }

    public static ErrorMessageFactory shouldBePackagePrivate(Class<?> actual) {
        return new ClassModifierShouldBe(actual, true, PACKAGE_PRIVATE);
    }

    private static String modifiers(Class<?> actual) {
        int modifiers = actual.getModifiers();
        boolean isPackagePrivate = !Modifier.isPublic(modifiers) && !Modifier.isProtected(modifiers) && !Modifier.isPrivate(modifiers);
        String modifiersDescription = Modifier.toString(modifiers);
        StringJoiner sj = new StringJoiner(" ");
        if (isPackagePrivate) {
            sj.add(PACKAGE_PRIVATE);
        }
        if (!modifiersDescription.isEmpty()) {
            sj.add(modifiersDescription);
        }
        return sj.toString();
    }
}

