/*
 * Decompiled with CFR 0.152.
 */
package org.assertj.core.internal.bytebuddy.dynamic.scaffold.subclass;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.assertj.core.internal.bytebuddy.description.method.MethodDescription;
import org.assertj.core.internal.bytebuddy.description.method.MethodList;
import org.assertj.core.internal.bytebuddy.description.type.TypeDescription;
import org.assertj.core.internal.bytebuddy.dynamic.Transformer;
import org.assertj.core.internal.bytebuddy.dynamic.scaffold.MethodRegistry;
import org.assertj.core.internal.bytebuddy.implementation.SuperMethodCall;
import org.assertj.core.internal.bytebuddy.implementation.attribute.MethodAttributeAppender;
import org.assertj.core.internal.bytebuddy.matcher.ElementMatchers;
import org.assertj.core.internal.bytebuddy.matcher.LatentMatcher;

public interface ConstructorStrategy {
    public List<MethodDescription.Token> extractConstructors(TypeDescription var1);

    public MethodRegistry inject(MethodRegistry var1);

    public static enum Default implements ConstructorStrategy
    {
        NO_CONSTRUCTORS{

            @Override
            protected List<MethodDescription.Token> doExtractConstructors(TypeDescription superClass) {
                return Collections.emptyList();
            }

            @Override
            protected MethodRegistry doInject(MethodRegistry methodRegistry, MethodAttributeAppender.Factory methodAttributeAppenderFactory) {
                return methodRegistry;
            }
        }
        ,
        DEFAULT_CONSTRUCTOR{

            @Override
            protected List<MethodDescription.Token> doExtractConstructors(TypeDescription instrumentedType) {
                MethodList.Empty defaultConstructors;
                TypeDescription.Generic superClass = instrumentedType.getSuperClass();
                MethodList methodList = defaultConstructors = superClass == null ? new MethodList.Empty() : (MethodList)superClass.getDeclaredMethods().filter(ElementMatchers.isConstructor().and(ElementMatchers.takesArguments(0)).and(ElementMatchers.isVisibleTo(instrumentedType)));
                if (defaultConstructors.size() == 1) {
                    return Collections.singletonList(new MethodDescription.Token(1));
                }
                throw new IllegalArgumentException(instrumentedType.getSuperClass() + " declares no constructor that is visible to " + instrumentedType);
            }

            @Override
            protected MethodRegistry doInject(MethodRegistry methodRegistry, MethodAttributeAppender.Factory methodAttributeAppenderFactory) {
                return methodRegistry.append(new LatentMatcher.Resolved(ElementMatchers.isConstructor()), new MethodRegistry.Handler.ForImplementation(SuperMethodCall.INSTANCE), methodAttributeAppenderFactory, Transformer.NoOp.<MethodDescription>make());
            }
        }
        ,
        IMITATE_SUPER_CLASS{

            @Override
            protected List<MethodDescription.Token> doExtractConstructors(TypeDescription instrumentedType) {
                TypeDescription.Generic superClass = instrumentedType.getSuperClass();
                return (superClass == null ? new MethodList.Empty() : (MethodList)superClass.getDeclaredMethods().filter(ElementMatchers.isConstructor().and(ElementMatchers.isVisibleTo(instrumentedType)))).asTokenList(ElementMatchers.is(instrumentedType));
            }

            @Override
            public MethodRegistry doInject(MethodRegistry methodRegistry, MethodAttributeAppender.Factory methodAttributeAppenderFactory) {
                return methodRegistry.append(new LatentMatcher.Resolved(ElementMatchers.isConstructor()), new MethodRegistry.Handler.ForImplementation(SuperMethodCall.INSTANCE), methodAttributeAppenderFactory, Transformer.NoOp.<MethodDescription>make());
            }
        }
        ,
        IMITATE_SUPER_CLASS_PUBLIC{

            @Override
            protected List<MethodDescription.Token> doExtractConstructors(TypeDescription instrumentedType) {
                TypeDescription.Generic superClass = instrumentedType.getSuperClass();
                return (superClass == null ? new MethodList.Empty() : (MethodList)superClass.getDeclaredMethods().filter(ElementMatchers.isPublic().and(ElementMatchers.isConstructor()))).asTokenList(ElementMatchers.is(instrumentedType));
            }

            @Override
            public MethodRegistry doInject(MethodRegistry methodRegistry, MethodAttributeAppender.Factory methodAttributeAppenderFactory) {
                return methodRegistry.append(new LatentMatcher.Resolved(ElementMatchers.isConstructor()), new MethodRegistry.Handler.ForImplementation(SuperMethodCall.INSTANCE), methodAttributeAppenderFactory, Transformer.NoOp.<MethodDescription>make());
            }
        }
        ,
        IMITATE_SUPER_CLASS_OPENING{

            @Override
            protected List<MethodDescription.Token> doExtractConstructors(TypeDescription instrumentedType) {
                TypeDescription.Generic superClass = instrumentedType.getSuperClass();
                return (superClass == null ? new MethodList.Empty() : (MethodList)superClass.getDeclaredMethods().filter(ElementMatchers.isConstructor().and(ElementMatchers.isVisibleTo(instrumentedType)))).asTokenList(ElementMatchers.is(instrumentedType));
            }

            @Override
            public MethodRegistry doInject(MethodRegistry methodRegistry, MethodAttributeAppender.Factory methodAttributeAppenderFactory) {
                return methodRegistry.append(new LatentMatcher.Resolved(ElementMatchers.isConstructor()), new MethodRegistry.Handler.ForImplementation(SuperMethodCall.INSTANCE), methodAttributeAppenderFactory, Transformer.NoOp.<MethodDescription>make());
            }

            @Override
            protected int resolveModifier(int modifiers) {
                return 1;
            }
        };


        @Override
        public List<MethodDescription.Token> extractConstructors(TypeDescription instrumentedType) {
            List<MethodDescription.Token> tokens = this.doExtractConstructors(instrumentedType);
            ArrayList<MethodDescription.Token> stripped = new ArrayList<MethodDescription.Token>(tokens.size());
            for (MethodDescription.Token token : tokens) {
                stripped.add(new MethodDescription.Token(token.getName(), this.resolveModifier(token.getModifiers()), token.getTypeVariableTokens(), token.getReturnType(), token.getParameterTokens(), token.getExceptionTypes(), token.getAnnotations(), token.getDefaultValue(), TypeDescription.Generic.UNDEFINED));
            }
            return stripped;
        }

        protected int resolveModifier(int modifiers) {
            return modifiers;
        }

        protected abstract List<MethodDescription.Token> doExtractConstructors(TypeDescription var1);

        @Override
        public MethodRegistry inject(MethodRegistry methodRegistry) {
            return this.doInject(methodRegistry, MethodAttributeAppender.NoOp.INSTANCE);
        }

        protected abstract MethodRegistry doInject(MethodRegistry var1, MethodAttributeAppender.Factory var2);

        public ConstructorStrategy with(MethodAttributeAppender.Factory methodAttributeAppenderFactory) {
            return new WithMethodAttributeAppenderFactory(this, methodAttributeAppenderFactory);
        }

        public ConstructorStrategy withInheritedAnnotations() {
            return new WithMethodAttributeAppenderFactory(this, MethodAttributeAppender.ForInstrumentedMethod.EXCLUDING_RECEIVER);
        }

        protected static class WithMethodAttributeAppenderFactory
        implements ConstructorStrategy {
            private final Default delegate;
            private final MethodAttributeAppender.Factory methodAttributeAppenderFactory;

            protected WithMethodAttributeAppenderFactory(Default delegate, MethodAttributeAppender.Factory methodAttributeAppenderFactory) {
                this.delegate = delegate;
                this.methodAttributeAppenderFactory = methodAttributeAppenderFactory;
            }

            @Override
            public List<MethodDescription.Token> extractConstructors(TypeDescription instrumentedType) {
                return this.delegate.extractConstructors(instrumentedType);
            }

            @Override
            public MethodRegistry inject(MethodRegistry methodRegistry) {
                return this.delegate.doInject(methodRegistry, this.methodAttributeAppenderFactory);
            }

            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof WithMethodAttributeAppenderFactory)) {
                    return false;
                }
                WithMethodAttributeAppenderFactory other = (WithMethodAttributeAppenderFactory)o;
                if (!other.canEqual(this)) {
                    return false;
                }
                Default this$delegate = this.delegate;
                Default other$delegate = other.delegate;
                if (this$delegate == null ? other$delegate != null : !this$delegate.equals(other$delegate)) {
                    return false;
                }
                MethodAttributeAppender.Factory this$methodAttributeAppenderFactory = this.methodAttributeAppenderFactory;
                MethodAttributeAppender.Factory other$methodAttributeAppenderFactory = other.methodAttributeAppenderFactory;
                return !(this$methodAttributeAppenderFactory == null ? other$methodAttributeAppenderFactory != null : !this$methodAttributeAppenderFactory.equals(other$methodAttributeAppenderFactory));
            }

            protected boolean canEqual(Object other) {
                return other instanceof WithMethodAttributeAppenderFactory;
            }

            public int hashCode() {
                int PRIME = 59;
                int result = 1;
                Default $delegate = this.delegate;
                result = result * 59 + ($delegate == null ? 43 : $delegate.hashCode());
                MethodAttributeAppender.Factory $methodAttributeAppenderFactory = this.methodAttributeAppenderFactory;
                result = result * 59 + ($methodAttributeAppenderFactory == null ? 43 : $methodAttributeAppenderFactory.hashCode());
                return result;
            }
        }
    }
}

