/*
 * Decompiled with CFR 0.152.
 */
package org.assertj.core.internal.bytebuddy.dynamic.scaffold.subclass;

import org.assertj.core.internal.bytebuddy.ClassFileVersion;
import org.assertj.core.internal.bytebuddy.asm.AsmVisitorWrapper;
import org.assertj.core.internal.bytebuddy.description.method.MethodDescription;
import org.assertj.core.internal.bytebuddy.description.type.TypeDescription;
import org.assertj.core.internal.bytebuddy.dynamic.DynamicType;
import org.assertj.core.internal.bytebuddy.dynamic.TypeResolutionStrategy;
import org.assertj.core.internal.bytebuddy.dynamic.scaffold.FieldRegistry;
import org.assertj.core.internal.bytebuddy.dynamic.scaffold.InstrumentedType;
import org.assertj.core.internal.bytebuddy.dynamic.scaffold.MethodGraph;
import org.assertj.core.internal.bytebuddy.dynamic.scaffold.MethodRegistry;
import org.assertj.core.internal.bytebuddy.dynamic.scaffold.TypeValidation;
import org.assertj.core.internal.bytebuddy.dynamic.scaffold.TypeWriter;
import org.assertj.core.internal.bytebuddy.dynamic.scaffold.subclass.ConstructorStrategy;
import org.assertj.core.internal.bytebuddy.dynamic.scaffold.subclass.SubclassImplementationTarget;
import org.assertj.core.internal.bytebuddy.implementation.Implementation;
import org.assertj.core.internal.bytebuddy.implementation.attribute.AnnotationRetention;
import org.assertj.core.internal.bytebuddy.implementation.attribute.AnnotationValueFilter;
import org.assertj.core.internal.bytebuddy.implementation.attribute.TypeAttributeAppender;
import org.assertj.core.internal.bytebuddy.implementation.auxiliary.AuxiliaryType;
import org.assertj.core.internal.bytebuddy.matcher.ElementMatcher;
import org.assertj.core.internal.bytebuddy.matcher.ElementMatchers;
import org.assertj.core.internal.bytebuddy.matcher.LatentMatcher;
import org.assertj.core.internal.bytebuddy.pool.TypePool;

public class SubclassDynamicTypeBuilder<T>
extends DynamicType.Builder.AbstractBase.Adapter<T> {
    private final ConstructorStrategy constructorStrategy;

    public SubclassDynamicTypeBuilder(InstrumentedType.WithFlexibleName instrumentedType, ClassFileVersion classFileVersion, AuxiliaryType.NamingStrategy auxiliaryTypeNamingStrategy, AnnotationValueFilter.Factory annotationValueFilterFactory, AnnotationRetention annotationRetention, Implementation.Context.Factory implementationContextFactory, MethodGraph.Compiler methodGraphCompiler, TypeValidation typeValidation, LatentMatcher<? super MethodDescription> ignoredMethods, ConstructorStrategy constructorStrategy) {
        this(instrumentedType, new FieldRegistry.Default(), new MethodRegistry.Default(), TypeAttributeAppender.ForInstrumentedType.INSTANCE, AsmVisitorWrapper.NoOp.INSTANCE, classFileVersion, auxiliaryTypeNamingStrategy, annotationValueFilterFactory, annotationRetention, implementationContextFactory, methodGraphCompiler, typeValidation, ignoredMethods, constructorStrategy);
    }

    protected SubclassDynamicTypeBuilder(InstrumentedType.WithFlexibleName instrumentedType, FieldRegistry fieldRegistry, MethodRegistry methodRegistry, TypeAttributeAppender typeAttributeAppender, AsmVisitorWrapper asmVisitorWrapper, ClassFileVersion classFileVersion, AuxiliaryType.NamingStrategy auxiliaryTypeNamingStrategy, AnnotationValueFilter.Factory annotationValueFilterFactory, AnnotationRetention annotationRetention, Implementation.Context.Factory implementationContextFactory, MethodGraph.Compiler methodGraphCompiler, TypeValidation typeValidation, LatentMatcher<? super MethodDescription> ignoredMethods, ConstructorStrategy constructorStrategy) {
        super(instrumentedType, fieldRegistry, methodRegistry, typeAttributeAppender, asmVisitorWrapper, classFileVersion, auxiliaryTypeNamingStrategy, annotationValueFilterFactory, annotationRetention, implementationContextFactory, methodGraphCompiler, typeValidation, ignoredMethods);
        this.constructorStrategy = constructorStrategy;
    }

    @Override
    protected DynamicType.Builder<T> materialize(InstrumentedType.WithFlexibleName instrumentedType, FieldRegistry fieldRegistry, MethodRegistry methodRegistry, TypeAttributeAppender typeAttributeAppender, AsmVisitorWrapper asmVisitorWrapper, ClassFileVersion classFileVersion, AuxiliaryType.NamingStrategy auxiliaryTypeNamingStrategy, AnnotationValueFilter.Factory annotationValueFilterFactory, AnnotationRetention annotationRetention, Implementation.Context.Factory implementationContextFactory, MethodGraph.Compiler methodGraphCompiler, TypeValidation typeValidation, LatentMatcher<? super MethodDescription> ignoredMethods) {
        return new SubclassDynamicTypeBuilder<T>(instrumentedType, fieldRegistry, methodRegistry, typeAttributeAppender, asmVisitorWrapper, classFileVersion, auxiliaryTypeNamingStrategy, annotationValueFilterFactory, annotationRetention, implementationContextFactory, methodGraphCompiler, typeValidation, ignoredMethods, this.constructorStrategy);
    }

    @Override
    public DynamicType.Unloaded<T> make(TypeResolutionStrategy typeResolutionStrategy) {
        return this.make(typeResolutionStrategy, TypePool.ClassLoading.ofClassPath());
    }

    @Override
    public DynamicType.Unloaded<T> make(TypeResolutionStrategy typeResolutionStrategy, TypePool typePool) {
        MethodRegistry.Compiled methodRegistry = this.constructorStrategy.inject(this.methodRegistry).prepare(this.applyConstructorStrategy(this.instrumentedType), this.methodGraphCompiler, this.typeValidation, new InstrumentableMatcher(this.ignoredMethods)).compile(SubclassImplementationTarget.Factory.SUPER_CLASS, this.classFileVersion);
        return TypeWriter.Default.forCreation(methodRegistry, this.fieldRegistry.compile(methodRegistry.getInstrumentedType()), this.typeAttributeAppender, this.asmVisitorWrapper, this.classFileVersion, this.annotationValueFilterFactory, this.annotationRetention, this.auxiliaryTypeNamingStrategy, this.implementationContextFactory, this.typeValidation, typePool).make(typeResolutionStrategy.resolve());
    }

    private InstrumentedType applyConstructorStrategy(InstrumentedType instrumentedType) {
        if (!instrumentedType.isInterface()) {
            for (MethodDescription.Token token : this.constructorStrategy.extractConstructors(instrumentedType)) {
                instrumentedType = instrumentedType.withMethod(token);
            }
        }
        return instrumentedType;
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof SubclassDynamicTypeBuilder)) {
            return false;
        }
        SubclassDynamicTypeBuilder other = (SubclassDynamicTypeBuilder)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        ConstructorStrategy this$constructorStrategy = this.constructorStrategy;
        ConstructorStrategy other$constructorStrategy = other.constructorStrategy;
        return !(this$constructorStrategy == null ? other$constructorStrategy != null : !this$constructorStrategy.equals(other$constructorStrategy));
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof SubclassDynamicTypeBuilder;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + super.hashCode();
        ConstructorStrategy $constructorStrategy = this.constructorStrategy;
        result = result * 59 + ($constructorStrategy == null ? 43 : $constructorStrategy.hashCode());
        return result;
    }

    protected static class InstrumentableMatcher
    implements LatentMatcher<MethodDescription> {
        private final LatentMatcher<? super MethodDescription> ignoredMethods;

        protected InstrumentableMatcher(LatentMatcher<? super MethodDescription> ignoredMethods) {
            this.ignoredMethods = ignoredMethods;
        }

        @Override
        public ElementMatcher<? super MethodDescription> resolve(TypeDescription typeDescription) {
            return ElementMatchers.isVirtual().and(ElementMatchers.not(ElementMatchers.isFinal())).and(ElementMatchers.isVisibleTo(typeDescription)).and(ElementMatchers.not(this.ignoredMethods.resolve(typeDescription))).or(ElementMatchers.isDeclaredBy(typeDescription));
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof InstrumentableMatcher)) {
                return false;
            }
            InstrumentableMatcher other = (InstrumentableMatcher)o;
            if (!other.canEqual(this)) {
                return false;
            }
            LatentMatcher<? super MethodDescription> this$ignoredMethods = this.ignoredMethods;
            LatentMatcher<? super MethodDescription> other$ignoredMethods = other.ignoredMethods;
            return !(this$ignoredMethods == null ? other$ignoredMethods != null : !this$ignoredMethods.equals(other$ignoredMethods));
        }

        protected boolean canEqual(Object other) {
            return other instanceof InstrumentableMatcher;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            LatentMatcher<? super MethodDescription> $ignoredMethods = this.ignoredMethods;
            result = result * 59 + ($ignoredMethods == null ? 43 : $ignoredMethods.hashCode());
            return result;
        }
    }
}

