// Targeted by JavaCPP version 1.4.1: DO NOT EDIT THIS FILE

package org.bytedeco.javacpp;

import java.nio.*;
import org.bytedeco.javacpp.*;
import org.bytedeco.javacpp.annotation.*;

public class freenect2 extends org.bytedeco.javacpp.presets.freenect2 {
    static { Loader.load(); }

@Name("std::map<libfreenect2::Frame::Type,libfreenect2::Frame*>") public static class FrameMap extends Pointer {
    static { Loader.load(); }
    /** Pointer cast constructor. Invokes {@link Pointer#Pointer(Pointer)}. */
    public FrameMap(Pointer p) { super(p); }
    public FrameMap()       { allocate();  }
    private native void allocate();
    public native @Name("operator=") @ByRef FrameMap put(@ByRef FrameMap x);

    public boolean empty() { return size() == 0; }
    public native long size();

    @Index(function = "at") public native Frame get(@Cast("libfreenect2::Frame::Type") int i);
    public native FrameMap put(@Cast("libfreenect2::Frame::Type") int i, Frame value);

    public native @ByVal Iterator begin();
    public native @ByVal Iterator end();
    @NoOffset @Name("iterator") public static class Iterator extends Pointer {
        public Iterator(Pointer p) { super(p); }
        public Iterator() { }

        public native @Name("operator++") @ByRef Iterator increment();
        public native @Name("operator==") boolean equals(@ByRef Iterator it);
        public native @Name("operator*().first") @MemberGetter @Cast("libfreenect2::Frame::Type") int first();
        public native @Name("operator*().second") @MemberGetter @Const Frame second();
    }
}

// Parsed from <libfreenect2/libfreenect2.hpp>

/*
 * This file is part of the OpenKinect Project. http://www.openkinect.org
 *
 * Copyright (c) 2014 individual OpenKinect contributors. See the CONTRIB file
 * for details.
 *
 * This code is licensed to you under the terms of the Apache License, version
 * 2.0, or, at your option, the terms of the GNU General Public License,
 * version 2.0. See the APACHE20 and GPL2 files for the text of the licenses,
 * or the following URLs:
 * http://www.apache.org/licenses/LICENSE-2.0
 * http://www.gnu.org/licenses/gpl-2.0.txt
 *
 * If you redistribute this file in source form, modified or unmodified, you
 * may:
 *   1) Leave this header intact and distribute it under the same terms,
 *      accompanying it with the APACHE20 and GPL20 files, or
 *   2) Delete the Apache 2.0 clause and accompany it with the GPL2 file, or
 *   3) Delete the GPL v2 clause and accompany it with the APACHE20 file
 * In all cases you must keep the copyright notice intact and include a copy
 * of the CONTRIB file.
 *
 * Binary distributions must follow the binary distribution requirements of
 * either License.
 */

/** \file libfreenect2.hpp Header file of the Freenect2 library. */

// #ifndef LIBFREENECT2_HPP_
// #define LIBFREENECT2_HPP_

// #include <libfreenect2/config.h>
// #include <libfreenect2/frame_listener.hpp>
// #include <libfreenect2/packet_pipeline.h>
// #include <string>

/** \defgroup device Initialization and Device Control
 * Find, open, and control Kinect v2 devices. */
/**\{
<p>
/** Device control. */
@Namespace("libfreenect2") public static class Freenect2Device extends Pointer {
    static { Loader.load(); }
    /** Pointer cast constructor. Invokes {@link Pointer#Pointer(Pointer)}. */
    public Freenect2Device(Pointer p) { super(p); }

  @MemberGetter public static native @Cast("const unsigned int") int VendorId();
  public static final int VendorId = VendorId();
  @MemberGetter public static native @Cast("const unsigned int") int ProductId();
  public static final int ProductId = ProductId();
  @MemberGetter public static native @Cast("const unsigned int") int ProductIdPreview();
  public static final int ProductIdPreview = ProductIdPreview();

  /** Color camera calibration parameters.
   * Kinect v2 includes factory preset values for these parameters. They are used in Registration.
   */
  public static class ColorCameraParams extends Pointer {
      static { Loader.load(); }
      /** Default native constructor. */
      public ColorCameraParams() { super((Pointer)null); allocate(); }
      /** Native array allocator. Access with {@link Pointer#position(long)}. */
      public ColorCameraParams(long size) { super((Pointer)null); allocateArray(size); }
      /** Pointer cast constructor. Invokes {@link Pointer#Pointer(Pointer)}. */
      public ColorCameraParams(Pointer p) { super(p); }
      private native void allocate();
      private native void allocateArray(long size);
      @Override public ColorCameraParams position(long position) {
          return (ColorCameraParams)super.position(position);
      }
  
    /** \name Intrinsic parameters */
    /**\{ */
    /** Focal length x (pixel) */
    public native float fx(); public native ColorCameraParams fx(float fx);
    /** Focal length y (pixel) */
    public native float fy(); public native ColorCameraParams fy(float fy);
    /** Principal point x (pixel) */
    public native float cx(); public native ColorCameraParams cx(float cx);
    /** Principal point y (pixel) */
    public native float cy(); public native ColorCameraParams cy(float cy);
    /**\}
    <p>
    /** \name Extrinsic parameters
     * These parameters are used in [a formula](https://github.com/OpenKinect/libfreenect2/issues/41#issuecomment-72022111) to map coordinates in the
     * depth camera to the color camera.
     *
     * They cannot be used for matrix transformation.
     */
    /**\{ */
    public native float shift_d(); public native ColorCameraParams shift_d(float shift_d);
    public native float shift_m(); public native ColorCameraParams shift_m(float shift_m);

    public native float mx_x3y0(); public native ColorCameraParams mx_x3y0(float mx_x3y0); // xxx
    public native float mx_x0y3(); public native ColorCameraParams mx_x0y3(float mx_x0y3); // yyy
    public native float mx_x2y1(); public native ColorCameraParams mx_x2y1(float mx_x2y1); // xxy
    public native float mx_x1y2(); public native ColorCameraParams mx_x1y2(float mx_x1y2); // yyx
    public native float mx_x2y0(); public native ColorCameraParams mx_x2y0(float mx_x2y0); // xx
    public native float mx_x0y2(); public native ColorCameraParams mx_x0y2(float mx_x0y2); // yy
    public native float mx_x1y1(); public native ColorCameraParams mx_x1y1(float mx_x1y1); // xy
    public native float mx_x1y0(); public native ColorCameraParams mx_x1y0(float mx_x1y0); // x
    public native float mx_x0y1(); public native ColorCameraParams mx_x0y1(float mx_x0y1); // y
    public native float mx_x0y0(); public native ColorCameraParams mx_x0y0(float mx_x0y0); // 1

    public native float my_x3y0(); public native ColorCameraParams my_x3y0(float my_x3y0); // xxx
    public native float my_x0y3(); public native ColorCameraParams my_x0y3(float my_x0y3); // yyy
    public native float my_x2y1(); public native ColorCameraParams my_x2y1(float my_x2y1); // xxy
    public native float my_x1y2(); public native ColorCameraParams my_x1y2(float my_x1y2); // yyx
    public native float my_x2y0(); public native ColorCameraParams my_x2y0(float my_x2y0); // xx
    public native float my_x0y2(); public native ColorCameraParams my_x0y2(float my_x0y2); // yy
    public native float my_x1y1(); public native ColorCameraParams my_x1y1(float my_x1y1); // xy
    public native float my_x1y0(); public native ColorCameraParams my_x1y0(float my_x1y0); // x
    public native float my_x0y1(); public native ColorCameraParams my_x0y1(float my_x0y1); // y
    public native float my_x0y0(); public native ColorCameraParams my_x0y0(float my_x0y0); // 1
    /**\} */
  }

  /** IR camera intrinsic calibration parameters.
   * Kinect v2 includes factory preset values for these parameters. They are used in depth image decoding, and Registration.
   */
  public static class IrCameraParams extends Pointer {
      static { Loader.load(); }
      /** Default native constructor. */
      public IrCameraParams() { super((Pointer)null); allocate(); }
      /** Native array allocator. Access with {@link Pointer#position(long)}. */
      public IrCameraParams(long size) { super((Pointer)null); allocateArray(size); }
      /** Pointer cast constructor. Invokes {@link Pointer#Pointer(Pointer)}. */
      public IrCameraParams(Pointer p) { super(p); }
      private native void allocate();
      private native void allocateArray(long size);
      @Override public IrCameraParams position(long position) {
          return (IrCameraParams)super.position(position);
      }
  
    /** Focal length x (pixel) */
    public native float fx(); public native IrCameraParams fx(float fx);
    /** Focal length y (pixel) */
    public native float fy(); public native IrCameraParams fy(float fy);
    /** Principal point x (pixel) */
    public native float cx(); public native IrCameraParams cx(float cx);
    /** Principal point y (pixel) */
    public native float cy(); public native IrCameraParams cy(float cy);
    /** Radial distortion coefficient, 1st-order */
    public native float k1(); public native IrCameraParams k1(float k1);
    /** Radial distortion coefficient, 2nd-order */
    public native float k2(); public native IrCameraParams k2(float k2);
    /** Radial distortion coefficient, 3rd-order */
    public native float k3(); public native IrCameraParams k3(float k3);
    /** Tangential distortion coefficient */
    public native float p1(); public native IrCameraParams p1(float p1);
    /** Tangential distortion coefficient */
    public native float p2(); public native IrCameraParams p2(float p2);
  }

  /** Configuration of depth processing. */
  public static class Config extends Pointer {
      static { Loader.load(); }
      /** Default native constructor. */
      public Config() { super((Pointer)null); allocate(); }
      /** Native array allocator. Access with {@link Pointer#position(long)}. */
      public Config(long size) { super((Pointer)null); allocateArray(size); }
      /** Pointer cast constructor. Invokes {@link Pointer#Pointer(Pointer)}. */
      public Config(Pointer p) { super(p); }
      private native void allocate();
      private native void allocateArray(long size);
      @Override public Config position(long position) {
          return (Config)super.position(position);
      }
  
    /** Clip at this minimum distance (meter). */
    public native float MinDepth(); public native Config MinDepth(float MinDepth);
    /** Clip at this maximum distance (meter). */
    public native float MaxDepth(); public native Config MaxDepth(float MaxDepth);

    /** Remove some "flying pixels". */
    public native @Cast("bool") boolean EnableBilateralFilter(); public native Config EnableBilateralFilter(boolean EnableBilateralFilter);
    /** Remove pixels on edges because ToF cameras produce noisy edges. */
    public native @Cast("bool") boolean EnableEdgeAwareFilter(); public native Config EnableEdgeAwareFilter(boolean EnableEdgeAwareFilter);

    /** Default is 0.5, 4.5, true, true */
  }

  public native @StdString BytePointer getSerialNumber();
  public native @StdString BytePointer getFirmwareVersion();

  /** Get current color parameters.
   * \copydetails ColorCameraParams
   */
  public native @ByVal ColorCameraParams getColorCameraParams();

  /** Get current depth parameters.
   * \copydetails IrCameraParams
   */
  public native @ByVal IrCameraParams getIrCameraParams();

  /** Replace factory preset color camera parameters.
   * We do not have a clear understanding of the meaning of the parameters right now.
   * You probably want to leave it as it is.
   */
  public native void setColorCameraParams(@Const @ByRef ColorCameraParams params);

  /** Replace factory preset depth camera parameters.
   * This decides accuracy in depth images. You are recommended to provide calibrated values.
   */
  public native void setIrCameraParams(@Const @ByRef IrCameraParams params);

  /** Configure depth processing. */
  public native void setConfiguration(@Const @ByRef Config config);

  /** Provide your listener to receive color frames. */
  public native void setColorFrameListener(FrameListener rgb_frame_listener);

  /** Provide your listener to receive IR and depth frames. */
  public native void setIrAndDepthFrameListener(FrameListener ir_frame_listener);

  /** Start data processing with both RGB and depth streams.
   * All above configuration must only be called before start() or after stop().
   *
   * FrameListener will receive frames when the device is running.
   *
   * @return true if ok, false if error.
   */
  public native @Cast("bool") boolean start();

  /** Start data processing with or without some streams.
   * FrameListener will receive enabled frames when the device is running.
   *
   * @param rgb Whether to enable RGB stream.
   * @param depth Whether to enable depth stream.
   * @return true if ok, false if error.
   */
  public native @Cast("bool") boolean startStreams(@Cast("bool") boolean rgb, @Cast("bool") boolean depth);

  /** Stop data processing.
   *
   * @return true if ok, false if error.
   */
  public native @Cast("bool") boolean stop();

  /** Shut down the device.
   *
   * @return true if ok, false if error.
   */
  public native @Cast("bool") @Name("close") boolean _close();
}

@Namespace("libfreenect2") @Opaque public static class Freenect2Impl extends Pointer {
    /** Empty constructor. Calls {@code super((Pointer)null)}. */
    public Freenect2Impl() { super((Pointer)null); }
    /** Pointer cast constructor. Invokes {@link Pointer#Pointer(Pointer)}. */
    public Freenect2Impl(Pointer p) { super(p); }
}

/**
 * Library context to find and open devices.
 *
 * You will first find existing devices by calling enumerateDevices().
 *
 * Then you can openDevice() and control the devices with returned Freenect2Device object.
 *
 * You may open devices with custom PacketPipeline.
 * After passing a PacketPipeline object to libfreenect2 do not use or free the object,
 * libfreenect2 will take care. If openDevice() fails the PacketPipeline object will get
 * deleted. A new PacketPipeline object has to be created each time a device is opened.
 */
@Namespace("libfreenect2") @NoOffset public static class Freenect2 extends Pointer {
    static { Loader.load(); }
    /** Native array allocator. Access with {@link Pointer#position(long)}. */
    public Freenect2(long size) { super((Pointer)null); allocateArray(size); }
    private native void allocateArray(long size);
    @Override public Freenect2 position(long position) {
        return (Freenect2)super.position(position);
    }

  /**
   * @param usb_context If the libusb context is provided,
   * Freenect2 will use it instead of creating one.
   */
  public Freenect2(Pointer usb_context/*=0*/) { super((Pointer)null); allocate(usb_context); }
  private native void allocate(Pointer usb_context/*=0*/);
  public Freenect2() { super((Pointer)null); allocate(); }
  private native void allocate();

  /** Must be called before doing anything else.
   * @return Number of devices, 0 if none
   */
  public native int enumerateDevices();

  /**
   * @param idx Device index
   * @return Device serial number, or empty if the index is invalid.
   */
  public native @StdString BytePointer getDeviceSerialNumber(int idx);

  /**
   * @return Device serial number, or empty if no device exists.
   */
  public native @StdString BytePointer getDefaultDeviceSerialNumber();

  /** Open device by index with default pipeline.
   * @param idx Index number. Index numbers are not determinstic during enumeration.
   * @return New device object, or NULL on failure
   */
  public native Freenect2Device openDevice(int idx);

  /** Open device by index.
   * @param idx Index number. Index numbers are not determinstic during enumeration.
   * @param factory New PacketPipeline instance. This is always automatically freed.
   * @return New device object, or NULL on failure
   */
  public native Freenect2Device openDevice(int idx, @Const PacketPipeline factory);

  /** Open device by serial number with default pipeline.
   * @param serial Serial number
   * @return New device object, or NULL on failure
   */
  public native Freenect2Device openDevice(@StdString BytePointer serial);
  public native Freenect2Device openDevice(@StdString String serial);

  /** Open device by serial number.
   * @param serial Serial number
   * @param factory New PacketPipeline instance. This is always automatically freed.
   * @return New device object, or NULL on failure
   */
  public native Freenect2Device openDevice(@StdString BytePointer serial, @Const PacketPipeline factory);
  public native Freenect2Device openDevice(@StdString String serial, @Const PacketPipeline factory);

  /** Open the first device with default pipeline.
   * @return New device object, or NULL on failure
   */
  public native Freenect2Device openDefaultDevice();

  /** Open the first device.
   * @param factory New PacketPipeline instance. This is always automatically freed.
   * @return New device object, or NULL on failure
   */
  public native Freenect2Device openDefaultDevice(@Const PacketPipeline factory);
}

/**\} */
 /* namespace libfreenect2 */
// #endif /* LIBFREENECT2_HPP_ */


// Parsed from <libfreenect2/frame_listener.hpp>

/*
 * This file is part of the OpenKinect Project. http://www.openkinect.org
 *
 * Copyright (c) 2014 individual OpenKinect contributors. See the CONTRIB file
 * for details.
 *
 * This code is licensed to you under the terms of the Apache License, version
 * 2.0, or, at your option, the terms of the GNU General Public License,
 * version 2.0. See the APACHE20 and GPL2 files for the text of the licenses,
 * or the following URLs:
 * http://www.apache.org/licenses/LICENSE-2.0
 * http://www.gnu.org/licenses/gpl-2.0.txt
 *
 * If you redistribute this file in source form, modified or unmodified, you
 * may:
 *   1) Leave this header intact and distribute it under the same terms,
 *      accompanying it with the APACHE20 and GPL20 files, or
 *   2) Delete the Apache 2.0 clause and accompany it with the GPL2 file, or
 *   3) Delete the GPL v2 clause and accompany it with the APACHE20 file
 * In all cases you must keep the copyright notice intact and include a copy
 * of the CONTRIB file.
 *
 * Binary distributions must follow the binary distribution requirements of
 * either License.
 */

/** \file frame_listener.hpp Classes for frame listeners. */

// #ifndef FRAME_LISTENER_HPP_
// #define FRAME_LISTENER_HPP_

// #include <cstddef>
// #include <stdint.h>
// #include <libfreenect2/config.h>

/** \defgroup frame Frame Listeners
 * Receive decoded image frames, and the frame format.
 */

/** Frame format and metadata. \ingroup frame */
@Namespace("libfreenect2") @NoOffset public static class Frame extends Pointer {
    static { Loader.load(); }
    /** Pointer cast constructor. Invokes {@link Pointer#Pointer(Pointer)}. */
    public Frame(Pointer p) { super(p); }

  /** Available types of frames. */
  /** enum libfreenect2::Frame::Type */
  public static final int
    /** 1920x1080. BGRX or RGBX. */
    Color = 1,
    /** 512x424 float. Range is [0.0, 65535.0]. */
    Ir = 2,
    /** 512x424 float, unit: millimeter. Non-positive, NaN, and infinity are invalid or missing data. */
    Depth = 4;

  /** Pixel format. */
  /** enum libfreenect2::Frame::Format */
  public static final int
    /** Invalid format. */
    Invalid = 0,
    /** Raw bitstream. 'bytes_per_pixel' defines the number of bytes */
    Raw = 1,
    /** A 4-byte float per pixel */
    Float = 2,
    /** 4 bytes of B, G, R, and unused per pixel */
    BGRX = 4,
    /** 4 bytes of R, G, B, and unused per pixel */
    RGBX = 5,
    /** 1 byte of gray per pixel */
    Gray = 6;

  /** Length of a line (in pixels). */
  public native @Cast("size_t") long width(); public native Frame width(long width);
  /** Number of lines in the frame. */
  public native @Cast("size_t") long height(); public native Frame height(long height);
  /** Number of bytes in a pixel. If frame format is 'Raw' this is the buffer size. */
  public native @Cast("size_t") long bytes_per_pixel(); public native Frame bytes_per_pixel(long bytes_per_pixel);
  /** Data of the frame (aligned). @see See Frame::Type for pixel format. */
  public native @Cast("unsigned char*") BytePointer data(); public native Frame data(BytePointer data);
  /** Unit: roughly or exactly 0.1 millisecond */
  public native @Cast("uint32_t") int timestamp(); public native Frame timestamp(int timestamp);
  /** Increasing frame sequence number */
  public native @Cast("uint32_t") int sequence(); public native Frame sequence(int sequence);
  /** From 0.5 (very bright) to ~60.0 (fully covered) */
  public native float exposure(); public native Frame exposure(float exposure);
  /** From 1.0 (bright) to 1.5 (covered) */
  public native float gain(); public native Frame gain(float gain);
  /** From 1.0 (bright) to 6.4 (covered) */
  public native float gamma(); public native Frame gamma(float gamma);
  /** zero if ok; non-zero for errors. */
  public native @Cast("uint32_t") int status(); public native Frame status(int status);
  /** Byte format. Informative only, doesn't indicate errors. */
  public native @Cast("libfreenect2::Frame::Format") int format(); public native Frame format(int format);

  /** Construct a new frame.
   * @param width Width in pixel
   * @param height Height in pixel
   * @param bytes_per_pixel Bytes per pixel
   * @param data_ Memory to store frame data. If {@code NULL}, new memory is allocated.
   */
  public Frame(@Cast("size_t") long width, @Cast("size_t") long height, @Cast("size_t") long bytes_per_pixel, @Cast("unsigned char*") BytePointer data_/*=NULL*/) { super((Pointer)null); allocate(width, height, bytes_per_pixel, data_); }
  private native void allocate(@Cast("size_t") long width, @Cast("size_t") long height, @Cast("size_t") long bytes_per_pixel, @Cast("unsigned char*") BytePointer data_/*=NULL*/);
  public Frame(@Cast("size_t") long width, @Cast("size_t") long height, @Cast("size_t") long bytes_per_pixel) { super((Pointer)null); allocate(width, height, bytes_per_pixel); }
  private native void allocate(@Cast("size_t") long width, @Cast("size_t") long height, @Cast("size_t") long bytes_per_pixel);
  public Frame(@Cast("size_t") long width, @Cast("size_t") long height, @Cast("size_t") long bytes_per_pixel, @Cast("unsigned char*") ByteBuffer data_/*=NULL*/) { super((Pointer)null); allocate(width, height, bytes_per_pixel, data_); }
  private native void allocate(@Cast("size_t") long width, @Cast("size_t") long height, @Cast("size_t") long bytes_per_pixel, @Cast("unsigned char*") ByteBuffer data_/*=NULL*/);
  public Frame(@Cast("size_t") long width, @Cast("size_t") long height, @Cast("size_t") long bytes_per_pixel, @Cast("unsigned char*") byte[] data_/*=NULL*/) { super((Pointer)null); allocate(width, height, bytes_per_pixel, data_); }
  private native void allocate(@Cast("size_t") long width, @Cast("size_t") long height, @Cast("size_t") long bytes_per_pixel, @Cast("unsigned char*") byte[] data_/*=NULL*/);
}

/** Callback interface to receive new frames. \ingroup frame
 * You can inherit from FrameListener and define your own listener.
 */
@Namespace("libfreenect2") public static class FrameListener extends Pointer {
    static { Loader.load(); }
    /** Pointer cast constructor. Invokes {@link Pointer#Pointer(Pointer)}. */
    public FrameListener(Pointer p) { super(p); }


  /**
   * libfreenect2 calls this function when a new frame is decoded.
   * @param type Type of the new frame.
   * @param frame Data of the frame.
   * @return true if you want to take ownership of the frame, i.e. reuse/delete it. Will be reused/deleted by caller otherwise.
   */
  public native @Cast("bool") boolean onNewFrame(@Cast("libfreenect2::Frame::Type") int type, Frame frame);
}

 /* namespace libfreenect2 */
// #endif /* FRAME_LISTENER_HPP_ */


// Parsed from <libfreenect2/frame_listener_impl.h>

/*
 * This file is part of the OpenKinect Project. http://www.openkinect.org
 *
 * Copyright (c) 2014 individual OpenKinect contributors. See the CONTRIB file
 * for details.
 *
 * This code is licensed to you under the terms of the Apache License, version
 * 2.0, or, at your option, the terms of the GNU General Public License,
 * version 2.0. See the APACHE20 and GPL2 files for the text of the licenses,
 * or the following URLs:
 * http://www.apache.org/licenses/LICENSE-2.0
 * http://www.gnu.org/licenses/gpl-2.0.txt
 *
 * If you redistribute this file in source form, modified or unmodified, you
 * may:
 *   1) Leave this header intact and distribute it under the same terms,
 *      accompanying it with the APACHE20 and GPL20 files, or
 *   2) Delete the Apache 2.0 clause and accompany it with the GPL2 file, or
 *   3) Delete the GPL v2 clause and accompany it with the APACHE20 file
 * In all cases you must keep the copyright notice intact and include a copy
 * of the CONTRIB file.
 *
 * Binary distributions must follow the binary distribution requirements of
 * either License.
 */

/** \file frame_listener_impl.h Implementation of the frame listener classes. */

// #ifndef FRAME_LISTENER_IMPL_H_
// #define FRAME_LISTENER_IMPL_H_

// #include <map>

// #include <libfreenect2/config.h>
// #include <libfreenect2/frame_listener.hpp>
/**\addtogroup frame
 * \{
<p>
/** Storage of multiple different types of frames. */

@Namespace("libfreenect2") @Opaque public static class SyncMultiFrameListenerImpl extends Pointer {
    /** Empty constructor. Calls {@code super((Pointer)null)}. */
    public SyncMultiFrameListenerImpl() { super((Pointer)null); }
    /** Pointer cast constructor. Invokes {@link Pointer#Pointer(Pointer)}. */
    public SyncMultiFrameListenerImpl(Pointer p) { super(p); }
}

/** Collect multiple types of frames. */
@Namespace("libfreenect2") @NoOffset public static class SyncMultiFrameListener extends FrameListener {
    static { Loader.load(); }
    /** Pointer cast constructor. Invokes {@link Pointer#Pointer(Pointer)}. */
    public SyncMultiFrameListener(Pointer p) { super(p); }

  /**
   * @param frame_types Use bitwise or to combine multiple types, e.g. {@code Frame::Ir | Frame::Depth}.
   */
  public SyncMultiFrameListener(@Cast("unsigned int") int frame_types) { super((Pointer)null); allocate(frame_types); }
  private native void allocate(@Cast("unsigned int") int frame_types);

  /** Test if there are new frames. Non-blocking. */
  public native @Cast("bool") boolean hasNewFrame();

  /** Wait milliseconds for new frames.
   * @param [out] frame Caller is responsible to release the frames.
   * @param milliseconds Timeout. This parameter is ignored if not built with C++11 threading support.
   * @return true if a frame is received; false if not.
   */
  public native @Cast("bool") boolean waitForNewFrame(@ByRef FrameMap frame, int milliseconds);

  /** Wait indefinitely for new frames.
   * @param [out] frame Caller is responsible to release the frames.
   */
  public native void waitForNewFrame(@ByRef FrameMap frame);

  /** Shortcut to delete all frames */
  public native void release(@ByRef FrameMap frame);

  public native @Cast("bool") boolean onNewFrame(@Cast("libfreenect2::Frame::Type") int type, Frame frame);
}

/**\} */
 /* namespace libfreenect2 */
// #endif /* FRAME_LISTENER_IMPL_H_ */


// Parsed from <libfreenect2/logger.h>

/*
 * This file is part of the OpenKinect Project. http://www.openkinect.org
 *
 * Copyright (c) 2014 individual OpenKinect contributors. See the CONTRIB file
 * for details.
 *
 * This code is licensed to you under the terms of the Apache License, version
 * 2.0, or, at your option, the terms of the GNU General Public License,
 * version 2.0. See the APACHE20 and GPL2 files for the text of the licenses,
 * or the following URLs:
 * http://www.apache.org/licenses/LICENSE-2.0
 * http://www.gnu.org/licenses/gpl-2.0.txt
 *
 * If you redistribute this file in source form, modified or unmodified, you
 * may:
 *   1) Leave this header intact and distribute it under the same terms,
 *      accompanying it with the APACHE20 and GPL20 files, or
 *   2) Delete the Apache 2.0 clause and accompany it with the GPL2 file, or
 *   3) Delete the GPL v2 clause and accompany it with the APACHE20 file
 * In all cases you must keep the copyright notice intact and include a copy
 * of the CONTRIB file.
 *
 * Binary distributions must follow the binary distribution requirements of
 * either License.
 */

/** \file logger.h Declaration of logging classes. */

// #ifndef LIBFREENECT2_LOGGER_H_
// #define LIBFREENECT2_LOGGER_H_

// #include <string>

// #include <libfreenect2/config.h>

/** \defgroup logging Logging utilities
 * Specify logging level and custom logging destination. */
/**\{
<p>
/** Provide interfaces to receive log messages.
 * You can inherit this class and implement your custom logger. */
@Namespace("libfreenect2") public static class Logger extends Pointer {
    static { Loader.load(); }
    /** Pointer cast constructor. Invokes {@link Pointer#Pointer(Pointer)}. */
    public Logger(Pointer p) { super(p); }

  /** Available levels of logging, higher is more output. */
  /** enum libfreenect2::Logger::Level */
  public static final int
    None = 0,
    Error = 1,
    Warning = 2,
    Info = 3,
    Debug = 4;

  /** Default is Info, or overridden by environment variable {@code LIBFREENECT2_LOGGER_LEVEL}.
   * {@code LIBFREENECT2_LOGGER_LEVEL} can contain a case-insensitive name of level.
   */
  public static native @Cast("libfreenect2::Logger::Level") int getDefaultLevel();

  /** Convert logging level to a human-readable name.
   */
  public static native @StdString BytePointer level2str(@Cast("libfreenect2::Logger::Level") int level);

  /** Get the level of the logger; the level is immutable. */
  public native @Cast("libfreenect2::Logger::Level") int level();

  /** libfreenect2 calls this function to output all log messages. */
  public native void log(@Cast("libfreenect2::Logger::Level") int level, @StdString BytePointer message);
  public native void log(@Cast("libfreenect2::Logger::Level") int level, @StdString String message);
}

/** Allocate a Logger instance that outputs log to standard input/output  */

/** \copybrief Logger::getDefaultLevel
 *
 * %libfreenect2 will have an initial global logger created with createConsoleLoggerWithDefaultLevel().
 * You do not have to explicitly call this if the default is already what you want.
 */

/** Get the pointer to the current logger.
 * @return Pointer to the logger. This is purely informational. You should not free the pointer.
 */

/** Set the logger for all log output in this library.
 * @param logger Pointer to your logger, or {@code NULL} to disable logging. The memory will be freed automatically. You should not free the pointer.
 */

/**\} */
 /* namespace libfreenect2 */
// #endif /* LIBFREENECT2_LOGGER_H_ */


// Parsed from <libfreenect2/packet_pipeline.h>

/*
 * This file is part of the OpenKinect Project. http://www.openkinect.org
 *
 * Copyright (c) 2014 individual OpenKinect contributors. See the CONTRIB file
 * for details.
 *
 * This code is licensed to you under the terms of the Apache License, version
 * 2.0, or, at your option, the terms of the GNU General Public License,
 * version 2.0. See the APACHE20 and GPL2 files for the text of the licenses,
 * or the following URLs:
 * http://www.apache.org/licenses/LICENSE-2.0
 * http://www.gnu.org/licenses/gpl-2.0.txt
 *
 * If you redistribute this file in source form, modified or unmodified, you
 * may:
 *   1) Leave this header intact and distribute it under the same terms,
 *      accompanying it with the APACHE20 and GPL20 files, or
 *   2) Delete the Apache 2.0 clause and accompany it with the GPL2 file, or
 *   3) Delete the GPL v2 clause and accompany it with the APACHE20 file
 * In all cases you must keep the copyright notice intact and include a copy
 * of the CONTRIB file.
 *
 * Binary distributions must follow the binary distribution requirements of
 * either License.
 */

/** \file packet_pipeline.h Packet pipe line definitions. */

// #ifndef PACKET_PIPELINE_H_
// #define PACKET_PIPELINE_H_

// #include <libfreenect2/config.h>

// #include <stdlib.h>

@Namespace("libfreenect2") @Opaque public static class DataCallback extends Pointer {
    /** Empty constructor. Calls {@code super((Pointer)null)}. */
    public DataCallback() { super((Pointer)null); }
    /** Pointer cast constructor. Invokes {@link Pointer#Pointer(Pointer)}. */
    public DataCallback(Pointer p) { super(p); }
}
@Namespace("libfreenect2") @Opaque public static class RgbPacketProcessor extends Pointer {
    /** Empty constructor. Calls {@code super((Pointer)null)}. */
    public RgbPacketProcessor() { super((Pointer)null); }
    /** Pointer cast constructor. Invokes {@link Pointer#Pointer(Pointer)}. */
    public RgbPacketProcessor(Pointer p) { super(p); }
}
@Namespace("libfreenect2") @Opaque public static class DepthPacketProcessor extends Pointer {
    /** Empty constructor. Calls {@code super((Pointer)null)}. */
    public DepthPacketProcessor() { super((Pointer)null); }
    /** Pointer cast constructor. Invokes {@link Pointer#Pointer(Pointer)}. */
    public DepthPacketProcessor(Pointer p) { super(p); }
}
@Namespace("libfreenect2") @Opaque public static class PacketPipelineComponents extends Pointer {
    /** Empty constructor. Calls {@code super((Pointer)null)}. */
    public PacketPipelineComponents() { super((Pointer)null); }
    /** Pointer cast constructor. Invokes {@link Pointer#Pointer(Pointer)}. */
    public PacketPipelineComponents(Pointer p) { super(p); }
}

/** \defgroup pipeline Packet Pipelines
 * Implement various methods to decode color and depth images with different performance and platform support
 *
 * You can construct a specific PacketPipeline object and provide it to Freenect2::openDevice().
 */
/**\{
<p>
/** Base class for other pipeline classes.
 * Methods in this class are reserved for internal use.
 */
@Namespace("libfreenect2") @NoOffset public static class PacketPipeline extends Pointer {
    static { Loader.load(); }
    /** Pointer cast constructor. Invokes {@link Pointer#Pointer(Pointer)}. */
    public PacketPipeline(Pointer p) { super(p); }
    /** Native array allocator. Access with {@link Pointer#position(long)}. */
    public PacketPipeline(long size) { super((Pointer)null); allocateArray(size); }
    private native void allocateArray(long size);
    @Override public PacketPipeline position(long position) {
        return (PacketPipeline)super.position(position);
    }


  public PacketPipeline() { super((Pointer)null); allocate(); }
  private native void allocate();

  public native @Cast("libfreenect2::PacketPipeline::PacketParser*") DataCallback getRgbPacketParser();
  public native @Cast("libfreenect2::PacketPipeline::PacketParser*") DataCallback getIrPacketParser();

  public native RgbPacketProcessor getRgbPacketProcessor();
  public native DepthPacketProcessor getDepthPacketProcessor();
}

 @Namespace("libfreenect2") public static class DumpPacketPipeline extends PacketPipeline {
     static { Loader.load(); }
     /** Pointer cast constructor. Invokes {@link Pointer#Pointer(Pointer)}. */
     public DumpPacketPipeline(Pointer p) { super(p); }
     /** Native array allocator. Access with {@link Pointer#position(long)}. */
     public DumpPacketPipeline(long size) { super((Pointer)null); allocateArray(size); }
     private native void allocateArray(long size);
     @Override public DumpPacketPipeline position(long position) {
         return (DumpPacketPipeline)super.position(position);
     }
 
   public DumpPacketPipeline() { super((Pointer)null); allocate(); }
   private native void allocate();

   // These are all required to decode depth data
   public native @Cast("const unsigned char*") BytePointer getDepthP0Tables(@Cast("size_t*") SizeTPointer length);

   public native @Const FloatPointer getDepthXTable(@Cast("size_t*") SizeTPointer length);
   public native @Const FloatPointer getDepthZTable(@Cast("size_t*") SizeTPointer length);
   public native @Const ShortPointer getDepthLookupTable(@Cast("size_t*") SizeTPointer length);
 }

/** Pipeline with CPU depth processing. */
@Namespace("libfreenect2") public static class CpuPacketPipeline extends PacketPipeline {
    static { Loader.load(); }
    /** Pointer cast constructor. Invokes {@link Pointer#Pointer(Pointer)}. */
    public CpuPacketPipeline(Pointer p) { super(p); }
    /** Native array allocator. Access with {@link Pointer#position(long)}. */
    public CpuPacketPipeline(long size) { super((Pointer)null); allocateArray(size); }
    private native void allocateArray(long size);
    @Override public CpuPacketPipeline position(long position) {
        return (CpuPacketPipeline)super.position(position);
    }

  public CpuPacketPipeline() { super((Pointer)null); allocate(); }
  private native void allocate();
}

// #ifdef LIBFREENECT2_WITH_OPENGL_SUPPORT
/** Pipeline with OpenGL depth processing. */
@Namespace("libfreenect2") @NoOffset public static class OpenGLPacketPipeline extends PacketPipeline {
    static { Loader.load(); }
    /** Pointer cast constructor. Invokes {@link Pointer#Pointer(Pointer)}. */
    public OpenGLPacketPipeline(Pointer p) { super(p); }
    /** Native array allocator. Access with {@link Pointer#position(long)}. */
    public OpenGLPacketPipeline(long size) { super((Pointer)null); allocateArray(size); }
    private native void allocateArray(long size);
    @Override public OpenGLPacketPipeline position(long position) {
        return (OpenGLPacketPipeline)super.position(position);
    }

  public OpenGLPacketPipeline(Pointer parent_opengl_context/*=0*/, @Cast("bool") boolean debug/*=false*/) { super((Pointer)null); allocate(parent_opengl_context, debug); }
  private native void allocate(Pointer parent_opengl_context/*=0*/, @Cast("bool") boolean debug/*=false*/);
  public OpenGLPacketPipeline() { super((Pointer)null); allocate(); }
  private native void allocate();
}
// #endif // LIBFREENECT2_WITH_OPENGL_SUPPORT

// #ifdef LIBFREENECT2_WITH_OPENCL_SUPPORT
// #endif // LIBFREENECT2_WITH_OPENCL_SUPPORT

// #ifdef LIBFREENECT2_WITH_CUDA_SUPPORT
// #endif // LIBFREENECT2_WITH_CUDA_SUPPORT

/**\} */
 /* namespace libfreenect2 */
// #endif /* PACKET_PIPELINE_H_ */


// Parsed from <libfreenect2/registration.h>

/*
 * This file is part of the OpenKinect Project. http://www.openkinect.org
 *
 * Copyright (c) 2014 individual OpenKinect contributors. See the CONTRIB file
 * for details.
 *
 * This code is licensed to you under the terms of the Apache License, version
 * 2.0, or, at your option, the terms of the GNU General Public License,
 * version 2.0. See the APACHE20 and GPL2 files for the text of the licenses,
 * or the following URLs:
 * http://www.apache.org/licenses/LICENSE-2.0
 * http://www.gnu.org/licenses/gpl-2.0.txt
 *
 * If you redistribute this file in source form, modified or unmodified, you
 * may:
 *   1) Leave this header intact and distribute it under the same terms,
 *      accompanying it with the APACHE20 and GPL20 files, or
 *   2) Delete the Apache 2.0 clause and accompany it with the GPL2 file, or
 *   3) Delete the GPL v2 clause and accompany it with the APACHE20 file
 * In all cases you must keep the copyright notice intact and include a copy
 * of the CONTRIB file.
 *
 * Binary distributions must follow the binary distribution requirements of
 * either License.
 */

/** \file registration.h Class for merging depth and color frames. */

// #ifndef REGISTRATION_H_
// #define REGISTRATION_H_

// #include <string>
// #include <libfreenect2/config.h>
// #include <libfreenect2/libfreenect2.hpp>
// #include <libfreenect2/frame_listener.hpp>

@Namespace("libfreenect2") @Opaque public static class RegistrationImpl extends Pointer {
    /** Empty constructor. Calls {@code super((Pointer)null)}. */
    public RegistrationImpl() { super((Pointer)null); }
    /** Pointer cast constructor. Invokes {@link Pointer#Pointer(Pointer)}. */
    public RegistrationImpl(Pointer p) { super(p); }
}

/** \defgroup registration Registration and Geometry
 * Register depth to color, create point clouds. */

/** Combine frames of depth and color camera. \ingroup registration
 * Right now this class uses a reverse engineered formula that uses factory
 * preset extrinsic parameters.  We do not have a clear understanding of these
 * particular extrinsic parameters and do not know how to calibrate them by
 * hand.
 *
 * If you want to perform registration with standard camera extrinsic matrix,
 * you probably need something else.
 */
@Namespace("libfreenect2") @NoOffset public static class Registration extends Pointer {
    static { Loader.load(); }
    /** Pointer cast constructor. Invokes {@link Pointer#Pointer(Pointer)}. */
    public Registration(Pointer p) { super(p); }

  /**
   * @param depth_p Depth camera parameters. You can use the factory values, or use your own.
   * @param rgb_p Color camera parameters. Probably use the factory values for now.
   */
  public Registration(@ByVal Freenect2Device.IrCameraParams depth_p, @ByVal Freenect2Device.ColorCameraParams rgb_p) { super((Pointer)null); allocate(depth_p, rgb_p); }
  private native void allocate(@ByVal Freenect2Device.IrCameraParams depth_p, @ByVal Freenect2Device.ColorCameraParams rgb_p);

  /** Undistort and register a single depth point to color camera.
   * @param dx Distorted depth coordinate x (pixel)
   * @param dy Distorted depth coordinate y (pixel)
   * @param dz Depth value (millimeter)
   * @param [out] cx Undistorted color coordinate x (normalized)
   * @param [out] cy Undistorted color coordinate y (normalized)
   */
  public native void apply(int dx, int dy, float dz, @ByRef FloatPointer cx, @ByRef FloatPointer cy);
  public native void apply(int dx, int dy, float dz, @ByRef FloatBuffer cx, @ByRef FloatBuffer cy);
  public native void apply(int dx, int dy, float dz, @ByRef float[] cx, @ByRef float[] cy);

  /** Map color images onto depth images
   * @param rgb Color image (1920x1080 BGRX)
   * @param depth Depth image (512x424 float)
   * @param [out] undistorted Undistorted depth image
   * @param [out] registered Color image for the depth image (512x424)
   * @param enable_filter Filter out pixels not visible to both cameras.
   * @param [out] bigdepth If not {@code NULL}, return mapping of depth onto colors (1920x1082 float). **1082** not 1080, with a blank top and bottom row.
   * @param [out] color_depth_map Index of mapped color pixel for each depth pixel (512x424).
   */
  public native void apply(@Const Frame rgb, @Const Frame depth, Frame undistorted, Frame registered, @Cast("const bool") boolean enable_filter/*=true*/, Frame bigdepth/*=0*/, IntPointer color_depth_map/*=0*/);
  public native void apply(@Const Frame rgb, @Const Frame depth, Frame undistorted, Frame registered);
  public native void apply(@Const Frame rgb, @Const Frame depth, Frame undistorted, Frame registered, @Cast("const bool") boolean enable_filter/*=true*/, Frame bigdepth/*=0*/, IntBuffer color_depth_map/*=0*/);
  public native void apply(@Const Frame rgb, @Const Frame depth, Frame undistorted, Frame registered, @Cast("const bool") boolean enable_filter/*=true*/, Frame bigdepth/*=0*/, int[] color_depth_map/*=0*/);

  /** Undistort depth
   * @param depth Depth image (512x424 float)
   * @param [out] undistorted Undistorted depth image
   */
  public native void undistortDepth(@Const Frame depth, Frame undistorted);

  /** Construct a 3-D point with color in a point cloud.
   * @param undistorted Undistorted depth frame from apply().
   * @param registered Registered color frame from apply().
   * @param r Row (y) index in depth image.
   * @param c Column (x) index in depth image.
   * @param [out] x X coordinate of the 3-D point (meter).
   * @param [out] y Y coordinate of the 3-D point (meter).
   * @param [out] z Z coordinate of the 3-D point (meter).
   * @param [out] rgb Color of the 3-D point (BGRX). To unpack the data, use
   *
   *     const uint8_t *p = reinterpret_cast<uint8_t*>(&rgb);
   *     uint8_t b = p[0];
   *     uint8_t g = p[1];
   *     uint8_t r = p[2];
   */
  public native void getPointXYZRGB(@Const Frame undistorted, @Const Frame registered, int r, int c, @ByRef FloatPointer x, @ByRef FloatPointer y, @ByRef FloatPointer z, @ByRef FloatPointer rgb);
  public native void getPointXYZRGB(@Const Frame undistorted, @Const Frame registered, int r, int c, @ByRef FloatBuffer x, @ByRef FloatBuffer y, @ByRef FloatBuffer z, @ByRef FloatBuffer rgb);
  public native void getPointXYZRGB(@Const Frame undistorted, @Const Frame registered, int r, int c, @ByRef float[] x, @ByRef float[] y, @ByRef float[] z, @ByRef float[] rgb);

  /** Construct a 3-D point in a point cloud.
   * @param undistorted Undistorted depth frame from apply().
   * @param r Row (y) index in depth image.
   * @param c Column (x) index in depth image.
   * @param [out] x X coordinate of the 3-D point (meter).
   * @param [out] y Y coordinate of the 3-D point (meter).
   * @param [out] z Z coordinate of the 3-D point (meter).
   */
  public native void getPointXYZ(@Const Frame undistorted, int r, int c, @ByRef FloatPointer x, @ByRef FloatPointer y, @ByRef FloatPointer z);
  public native void getPointXYZ(@Const Frame undistorted, int r, int c, @ByRef FloatBuffer x, @ByRef FloatBuffer y, @ByRef FloatBuffer z);
  public native void getPointXYZ(@Const Frame undistorted, int r, int c, @ByRef float[] x, @ByRef float[] y, @ByRef float[] z);
}

 /* namespace libfreenect2 */
// #endif /* REGISTRATION_H_ */


// Parsed from <libfreenect2/config.h>

/*
* This file is part of the OpenKinect Project. http://www.openkinect.org
*
* Copyright (c) 2014 individual OpenKinect contributors. See the CONTRIB file
* for details.
*
* This code is licensed to you under the terms of the Apache License, version
* 2.0, or, at your option, the terms of the GNU General Public License,
* version 2.0. See the APACHE20 and GPL2 files for the text of the licenses,
* or the following URLs:
* http://www.apache.org/licenses/LICENSE-2.0
* http://www.gnu.org/licenses/gpl-2.0.txt
*
* If you redistribute this file in source form, modified or unmodified, you
* may:
*   1) Leave this header intact and distribute it under the same terms,
*      accompanying it with the APACHE20 and GPL20 files, or
*   2) Delete the Apache 2.0 clause and accompany it with the GPL2 file, or
*   3) Delete the GPL v2 clause and accompany it with the APACHE20 file
* In all cases you must keep the copyright notice intact and include a copy
* of the CONTRIB file.
*
* Binary distributions must follow the binary distribution requirements of
* either License.
*/

// #ifndef LIBFREENECT2_CONFIG_H
// #define LIBFREENECT2_CONFIG_H

public static final String LIBFREENECT2_VERSION = "0.2.0";
public static final int LIBFREENECT2_API_VERSION = ((0 << 16) | 2);

// #ifdef _MSC_VER
// #define LIBFREENECT2_PACK( __Declaration__ ) __pragma( pack(push, 1) ) __Declaration__ __pragma( pack(pop) )
// #else
// #define LIBFREENECT2_PACK( __Declaration__ ) __Declaration__ __attribute__((__packed__))
// #endif

// #include <libfreenect2/export.h>
// #define LIBFREENECT2_API LIBFREENECT2_EXPORT

// #define LIBFREENECT2_WITH_OPENGL_SUPPORT

/* #undef LIBFREENECT2_WITH_OPENCL_SUPPORT */
/* #undef LIBFREENECT2_OPENCL_ICD_LOADER_IS_OLD */

/* #undef LIBFREENECT2_WITH_CUDA_SUPPORT */

/* #undef LIBFREENECT2_WITH_VT_SUPPORT */

/* #undef LIBFREENECT2_WITH_VAAPI_SUPPORT */

// #define LIBFREENECT2_WITH_TURBOJPEG_SUPPORT

/* #undef LIBFREENECT2_WITH_TEGRAJPEG_SUPPORT */
public static final String LIBFREENECT2_TEGRAJPEG_LIBRARY = "";

/* #undef LIBFREENECT2_THREADING_STDLIB */

// #define LIBFREENECT2_THREADING_TINYTHREAD

/* #undef LIBFREENECT2_WITH_CXX11_SUPPORT */

/* #undef LIBFREENECT2_WITH_PROFILING */

// #endif // LIBFREENECT2_CONFIG_H


}
