/*
 * Decompiled with CFR 0.152.
 */
package org.opencv.xphoto;

import org.opencv.core.Mat;
import org.opencv.xphoto.GrayworldWB;
import org.opencv.xphoto.LearningBasedWB;
import org.opencv.xphoto.SimpleWB;

public class Xphoto {
    public static final int HAAR = 0;
    public static final int BM3D_STEPALL = 0;
    public static final int BM3D_STEP1 = 1;
    public static final int BM3D_STEP2 = 2;
    public static final int INPAINT_SHIFTMAP = 0;

    public static GrayworldWB createGrayworldWB() {
        GrayworldWB retVal = GrayworldWB.__fromPtr__(Xphoto.createGrayworldWB_0());
        return retVal;
    }

    public static LearningBasedWB createLearningBasedWB(String path_to_model) {
        LearningBasedWB retVal = LearningBasedWB.__fromPtr__(Xphoto.createLearningBasedWB_0(path_to_model));
        return retVal;
    }

    public static LearningBasedWB createLearningBasedWB() {
        LearningBasedWB retVal = LearningBasedWB.__fromPtr__(Xphoto.createLearningBasedWB_1());
        return retVal;
    }

    public static SimpleWB createSimpleWB() {
        SimpleWB retVal = SimpleWB.__fromPtr__(Xphoto.createSimpleWB_0());
        return retVal;
    }

    public static void applyChannelGains(Mat src, Mat dst, float gainB, float gainG, float gainR) {
        Xphoto.applyChannelGains_0(src.nativeObj, dst.nativeObj, gainB, gainG, gainR);
    }

    public static void bm3dDenoising(Mat src, Mat dst, float h, int templateWindowSize, int searchWindowSize, int blockMatchingStep1, int blockMatchingStep2, int groupSize, int slidingStep, float beta, int normType, int step, int transformType) {
        Xphoto.bm3dDenoising_0(src.nativeObj, dst.nativeObj, h, templateWindowSize, searchWindowSize, blockMatchingStep1, blockMatchingStep2, groupSize, slidingStep, beta, normType, step, transformType);
    }

    public static void bm3dDenoising(Mat src, Mat dst) {
        Xphoto.bm3dDenoising_1(src.nativeObj, dst.nativeObj);
    }

    public static void bm3dDenoising(Mat src, Mat dstStep1, Mat dstStep2, float h, int templateWindowSize, int searchWindowSize, int blockMatchingStep1, int blockMatchingStep2, int groupSize, int slidingStep, float beta, int normType, int step, int transformType) {
        Xphoto.bm3dDenoising_2(src.nativeObj, dstStep1.nativeObj, dstStep2.nativeObj, h, templateWindowSize, searchWindowSize, blockMatchingStep1, blockMatchingStep2, groupSize, slidingStep, beta, normType, step, transformType);
    }

    public static void bm3dDenoising(Mat src, Mat dstStep1, Mat dstStep2) {
        Xphoto.bm3dDenoising_3(src.nativeObj, dstStep1.nativeObj, dstStep2.nativeObj);
    }

    public static void dctDenoising(Mat src, Mat dst, double sigma, int psize) {
        Xphoto.dctDenoising_0(src.nativeObj, dst.nativeObj, sigma, psize);
    }

    public static void dctDenoising(Mat src, Mat dst, double sigma) {
        Xphoto.dctDenoising_1(src.nativeObj, dst.nativeObj, sigma);
    }

    public static void inpaint(Mat src, Mat mask, Mat dst, int algorithmType) {
        Xphoto.inpaint_0(src.nativeObj, mask.nativeObj, dst.nativeObj, algorithmType);
    }

    private static native long createGrayworldWB_0();

    private static native long createLearningBasedWB_0(String var0);

    private static native long createLearningBasedWB_1();

    private static native long createSimpleWB_0();

    private static native void applyChannelGains_0(long var0, long var2, float var4, float var5, float var6);

    private static native void bm3dDenoising_0(long var0, long var2, float var4, int var5, int var6, int var7, int var8, int var9, int var10, float var11, int var12, int var13, int var14);

    private static native void bm3dDenoising_1(long var0, long var2);

    private static native void bm3dDenoising_2(long var0, long var2, long var4, float var6, int var7, int var8, int var9, int var10, int var11, int var12, float var13, int var14, int var15, int var16);

    private static native void bm3dDenoising_3(long var0, long var2, long var4);

    private static native void dctDenoising_0(long var0, long var2, double var4, int var6);

    private static native void dctDenoising_1(long var0, long var2, double var4);

    private static native void inpaint_0(long var0, long var2, long var4, int var6);
}

