/*
 * Decompiled with CFR 0.152.
 */
package org.casbin.utils;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import org.apache.commons.io.IOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.io.DefaultResourceLoader;
import org.springframework.core.io.Resource;

public class FileUtils {
    private static final Logger logger = LoggerFactory.getLogger(FileUtils.class);

    private static String removePrefix(String str, String prefix) {
        if (str.startsWith(prefix)) {
            return str.substring(prefix.length());
        }
        return str;
    }

    public static File getFile(String filePath) {
        File template = new File(FileUtils.removePrefix(filePath, "classpath:"));
        if (template.exists()) {
            return template;
        }
        return null;
    }

    public static InputStream getFileAsInputStream(String filePath) {
        File file = FileUtils.getFile(filePath);
        try {
            if (file != null && file.exists()) {
                return Files.newInputStream(file.toPath(), new OpenOption[0]);
            }
            Resource resource = new DefaultResourceLoader().getResource(filePath);
            if (resource.exists()) {
                return resource.getInputStream();
            }
            return null;
        }
        catch (Exception e) {
            logger.error("load file $filePath by inputStream error", (Throwable)e);
            return null;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static String getFileAsText(String filePath) {
        try (InputStream inputStream = FileUtils.getFileAsInputStream(filePath);){
            if (inputStream == null) return null;
            String string = IOUtils.toString((InputStream)inputStream, (Charset)StandardCharsets.UTF_8);
            return string;
        }
        catch (IOException e) {
            logger.error(e.getMessage(), (Throwable)e);
        }
        return null;
    }
}

