/*
 * Decompiled with CFR 0.152.
 */
package org.casbin.watcher;

import java.util.UUID;
import java.util.function.Consumer;
import org.apache.commons.pool2.impl.GenericObjectPoolConfig;
import org.casbin.jcasbin.persist.Watcher;
import org.casbin.watcher.SubThread;
import redis.clients.jedis.Jedis;
import redis.clients.jedis.JedisPool;
import redis.clients.jedis.JedisPoolConfig;

public class RedisWatcher
implements Watcher {
    private Runnable updateCallback;
    private final JedisPool jedisPool;
    private final String localId;
    private final String redisChannelName;
    private SubThread subThread;

    public RedisWatcher(String redisIp, int redisPort, String redisChannelName, int timeout, String password) {
        this.jedisPool = new JedisPool((GenericObjectPoolConfig)new JedisPoolConfig(), redisIp, redisPort, timeout, password);
        this.localId = UUID.randomUUID().toString();
        this.redisChannelName = redisChannelName;
        this.startSub();
    }

    public RedisWatcher(JedisPoolConfig config, String redisIp, int redisPort, String redisChannelName, int timeout, String password) {
        this.jedisPool = new JedisPool((GenericObjectPoolConfig)config, redisIp, redisPort, timeout, password);
        this.localId = UUID.randomUUID().toString();
        this.redisChannelName = redisChannelName;
        this.startSub();
    }

    public RedisWatcher(String redisIp, int redisPort, String redisChannelName) {
        this(redisIp, redisPort, redisChannelName, 2000, null);
    }

    public void setUpdateCallback(Runnable runnable) {
        this.updateCallback = runnable;
        this.subThread.setUpdateCallback(runnable);
    }

    public void setUpdateCallback(Consumer<String> consumer) {
        this.subThread.setUpdateCallback(consumer);
    }

    public void update() {
        try (Jedis jedis = this.jedisPool.getResource();){
            jedis.publish(this.redisChannelName, "Casbin policy has a new version from redis watcher: " + this.localId);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void startSub() {
        this.subThread = new SubThread(this.jedisPool, this.redisChannelName, this.updateCallback);
        this.subThread.start();
    }
}

