/*
 * Decompiled with CFR 0.152.
 */
package org.casbin.jcasbin.persist.file_adapter;

import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.List;
import java.util.Map;
import org.casbin.jcasbin.model.Assertion;
import org.casbin.jcasbin.model.Model;
import org.casbin.jcasbin.persist.Adapter;
import org.casbin.jcasbin.persist.Helper;
import org.casbin.jcasbin.util.Util;

public class FileAdapter
implements Adapter {
    private String filePath;

    public FileAdapter(String filePath) {
        this.filePath = filePath;
    }

    @Override
    public void loadPolicy(Model model) {
        if (this.filePath.equals("")) {
            return;
        }
        this.loadPolicyFile(model, Helper::loadPolicyLine);
    }

    @Override
    public void savePolicy(Model model) {
        Assertion ast;
        String ptype;
        if (this.filePath.equals("")) {
            throw new Error("invalid file path, file path cannot be empty");
        }
        StringBuilder tmp = new StringBuilder();
        for (Map.Entry entry : ((Map)model.model.get("p")).entrySet()) {
            ptype = (String)entry.getKey();
            ast = (Assertion)entry.getValue();
            for (List<String> rule : ast.policy) {
                tmp.append(ptype + ", ");
                tmp.append(Util.arrayToString(rule));
                tmp.append("\n");
            }
        }
        for (Map.Entry entry : ((Map)model.model.get("g")).entrySet()) {
            ptype = (String)entry.getKey();
            ast = (Assertion)entry.getValue();
            for (List<String> rule : ast.policy) {
                tmp.append(ptype + ", ");
                tmp.append(Util.arrayToString(rule));
                tmp.append("\n");
            }
        }
        this.savePolicyFile(tmp.toString().trim());
    }

    private void loadPolicyFile(Model model, Helper.loadPolicyLineHandler<String, Model> handler) {
        FileInputStream fis;
        try {
            fis = new FileInputStream(this.filePath);
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
            throw new Error("policy file not found");
        }
        BufferedReader br = new BufferedReader(new InputStreamReader(fis));
        try {
            String line;
            while ((line = br.readLine()) != null) {
                handler.accept(line, model);
            }
            fis.close();
            br.close();
        }
        catch (IOException e) {
            e.printStackTrace();
            throw new Error("IO error occurred");
        }
    }

    private void savePolicyFile(String text) {
        try {
            FileOutputStream fos = new FileOutputStream(this.filePath);
            fos.write(text.getBytes());
            fos.close();
        }
        catch (IOException e) {
            e.printStackTrace();
            throw new Error("IO error occurred");
        }
    }

    @Override
    public void addPolicy(String sec, String ptype, List<String> rule) {
        throw new Error("not implemented");
    }

    @Override
    public void removePolicy(String sec, String ptype, List<String> rule) {
        throw new Error("not implemented");
    }

    @Override
    public void removeFilteredPolicy(String sec, String ptype, int fieldIndex, String ... fieldValues) {
        throw new Error("not implemented");
    }
}

