/*
 * Decompiled with CFR 0.152.
 */
package org.crazycake.shiro;

import java.util.Collections;
import java.util.HashSet;
import org.apache.commons.pool2.impl.GenericObjectPoolConfig;
import org.crazycake.shiro.BaseRedisManager;
import org.crazycake.shiro.IRedisManager;
import redis.clients.jedis.Jedis;
import redis.clients.jedis.JedisSentinelPool;

public class RedisSentinelManager
extends BaseRedisManager
implements IRedisManager {
    private static final String DEFAULT_HOST = "127.0.0.1:26379,127.0.0.1:26380,127.0.0.1:26381";
    private String host = "127.0.0.1:26379,127.0.0.1:26380,127.0.0.1:26381";
    private static final String DEFAULT_MASTER_NAME = "mymaster";
    private String masterName = "mymaster";
    private int timeout = 2000;
    private int soTimeout = 2000;
    private String password;
    private int database = 0;
    private JedisSentinelPool jedisPool;

    @Override
    protected Jedis getJedis() {
        if (this.jedisPool == null) {
            this.init();
        }
        return this.jedisPool.getResource();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void init() {
        RedisSentinelManager redisSentinelManager = this;
        synchronized (redisSentinelManager) {
            if (this.jedisPool == null) {
                String[] sentinelHosts = this.host.split(",\\s*");
                HashSet sentinels = new HashSet();
                Collections.addAll(sentinels, sentinelHosts);
                this.jedisPool = new JedisSentinelPool(this.masterName, sentinels, (GenericObjectPoolConfig)this.getJedisPoolConfig(), this.timeout, this.soTimeout, this.password, this.database);
            }
        }
    }

    public String getHost() {
        return this.host;
    }

    public void setHost(String host) {
        this.host = host;
    }

    public int getTimeout() {
        return this.timeout;
    }

    public void setTimeout(int timeout) {
        this.timeout = timeout;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public int getDatabase() {
        return this.database;
    }

    public void setDatabase(int database) {
        this.database = database;
    }

    public String getMasterName() {
        return this.masterName;
    }

    public void setMasterName(String masterName) {
        this.masterName = masterName;
    }

    public int getSoTimeout() {
        return this.soTimeout;
    }

    public void setSoTimeout(int soTimeout) {
        this.soTimeout = soTimeout;
    }
}

