/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.collections.api.collection;

import java.util.Collection;
import java.util.Spliterator;
import java.util.Spliterators;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import org.eclipse.collections.api.RichIterable;
import org.eclipse.collections.api.bag.ImmutableBag;
import org.eclipse.collections.api.block.function.Function;
import org.eclipse.collections.api.block.function.Function0;
import org.eclipse.collections.api.block.function.Function2;
import org.eclipse.collections.api.block.function.primitive.BooleanFunction;
import org.eclipse.collections.api.block.function.primitive.ByteFunction;
import org.eclipse.collections.api.block.function.primitive.CharFunction;
import org.eclipse.collections.api.block.function.primitive.DoubleFunction;
import org.eclipse.collections.api.block.function.primitive.FloatFunction;
import org.eclipse.collections.api.block.function.primitive.IntFunction;
import org.eclipse.collections.api.block.function.primitive.LongFunction;
import org.eclipse.collections.api.block.function.primitive.ShortFunction;
import org.eclipse.collections.api.block.predicate.Predicate;
import org.eclipse.collections.api.block.predicate.Predicate2;
import org.eclipse.collections.api.block.procedure.Procedure;
import org.eclipse.collections.api.block.procedure.Procedure2;
import org.eclipse.collections.api.collection.primitive.ImmutableBooleanCollection;
import org.eclipse.collections.api.collection.primitive.ImmutableByteCollection;
import org.eclipse.collections.api.collection.primitive.ImmutableCharCollection;
import org.eclipse.collections.api.collection.primitive.ImmutableDoubleCollection;
import org.eclipse.collections.api.collection.primitive.ImmutableFloatCollection;
import org.eclipse.collections.api.collection.primitive.ImmutableIntCollection;
import org.eclipse.collections.api.collection.primitive.ImmutableLongCollection;
import org.eclipse.collections.api.collection.primitive.ImmutableShortCollection;
import org.eclipse.collections.api.map.ImmutableMap;
import org.eclipse.collections.api.map.primitive.ImmutableObjectDoubleMap;
import org.eclipse.collections.api.map.primitive.ImmutableObjectLongMap;
import org.eclipse.collections.api.multimap.ImmutableMultimap;
import org.eclipse.collections.api.partition.PartitionImmutableCollection;
import org.eclipse.collections.api.tuple.Pair;

public interface ImmutableCollection<T>
extends RichIterable<T> {
    public ImmutableCollection<T> newWith(T var1);

    public ImmutableCollection<T> newWithout(T var1);

    public ImmutableCollection<T> newWithAll(Iterable<? extends T> var1);

    public ImmutableCollection<T> newWithoutAll(Iterable<? extends T> var1);

    @Override
    public ImmutableCollection<T> tap(Procedure<? super T> var1);

    @Override
    public ImmutableCollection<T> select(Predicate<? super T> var1);

    @Override
    public <P> ImmutableCollection<T> selectWith(Predicate2<? super T, ? super P> var1, P var2);

    @Override
    public ImmutableCollection<T> reject(Predicate<? super T> var1);

    @Override
    public <P> ImmutableCollection<T> rejectWith(Predicate2<? super T, ? super P> var1, P var2);

    @Override
    public PartitionImmutableCollection<T> partition(Predicate<? super T> var1);

    @Override
    public <P> PartitionImmutableCollection<T> partitionWith(Predicate2<? super T, ? super P> var1, P var2);

    @Override
    public <S> ImmutableCollection<S> selectInstancesOf(Class<S> var1);

    @Override
    public <V> ImmutableCollection<V> collect(Function<? super T, ? extends V> var1);

    @Override
    public ImmutableBooleanCollection collectBoolean(BooleanFunction<? super T> var1);

    @Override
    public ImmutableByteCollection collectByte(ByteFunction<? super T> var1);

    @Override
    public ImmutableCharCollection collectChar(CharFunction<? super T> var1);

    @Override
    public ImmutableDoubleCollection collectDouble(DoubleFunction<? super T> var1);

    @Override
    public ImmutableFloatCollection collectFloat(FloatFunction<? super T> var1);

    @Override
    public ImmutableIntCollection collectInt(IntFunction<? super T> var1);

    @Override
    public ImmutableLongCollection collectLong(LongFunction<? super T> var1);

    @Override
    public ImmutableShortCollection collectShort(ShortFunction<? super T> var1);

    @Override
    public <P, V> ImmutableCollection<V> collectWith(Function2<? super T, ? super P, ? extends V> var1, P var2);

    @Override
    public <V> ImmutableCollection<V> collectIf(Predicate<? super T> var1, Function<? super T, ? extends V> var2);

    @Override
    public <V> ImmutableCollection<V> flatCollect(Function<? super T, ? extends Iterable<V>> var1);

    @Override
    default public <P, V> ImmutableCollection<V> flatCollectWith(Function2<? super T, ? super P, ? extends Iterable<V>> function, P parameter) {
        return this.flatCollect((T each) -> (Iterable)function.apply((Object)each, (Object)parameter));
    }

    @Override
    public <V> ImmutableObjectLongMap<V> sumByInt(Function<? super T, ? extends V> var1, IntFunction<? super T> var2);

    @Override
    public <V> ImmutableObjectDoubleMap<V> sumByFloat(Function<? super T, ? extends V> var1, FloatFunction<? super T> var2);

    @Override
    public <V> ImmutableObjectLongMap<V> sumByLong(Function<? super T, ? extends V> var1, LongFunction<? super T> var2);

    @Override
    public <V> ImmutableObjectDoubleMap<V> sumByDouble(Function<? super T, ? extends V> var1, DoubleFunction<? super T> var2);

    @Override
    default public <V> ImmutableBag<V> countBy(Function<? super T, ? extends V> function) {
        return this.asLazy().collect((Function)function).toBag().toImmutable();
    }

    @Override
    default public <V, P> ImmutableBag<V> countByWith(Function2<? super T, ? super P, ? extends V> function, P parameter) {
        return this.asLazy().collectWith((Function2)function, (Object)parameter).toBag().toImmutable();
    }

    @Override
    default public <V> ImmutableBag<V> countByEach(Function<? super T, ? extends Iterable<V>> function) {
        return this.asLazy().flatCollect((Function)function).toBag().toImmutable();
    }

    @Override
    public <V> ImmutableMultimap<V, T> groupBy(Function<? super T, ? extends V> var1);

    @Override
    public <V> ImmutableMultimap<V, T> groupByEach(Function<? super T, ? extends Iterable<V>> var1);

    @Override
    public <V> ImmutableMap<V, T> groupByUniqueKey(Function<? super T, ? extends V> var1);

    @Override
    public <S> ImmutableCollection<Pair<T, S>> zip(Iterable<S> var1);

    @Override
    public ImmutableCollection<Pair<T, Integer>> zipWithIndex();

    @Override
    public <K, V> ImmutableMap<K, V> aggregateInPlaceBy(Function<? super T, ? extends K> var1, Function0<? extends V> var2, Procedure2<? super V, ? super T> var3);

    @Override
    public <K, V> ImmutableMap<K, V> aggregateBy(Function<? super T, ? extends K> var1, Function0<? extends V> var2, Function2<? super V, ? super T, ? extends V> var3);

    default public Stream<T> stream() {
        return StreamSupport.stream(this.spliterator(), false);
    }

    default public Stream<T> parallelStream() {
        return StreamSupport.stream(this.spliterator(), true);
    }

    @Override
    default public Spliterator<T> spliterator() {
        return Spliterators.spliterator(this.iterator(), (long)this.size(), 0);
    }

    public Collection<T> castToCollection();
}

