/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.collections.impl.multimap.list;

import java.io.Serializable;
import org.eclipse.collections.api.RichIterable;
import org.eclipse.collections.api.block.function.Function;
import org.eclipse.collections.api.block.function.Function2;
import org.eclipse.collections.api.block.predicate.Predicate2;
import org.eclipse.collections.api.block.procedure.Procedure2;
import org.eclipse.collections.api.list.MutableList;
import org.eclipse.collections.api.multimap.bag.MutableBagMultimap;
import org.eclipse.collections.api.multimap.list.ImmutableListMultimap;
import org.eclipse.collections.api.multimap.list.MutableListMultimap;
import org.eclipse.collections.api.tuple.Pair;
import org.eclipse.collections.impl.multimap.AbstractSynchronizedMultimap;

public class SynchronizedListMultimap<K, V>
extends AbstractSynchronizedMultimap<K, V>
implements MutableListMultimap<K, V>,
Serializable {
    private static final long serialVersionUID = 1L;

    public SynchronizedListMultimap(MutableListMultimap<K, V> multimap) {
        super(multimap);
    }

    public SynchronizedListMultimap(MutableListMultimap<K, V> multimap, Object newLock) {
        super(multimap, newLock);
    }

    public static <K, V> SynchronizedListMultimap<K, V> of(MutableListMultimap<K, V> multimap) {
        if (multimap == null) {
            throw new IllegalArgumentException("cannot create a SynchronizedListMultimap for null");
        }
        return new SynchronizedListMultimap<K, V>(multimap);
    }

    public static <K, V> SynchronizedListMultimap<K, V> of(MutableListMultimap<K, V> multimap, Object lock) {
        if (multimap == null) {
            throw new IllegalArgumentException("cannot create a SynchronizedListMultimap for null");
        }
        return new SynchronizedListMultimap<K, V>(multimap, lock);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MutableListMultimap<K, V> newEmpty() {
        Object object = this.getLock();
        synchronized (object) {
            return this.getDelegate().newEmpty().asSynchronized();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MutableListMultimap<K, V> toMutable() {
        Object object = this.getLock();
        synchronized (object) {
            return this.getDelegate().toMutable();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ImmutableListMultimap<K, V> toImmutable() {
        Object object = this.getLock();
        synchronized (object) {
            return this.getDelegate().toImmutable();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void forEachKeyMutableList(Procedure2<? super K, ? super MutableList<V>> procedure) {
        Object object = this.getLock();
        synchronized (object) {
            this.getDelegate().forEachKeyMutableList(procedure);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MutableList<V> replaceValues(K key, Iterable<? extends V> values) {
        Object object = this.getLock();
        synchronized (object) {
            return this.getDelegate().replaceValues(key, values);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MutableList<V> removeAll(Object key) {
        Object object = this.getLock();
        synchronized (object) {
            return this.getDelegate().removeAll(key);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MutableList<V> get(K key) {
        Object object = this.getLock();
        synchronized (object) {
            return this.getDelegate().get(key);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MutableList<V> getIfAbsentPutAll(K key, Iterable<? extends V> values) {
        Object object = this.getLock();
        synchronized (object) {
            return this.getDelegate().getIfAbsentPutAll(key, values);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MutableBagMultimap<V, K> flip() {
        Object object = this.getLock();
        synchronized (object) {
            return this.getDelegate().flip();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MutableListMultimap<K, V> selectKeysValues(Predicate2<? super K, ? super V> predicate) {
        Object object = this.getLock();
        synchronized (object) {
            return this.getDelegate().selectKeysValues(predicate);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MutableListMultimap<K, V> rejectKeysValues(Predicate2<? super K, ? super V> predicate) {
        Object object = this.getLock();
        synchronized (object) {
            return this.getDelegate().rejectKeysValues(predicate);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MutableListMultimap<K, V> selectKeysMultiValues(Predicate2<? super K, ? super RichIterable<V>> predicate) {
        Object object = this.getLock();
        synchronized (object) {
            return this.getDelegate().selectKeysMultiValues(predicate);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MutableListMultimap<K, V> rejectKeysMultiValues(Predicate2<? super K, ? super RichIterable<V>> predicate) {
        Object object = this.getLock();
        synchronized (object) {
            return this.getDelegate().rejectKeysMultiValues(predicate);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <K2, V2> MutableBagMultimap<K2, V2> collectKeysValues(Function2<? super K, ? super V, Pair<K2, V2>> function) {
        Object object = this.getLock();
        synchronized (object) {
            return this.getDelegate().collectKeysValues(function);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <K2, V2> MutableBagMultimap<K2, V2> collectKeyMultiValues(Function<? super K, ? extends K2> keyFunction, Function<? super V, ? extends V2> valueFunction) {
        Object object = this.getLock();
        synchronized (object) {
            return this.getDelegate().collectKeyMultiValues(keyFunction, valueFunction);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <V2> MutableListMultimap<K, V2> collectValues(Function<? super V, ? extends V2> function) {
        Object object = this.getLock();
        synchronized (object) {
            return this.getDelegate().collectValues(function);
        }
    }

    public MutableListMultimap<K, V> asSynchronized() {
        return this;
    }

    @Override
    protected MutableListMultimap<K, V> getDelegate() {
        return (MutableListMultimap)super.getDelegate();
    }
}

