/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.client.rollup.job.config;

import java.io.IOException;
import java.util.Objects;
import java.util.Optional;
import org.elasticsearch.client.Validatable;
import org.elasticsearch.client.ValidationException;
import org.elasticsearch.common.Nullable;
import org.elasticsearch.common.ParseField;
import org.elasticsearch.common.xcontent.ConstructingObjectParser;
import org.elasticsearch.common.xcontent.ObjectParser;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.ToXContentObject;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.common.xcontent.XContentParser;
import org.elasticsearch.search.aggregations.bucket.histogram.DateHistogramInterval;

public class DateHistogramGroupConfig
implements Validatable,
ToXContentObject {
    static final String NAME = "date_histogram";
    private static final String INTERVAL = "interval";
    private static final String FIELD = "field";
    private static final String TIME_ZONE = "time_zone";
    private static final String DELAY = "delay";
    private static final String DEFAULT_TIMEZONE = "UTC";
    private static final ConstructingObjectParser<DateHistogramGroupConfig, Void> PARSER = new ConstructingObjectParser("date_histogram", true, a -> new DateHistogramGroupConfig((String)a[0], (DateHistogramInterval)a[1], (DateHistogramInterval)a[2], (String)a[3]));
    private final String field;
    private final DateHistogramInterval interval;
    private final DateHistogramInterval delay;
    private final String timeZone;

    public DateHistogramGroupConfig(String field, DateHistogramInterval interval) {
        this(field, interval, null, null);
    }

    public DateHistogramGroupConfig(String field, DateHistogramInterval interval, @Nullable DateHistogramInterval delay, @Nullable String timeZone) {
        this.field = field;
        this.interval = interval;
        this.delay = delay;
        this.timeZone = timeZone != null && !timeZone.isEmpty() ? timeZone : DEFAULT_TIMEZONE;
    }

    @Override
    public Optional<ValidationException> validate() {
        ValidationException validationException = new ValidationException();
        if (this.field == null || this.field.isEmpty()) {
            validationException.addValidationError("Field name is required");
        }
        if (this.interval == null) {
            validationException.addValidationError("Interval is required");
        }
        if (validationException.validationErrors().isEmpty()) {
            return Optional.empty();
        }
        return Optional.of(validationException);
    }

    public String getField() {
        return this.field;
    }

    public DateHistogramInterval getInterval() {
        return this.interval;
    }

    public DateHistogramInterval getDelay() {
        return this.delay;
    }

    public String getTimeZone() {
        return this.timeZone;
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        builder.field(INTERVAL, this.interval.toString());
        builder.field(FIELD, this.field);
        if (this.delay != null) {
            builder.field(DELAY, this.delay.toString());
        }
        builder.field(TIME_ZONE, this.timeZone);
        return builder.endObject();
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other == null || this.getClass() != other.getClass()) {
            return false;
        }
        DateHistogramGroupConfig that = (DateHistogramGroupConfig)other;
        return Objects.equals(this.interval, that.interval) && Objects.equals(this.field, that.field) && Objects.equals(this.delay, that.delay) && Objects.equals(this.timeZone, that.timeZone);
    }

    public int hashCode() {
        return Objects.hash(this.interval, this.field, this.delay, this.timeZone);
    }

    public static DateHistogramGroupConfig fromXContent(XContentParser parser) throws IOException {
        return (DateHistogramGroupConfig)PARSER.parse(parser, null);
    }

    static {
        PARSER.declareString(ConstructingObjectParser.constructorArg(), new ParseField(FIELD, new String[0]));
        PARSER.declareField(ConstructingObjectParser.constructorArg(), p -> new DateHistogramInterval(p.text()), new ParseField(INTERVAL, new String[0]), ObjectParser.ValueType.STRING);
        PARSER.declareField(ConstructingObjectParser.optionalConstructorArg(), p -> new DateHistogramInterval(p.text()), new ParseField(DELAY, new String[0]), ObjectParser.ValueType.STRING);
        PARSER.declareString(ConstructingObjectParser.optionalConstructorArg(), new ParseField(TIME_ZONE, new String[0]));
    }
}

