/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.client.indices;

import java.io.IOException;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.elasticsearch.cluster.health.ClusterHealthStatus;
import org.elasticsearch.common.xcontent.ConstructingObjectParser;
import org.elasticsearch.common.xcontent.ParseField;
import org.elasticsearch.common.xcontent.XContentParser;
import org.elasticsearch.core.Nullable;

public final class DataStream {
    private final String name;
    private final String timeStampField;
    private final List<String> indices;
    private final long generation;
    private final boolean hidden;
    private final boolean system;
    ClusterHealthStatus dataStreamStatus;
    @Nullable
    String indexTemplate;
    @Nullable
    String ilmPolicyName;
    @Nullable
    private final Map<String, Object> metadata;
    public static final ParseField NAME_FIELD = new ParseField("name", new String[0]);
    public static final ParseField TIMESTAMP_FIELD_FIELD = new ParseField("timestamp_field", new String[0]);
    public static final ParseField INDICES_FIELD = new ParseField("indices", new String[0]);
    public static final ParseField GENERATION_FIELD = new ParseField("generation", new String[0]);
    public static final ParseField STATUS_FIELD = new ParseField("status", new String[0]);
    public static final ParseField INDEX_TEMPLATE_FIELD = new ParseField("template", new String[0]);
    public static final ParseField ILM_POLICY_FIELD = new ParseField("ilm_policy", new String[0]);
    public static final ParseField METADATA_FIELD = new ParseField("_meta", new String[0]);
    public static final ParseField HIDDEN_FIELD = new ParseField("hidden", new String[0]);
    public static final ParseField SYSTEM_FIELD = new ParseField("system", new String[0]);
    private static final ConstructingObjectParser<DataStream, Void> PARSER = new ConstructingObjectParser("data_stream", args -> {
        String dataStreamName = (String)args[0];
        String timeStampField = (String)((Map)args[1]).get("name");
        List<String> indices = ((List)args[2]).stream().map(m -> (String)m.get("index_name")).collect(Collectors.toList());
        Long generation = (Long)args[3];
        String statusStr = (String)args[4];
        ClusterHealthStatus status = ClusterHealthStatus.fromString((String)statusStr);
        String indexTemplate = (String)args[5];
        String ilmPolicy = (String)args[6];
        Map metadata = (Map)args[7];
        boolean hidden = args[8] != null && (Boolean)args[8] != false;
        boolean system = args[9] != null && (Boolean)args[9] != false;
        return new DataStream(dataStreamName, timeStampField, indices, generation, status, indexTemplate, ilmPolicy, metadata, hidden, system);
    });

    public DataStream(String name, String timeStampField, List<String> indices, long generation, ClusterHealthStatus dataStreamStatus, @Nullable String indexTemplate, @Nullable String ilmPolicyName, @Nullable Map<String, Object> metadata, boolean hidden, boolean system) {
        this.name = name;
        this.timeStampField = timeStampField;
        this.indices = indices;
        this.generation = generation;
        this.dataStreamStatus = dataStreamStatus;
        this.indexTemplate = indexTemplate;
        this.ilmPolicyName = ilmPolicyName;
        this.metadata = metadata;
        this.hidden = hidden;
        this.system = system;
    }

    public String getName() {
        return this.name;
    }

    public String getTimeStampField() {
        return this.timeStampField;
    }

    public List<String> getIndices() {
        return this.indices;
    }

    public long getGeneration() {
        return this.generation;
    }

    public ClusterHealthStatus getDataStreamStatus() {
        return this.dataStreamStatus;
    }

    public String getIndexTemplate() {
        return this.indexTemplate;
    }

    public String getIlmPolicyName() {
        return this.ilmPolicyName;
    }

    public Map<String, Object> getMetadata() {
        return this.metadata;
    }

    public boolean isHidden() {
        return this.hidden;
    }

    public boolean isSystem() {
        return this.system;
    }

    public static DataStream fromXContent(XContentParser parser) throws IOException {
        return (DataStream)PARSER.parse(parser, null);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DataStream that = (DataStream)o;
        return this.generation == that.generation && this.name.equals(that.name) && this.timeStampField.equals(that.timeStampField) && this.indices.equals(that.indices) && this.dataStreamStatus == that.dataStreamStatus && this.hidden == that.hidden && this.system == that.system && Objects.equals(this.indexTemplate, that.indexTemplate) && Objects.equals(this.ilmPolicyName, that.ilmPolicyName) && Objects.equals(this.metadata, that.metadata);
    }

    public int hashCode() {
        return Objects.hash(this.name, this.timeStampField, this.indices, this.generation, this.dataStreamStatus, this.indexTemplate, this.ilmPolicyName, this.metadata, this.hidden, this.system);
    }

    static {
        PARSER.declareString(ConstructingObjectParser.constructorArg(), NAME_FIELD);
        PARSER.declareObject(ConstructingObjectParser.constructorArg(), (p, c) -> p.map(), TIMESTAMP_FIELD_FIELD);
        PARSER.declareObjectArray(ConstructingObjectParser.constructorArg(), (p, c) -> p.mapStrings(), INDICES_FIELD);
        PARSER.declareLong(ConstructingObjectParser.constructorArg(), GENERATION_FIELD);
        PARSER.declareString(ConstructingObjectParser.constructorArg(), STATUS_FIELD);
        PARSER.declareString(ConstructingObjectParser.optionalConstructorArg(), INDEX_TEMPLATE_FIELD);
        PARSER.declareString(ConstructingObjectParser.optionalConstructorArg(), ILM_POLICY_FIELD);
        PARSER.declareObject(ConstructingObjectParser.optionalConstructorArg(), (p, c) -> p.map(), METADATA_FIELD);
        PARSER.declareBoolean(ConstructingObjectParser.optionalConstructorArg(), HIDDEN_FIELD);
        PARSER.declareBoolean(ConstructingObjectParser.optionalConstructorArg(), SYSTEM_FIELD);
    }
}

