/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.client.indices;

import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.elasticsearch.client.core.BroadcastResponse;
import org.elasticsearch.common.xcontent.ConstructingObjectParser;
import org.elasticsearch.common.xcontent.ParseField;
import org.elasticsearch.common.xcontent.XContentParser;
import org.elasticsearch.core.Tuple;

public class ReloadAnalyzersResponse
extends BroadcastResponse {
    private final Map<String, ReloadDetails> reloadDetails;
    private static final ConstructingObjectParser<ReloadAnalyzersResponse, Void> PARSER = new ConstructingObjectParser("reload_analyzer", true, arg -> {
        BroadcastResponse.Shards shards = (BroadcastResponse.Shards)arg[0];
        List results = (List)arg[1];
        HashMap<String, ReloadDetails> reloadDetails = new HashMap<String, ReloadDetails>();
        for (Tuple result : results) {
            reloadDetails.put((String)result.v1(), (ReloadDetails)result.v2());
        }
        return new ReloadAnalyzersResponse(shards, reloadDetails);
    });
    private static final ConstructingObjectParser<Tuple<String, ReloadDetails>, Void> ENTRY_PARSER = new ConstructingObjectParser("reload_analyzer.entry", true, arg -> {
        String index = (String)arg[0];
        HashSet<String> nodeIds = new HashSet<String>((List)arg[1]);
        HashSet<String> analyzers = new HashSet<String>((List)arg[2]);
        return new Tuple((Object)index, (Object)new ReloadDetails(index, nodeIds, analyzers));
    });

    ReloadAnalyzersResponse(BroadcastResponse.Shards shards, Map<String, ReloadDetails> reloadDetails) {
        super(shards);
        this.reloadDetails = reloadDetails;
    }

    public static ReloadAnalyzersResponse fromXContent(XContentParser parser) {
        return (ReloadAnalyzersResponse)PARSER.apply(parser, null);
    }

    public Map<String, ReloadDetails> getReloadedDetails() {
        return this.reloadDetails;
    }

    static {
        ReloadAnalyzersResponse.declareShardsField(PARSER);
        PARSER.declareObjectArray(ConstructingObjectParser.constructorArg(), ENTRY_PARSER, new ParseField("reload_details", new String[0]));
        ENTRY_PARSER.declareString(ConstructingObjectParser.constructorArg(), new ParseField("index", new String[0]));
        ENTRY_PARSER.declareStringArray(ConstructingObjectParser.constructorArg(), new ParseField("reloaded_node_ids", new String[0]));
        ENTRY_PARSER.declareStringArray(ConstructingObjectParser.constructorArg(), new ParseField("reloaded_analyzers", new String[0]));
    }

    public static class ReloadDetails {
        private final String indexName;
        private final Set<String> reloadedIndicesNodes;
        private final Set<String> reloadedAnalyzers;

        public ReloadDetails(String name, Set<String> reloadedIndicesNodes, Set<String> reloadedAnalyzers) {
            this.indexName = name;
            this.reloadedIndicesNodes = reloadedIndicesNodes;
            this.reloadedAnalyzers = reloadedAnalyzers;
        }

        public String getIndexName() {
            return this.indexName;
        }

        public Set<String> getReloadedIndicesNodes() {
            return this.reloadedIndicesNodes;
        }

        public Set<String> getReloadedAnalyzers() {
            return this.reloadedAnalyzers;
        }
    }
}

