/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.client.ml.dataframe.stats.common;

import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import org.elasticsearch.common.xcontent.ConstructingObjectParser;
import org.elasticsearch.common.xcontent.ParseField;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.ToXContentObject;
import org.elasticsearch.common.xcontent.XContentBuilder;

public class FoldValues
implements ToXContentObject {
    public static final ParseField FOLD = new ParseField("fold", new String[0]);
    public static final ParseField VALUES = new ParseField("values", new String[0]);
    public static ConstructingObjectParser<FoldValues, Void> PARSER = new ConstructingObjectParser("fold_values", true, a -> new FoldValues((int)((Integer)a[0]), (List)a[1]));
    private final int fold;
    private final double[] values;

    private FoldValues(int fold, List<Double> values) {
        this(fold, values.stream().mapToDouble(Double::doubleValue).toArray());
    }

    public FoldValues(int fold, double[] values) {
        this.fold = fold;
        this.values = values;
    }

    public int getFold() {
        return this.fold;
    }

    public double[] getValues() {
        return this.values;
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        builder.field(FOLD.getPreferredName(), this.fold);
        builder.array(VALUES.getPreferredName(), this.values);
        builder.endObject();
        return builder;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        FoldValues other = (FoldValues)o;
        return this.fold == other.fold && Arrays.equals(this.values, other.values);
    }

    public int hashCode() {
        return Objects.hash(this.fold, Arrays.hashCode(this.values));
    }

    static {
        PARSER.declareInt(ConstructingObjectParser.constructorArg(), FOLD);
        PARSER.declareDoubleArray(ConstructingObjectParser.constructorArg(), VALUES);
    }
}

