/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.client.cluster;

import java.util.Objects;
import org.elasticsearch.client.cluster.RemoteConnectionInfo;

public class ProxyModeInfo
implements RemoteConnectionInfo.ModeInfo {
    static final String NAME = "proxy";
    static final String ADDRESS = "address";
    static final String NUM_SOCKETS_CONNECTED = "num_sockets_connected";
    static final String MAX_SOCKET_CONNECTIONS = "max_socket_connections";
    private final String address;
    private final int maxSocketConnections;
    private final int numSocketsConnected;

    ProxyModeInfo(String address, int maxSocketConnections, int numSocketsConnected) {
        this.address = address;
        this.maxSocketConnections = maxSocketConnections;
        this.numSocketsConnected = numSocketsConnected;
    }

    @Override
    public boolean isConnected() {
        return this.numSocketsConnected > 0;
    }

    @Override
    public String modeName() {
        return NAME;
    }

    public String getAddress() {
        return this.address;
    }

    public int getMaxSocketConnections() {
        return this.maxSocketConnections;
    }

    public int getNumSocketsConnected() {
        return this.numSocketsConnected;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ProxyModeInfo otherProxy = (ProxyModeInfo)o;
        return this.maxSocketConnections == otherProxy.maxSocketConnections && this.numSocketsConnected == otherProxy.numSocketsConnected && Objects.equals(this.address, otherProxy.address);
    }

    public int hashCode() {
        return Objects.hash(this.address, this.maxSocketConnections, this.numSocketsConnected);
    }
}

