/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.client.transform.transforms;

import java.io.IOException;
import java.util.Objects;
import org.elasticsearch.common.ParseField;
import org.elasticsearch.common.xcontent.ConstructingObjectParser;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.ToXContentObject;
import org.elasticsearch.common.xcontent.XContentBuilder;

public class DestConfig
implements ToXContentObject {
    public static final ParseField INDEX = new ParseField("index", new String[0]);
    public static final ParseField PIPELINE = new ParseField("pipeline", new String[0]);
    public static final ConstructingObjectParser<DestConfig, Void> PARSER = new ConstructingObjectParser("transform_config_dest", true, args -> new DestConfig((String)args[0], (String)args[1]));
    private final String index;
    private final String pipeline;

    DestConfig(String index, String pipeline) {
        this.index = Objects.requireNonNull(index, INDEX.getPreferredName());
        this.pipeline = pipeline;
    }

    public String getIndex() {
        return this.index;
    }

    public String getPipeline() {
        return this.pipeline;
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        builder.field(INDEX.getPreferredName(), this.index);
        if (this.pipeline != null) {
            builder.field(PIPELINE.getPreferredName(), this.pipeline);
        }
        builder.endObject();
        return builder;
    }

    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if (other == null || other.getClass() != this.getClass()) {
            return false;
        }
        DestConfig that = (DestConfig)other;
        return Objects.equals(this.index, that.index) && Objects.equals(this.pipeline, that.pipeline);
    }

    public int hashCode() {
        return Objects.hash(this.index, this.pipeline);
    }

    public static Builder builder() {
        return new Builder();
    }

    static {
        PARSER.declareString(ConstructingObjectParser.constructorArg(), INDEX);
        PARSER.declareString(ConstructingObjectParser.optionalConstructorArg(), PIPELINE);
    }

    public static class Builder {
        private String index;
        private String pipeline;

        public Builder setIndex(String index) {
            this.index = Objects.requireNonNull(index, INDEX.getPreferredName());
            return this;
        }

        public Builder setPipeline(String pipeline) {
            this.pipeline = pipeline;
            return this;
        }

        public DestConfig build() {
            return new DestConfig(this.index, this.pipeline);
        }
    }
}

