/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.core;

import java.net.URI;
import java.nio.file.FileSystem;
import java.nio.file.FileSystems;
import java.nio.file.Path;
import java.nio.file.Paths;
import org.elasticsearch.core.SuppressForbidden;

@SuppressForbidden(reason="accesses the default filesystem by design")
public final class PathUtils {
    static final FileSystem ACTUAL_DEFAULT;
    static volatile FileSystem DEFAULT;

    private PathUtils() {
    }

    public static Path get(String first, String ... more) {
        return DEFAULT.getPath(first, more);
    }

    public static Path get(URI uri) {
        if (uri.getScheme().equalsIgnoreCase("file")) {
            return DEFAULT.provider().getPath(uri);
        }
        return Paths.get(uri);
    }

    public static Path get(Path[] roots, String path) {
        for (Path root : roots) {
            Path normalizedRoot = root.normalize();
            Path normalizedPath = normalizedRoot.resolve(path).normalize();
            if (!normalizedPath.startsWith(normalizedRoot)) continue;
            return normalizedPath;
        }
        return null;
    }

    public static Path get(Path[] roots, URI uri) {
        return PathUtils.get(roots, PathUtils.get(uri).normalize().toString());
    }

    public static FileSystem getDefaultFileSystem() {
        return DEFAULT;
    }

    static {
        DEFAULT = ACTUAL_DEFAULT = FileSystems.getDefault();
    }
}

