/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.core.action;

import java.io.IOException;
import java.util.Arrays;
import java.util.Objects;
import org.elasticsearch.action.ActionRequestValidationException;
import org.elasticsearch.action.ActionType;
import org.elasticsearch.action.IndicesRequest;
import org.elasticsearch.action.ValidateActions;
import org.elasticsearch.action.support.IndicesOptions;
import org.elasticsearch.action.support.master.AcknowledgedResponse;
import org.elasticsearch.action.support.master.MasterNodeRequest;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.util.CollectionUtils;

public class DeleteDataStreamAction
extends ActionType<AcknowledgedResponse> {
    public static final DeleteDataStreamAction INSTANCE = new DeleteDataStreamAction();
    public static final String NAME = "indices:admin/data_stream/delete";

    private DeleteDataStreamAction() {
        super(NAME, AcknowledgedResponse::new);
    }

    public static class Request
    extends MasterNodeRequest<Request>
    implements IndicesRequest.Replaceable {
        private String[] names;

        public Request(String[] names) {
            this.names = Objects.requireNonNull(names);
        }

        public String[] getNames() {
            return this.names;
        }

        public ActionRequestValidationException validate() {
            ActionRequestValidationException validationException = null;
            if (CollectionUtils.isEmpty((Object[])this.names)) {
                validationException = ValidateActions.addValidationError((String)"no data stream(s) specified", validationException);
            }
            return validationException;
        }

        public Request(StreamInput in) throws IOException {
            super(in);
            this.names = in.readStringArray();
        }

        public void writeTo(StreamOutput out) throws IOException {
            super.writeTo(out);
            out.writeStringArray(this.names);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
                return false;
            }
            Request request = (Request)((Object)o);
            return Arrays.equals(this.names, request.names);
        }

        public int hashCode() {
            return Arrays.hashCode(this.names);
        }

        public String[] indices() {
            return this.names;
        }

        public IndicesOptions indicesOptions() {
            return IndicesOptions.fromOptions((boolean)false, (boolean)true, (boolean)true, (boolean)true, (boolean)false, (boolean)false, (boolean)true, (boolean)false);
        }

        public boolean includeDataStreams() {
            return true;
        }

        public IndicesRequest indices(String ... indices) {
            this.names = indices;
            return this;
        }
    }
}

